/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.BLASkernel;
import org.netlib.blas.Dasum;
import org.netlib.blas.Daxpy;
import org.netlib.blas.Dcopy;
import org.netlib.blas.Ddot;
import org.netlib.blas.Dgbmv;
import org.netlib.blas.Dgemm;
import org.netlib.blas.Dgemv;
import org.netlib.blas.Dger;
import org.netlib.blas.Dnrm2;
import org.netlib.blas.Dsbmv;
import org.netlib.blas.Dscal;
import org.netlib.blas.Dspmv;
import org.netlib.blas.Dspr;
import org.netlib.blas.Dspr2;
import org.netlib.blas.Dswap;
import org.netlib.blas.Dsymm;
import org.netlib.blas.Dsymv;
import org.netlib.blas.Dsyr;
import org.netlib.blas.Dsyr2;
import org.netlib.blas.Dsyr2k;
import org.netlib.blas.Dsyrk;
import org.netlib.blas.Dtbmv;
import org.netlib.blas.Dtbsv;
import org.netlib.blas.Dtpmv;
import org.netlib.blas.Dtpsv;
import org.netlib.blas.Dtrmm;
import org.netlib.blas.Dtrmv;
import org.netlib.blas.Dtrsm;
import org.netlib.blas.Dtrsv;
import org.netlib.blas.Idamax;

class JLAPACK_BLASkernel
implements BLASkernel {
    JLAPACK_BLASkernel() {
    }

    public double dot(int N2, double[] X, double[] Y) {
        return Ddot.ddot(N2, X, 0, 1, Y, 0, 1);
    }

    public double nrm2(int N2, double[] X) {
        return Dnrm2.dnrm2(N2, X, 0, 1);
    }

    public double asum(int N2, double[] X) {
        return Dasum.dasum(N2, X, 0, 1);
    }

    public int idamax(int N2, double[] X) {
        return Idamax.idamax(N2, X, 0, 1);
    }

    public void swap(int N2, double[] X, double[] Y) {
        Dswap.dswap(N2, X, 0, 1, Y, 0, 1);
    }

    public void copy(int N2, double[] X, double[] Y) {
        Dcopy.dcopy(N2, X, 0, 1, Y, 0, 1);
    }

    public void axpy(int N2, double alpha, double[] X, double[] Y) {
        Daxpy.daxpy(N2, alpha, X, 0, 1, Y, 0, 1);
    }

    public void scal(int N2, double alpha, double[] X) {
        Dscal.dscal(N2, alpha, X, 0, 1);
    }

    public void gemv(BLASkernel.Transpose TransA, int M, int N2, double alpha, double[] A, int lda, double[] X, double beta, double[] Y) {
        Dgemv.dgemv(this.trans(TransA), M, N2, alpha, A, 0, lda, X, 0, 1, beta, Y, 0, 1);
    }

    public void gbmv(BLASkernel.Transpose TransA, int M, int N2, int KL, int KU, double alpha, double[] A, int lda, double[] X, double beta, double[] Y) {
        Dgbmv.dgbmv(this.trans(TransA), M, N2, KL, KU, alpha, A, 0, lda, X, 0, 1, beta, Y, 0, 1);
    }

    public void trmv(BLASkernel.UpLo uplo, BLASkernel.Transpose TransA, BLASkernel.Diag diag, int N2, double[] A, int lda, double[] X) {
        Dtrmv.dtrmv(this.uplo(uplo), this.trans(TransA), this.diag(diag), N2, A, 0, lda, X, 0, 1);
    }

    public void tbmv(BLASkernel.UpLo uplo, BLASkernel.Transpose TransA, BLASkernel.Diag diag, int N2, int K, double[] A, int lda, double[] X) {
        Dtbmv.dtbmv(this.uplo(uplo), this.trans(TransA), this.diag(diag), N2, K, A, 0, lda, X, 0, 1);
    }

    public void tpmv(BLASkernel.UpLo uplo, BLASkernel.Transpose TransA, BLASkernel.Diag diag, int N2, double[] Ap, double[] X) {
        Dtpmv.dtpmv(this.uplo(uplo), this.trans(TransA), this.diag(diag), N2, Ap, 0, X, 0, 1);
    }

    public void trsv(BLASkernel.UpLo uplo, BLASkernel.Transpose TransA, BLASkernel.Diag diag, int N2, double[] A, int lda, double[] X) {
        Dtrsv.dtrsv(this.uplo(uplo), this.trans(TransA), this.diag(diag), N2, A, 0, lda, X, 0, 1);
    }

    public void tbsv(BLASkernel.UpLo uplo, BLASkernel.Transpose TransA, BLASkernel.Diag diag, int N2, int K, double[] A, int lda, double[] X) {
        Dtbsv.dtbsv(this.uplo(uplo), this.trans(TransA), this.diag(diag), N2, K, A, 0, lda, X, 0, 1);
    }

    public void tpsv(BLASkernel.UpLo uplo, BLASkernel.Transpose TransA, BLASkernel.Diag diag, int N2, double[] Ap, double[] X) {
        Dtpsv.dtpsv(this.uplo(uplo), this.trans(TransA), this.diag(diag), N2, Ap, 0, X, 0, 1);
    }

    public void symv(BLASkernel.UpLo uplo, int N2, double alpha, double[] A, int lda, double[] X, double beta, double[] Y) {
        Dsymv.dsymv(this.uplo(uplo), N2, alpha, A, 0, lda, X, 0, 1, beta, Y, 0, 1);
    }

    public void sbmv(BLASkernel.UpLo uplo, int N2, int K, double alpha, double[] A, int lda, double[] X, double beta, double[] Y) {
        Dsbmv.dsbmv(this.uplo(uplo), N2, K, alpha, A, 0, lda, X, 0, 1, beta, Y, 0, 1);
    }

    public void spmv(BLASkernel.UpLo uplo, int N2, double alpha, double[] Ap, double[] X, double beta, double[] Y) {
        Dspmv.dspmv(this.uplo(uplo), N2, alpha, Ap, 0, X, 0, 1, beta, Y, 0, 1);
    }

    public void ger(int M, int N2, double alpha, double[] X, double[] Y, double[] A, int lda) {
        Dger.dger(M, N2, alpha, X, 0, 1, Y, 0, 1, A, 0, lda);
    }

    public void syr(BLASkernel.UpLo uplo, int N2, double alpha, double[] X, double[] A, int lda) {
        Dsyr.dsyr(this.uplo(uplo), N2, alpha, X, 0, 1, A, 0, lda);
    }

    public void spr(BLASkernel.UpLo uplo, int N2, double alpha, double[] X, double[] Ap) {
        Dspr.dspr(this.uplo(uplo), N2, alpha, X, 0, 1, Ap, 0);
    }

    public void syr2(BLASkernel.UpLo uplo, int N2, double alpha, double[] X, double[] Y, double[] A, int lda) {
        Dsyr2.dsyr2(this.uplo(uplo), N2, alpha, X, 0, 1, Y, 0, 1, A, 0, lda);
    }

    public void spr2(BLASkernel.UpLo uplo, int N2, double alpha, double[] X, double[] Y, double[] A) {
        Dspr2.dspr2(this.uplo(uplo), N2, alpha, X, 0, 1, Y, 0, 1, A, 0);
    }

    public void gemm(BLASkernel.Transpose TransA, BLASkernel.Transpose TransB, int M, int N2, int K, double alpha, double[] A, int lda, double[] B, int ldb, double beta, double[] C, int ldc) {
        Dgemm.dgemm(this.trans(TransA), this.trans(TransB), M, N2, K, alpha, A, 0, lda, B, 0, ldb, beta, C, 0, ldc);
    }

    public void symm(BLASkernel.Side side, BLASkernel.UpLo uplo, int M, int N2, double alpha, double[] A, int lda, double[] B, int ldb, double beta, double[] C, int ldc) {
        Dsymm.dsymm(this.side(side), this.uplo(uplo), M, N2, alpha, A, 0, lda, B, 0, ldb, beta, C, 0, ldc);
    }

    public void syrk(BLASkernel.UpLo uplo, BLASkernel.Transpose Trans, int N2, int K, double alpha, double[] A, int lda, double beta, double[] C, int ldc) {
        Dsyrk.dsyrk(this.uplo(uplo), this.trans(Trans), N2, K, alpha, A, 0, lda, beta, C, 0, ldc);
    }

    public void syr2k(BLASkernel.UpLo uplo, BLASkernel.Transpose Trans, int N2, int K, double alpha, double[] A, int lda, double[] B, int ldb, double beta, double[] C, int ldc) {
        Dsyr2k.dsyr2k(this.uplo(uplo), this.trans(Trans), N2, K, alpha, A, 0, lda, B, 0, ldb, beta, C, 0, ldc);
    }

    public void trmm(BLASkernel.Side side, BLASkernel.UpLo uplo, BLASkernel.Transpose TransA, BLASkernel.Diag diag, int M, int N2, double alpha, double[] A, int lda, double[] B, int ldb) {
        Dtrmm.dtrmm(this.side(side), this.uplo(uplo), this.trans(TransA), this.diag(diag), M, N2, alpha, A, 0, lda, B, 0, ldb);
    }

    public void trsm(BLASkernel.Side side, BLASkernel.UpLo uplo, BLASkernel.Transpose TransA, BLASkernel.Diag diag, int M, int N2, double alpha, double[] A, int lda, double[] B, int ldb) {
        Dtrsm.dtrsm(this.side(side), this.uplo(uplo), this.trans(TransA), this.diag(diag), M, N2, alpha, A, 0, lda, B, 0, ldb);
    }

    private String trans(BLASkernel.Transpose trans) {
        if (trans == BLASkernel.Transpose.NoTranspose) {
            return "N";
        }
        return "T";
    }

    private String uplo(BLASkernel.UpLo uplo) {
        if (uplo == BLASkernel.UpLo.Lower) {
            return "L";
        }
        return "U";
    }

    private String diag(BLASkernel.Diag diag) {
        if (diag == BLASkernel.Diag.NonUnit) {
            return "N";
        }
        return "U";
    }

    private String side(BLASkernel.Side side) {
        if (side == BLASkernel.Side.Left) {
            return "L";
        }
        return "R";
    }
}

