/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.sequences;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class State
implements Comparable {
    private String stateCode;
    private String name;
    private Set<State> ambiguities;
    private int index;

    State(String name, String stateCode, int index) {
        this.name = name;
        this.stateCode = stateCode;
        this.ambiguities = Collections.singleton(this);
        this.index = index;
    }

    State(String name, String stateCode, int index, State[] ambiguities) {
        this.name = name;
        this.stateCode = stateCode;
        this.ambiguities = Collections.unmodifiableSortedSet(new TreeSet<State>(Arrays.asList(ambiguities)));
        this.index = index;
    }

    public String getCode() {
        return this.stateCode;
    }

    public int getIndex() {
        return this.index;
    }

    public String getFullName() {
        return this.name;
    }

    @Deprecated
    public String getName() {
        return this.stateCode;
    }

    public boolean isAmbiguous() {
        return this.getCanonicalStates().size() > 1;
    }

    public Set<State> getCanonicalStates() {
        return this.ambiguities;
    }

    public boolean possiblyEqual(State other) {
        for (State state : this.getCanonicalStates()) {
            for (State state1 : other.getCanonicalStates()) {
                if (!state.equals(state1)) continue;
                return true;
            }
        }
        return false;
    }

    public int compareTo(Object o) {
        return this.index - ((State)o).index;
    }

    public String toString() {
        return this.stateCode;
    }

    public abstract boolean isGap();

    public double fractionEqual(State other) {
        int totalStates = 0;
        int sameStates = 0;
        if (this.isGap() || other.isGap()) {
            return 1.0;
        }
        for (State state : this.getCanonicalStates()) {
            for (State state1 : other.getCanonicalStates()) {
                ++totalStates;
                if (!state.equals(state1)) continue;
                ++sameStates;
            }
        }
        return (double)sameStates / (double)totalStates;
    }
}

