/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.align;

import jebl.evolution.align.AlignAffine;
import jebl.evolution.align.AlignmentResult;
import jebl.evolution.align.Profile;
import jebl.evolution.align.ProfileCharacter;
import jebl.evolution.align.scores.Scores;

public class NeedlemanWunschAffine
extends AlignAffine {
    private boolean invert;
    int[][][] Bi;
    int[][][] Bj;
    int[][][] Bk;
    private int allocatedn = -1;
    private int allocatedm = -1;
    int B0k;
    int B0i;
    int B0j;
    private static final int TYPE_ANY = 0;
    private static final int TYPE_X = 1;
    private static final int TYPE_Y = 2;

    public NeedlemanWunschAffine(Scores sub, float d, float e) {
        super(sub, d, e);
    }

    public void doAlignment(String sq1, String sq2) {
        this.seq1 = sq1;
        this.seq2 = sq2;
        this.doAlignment(sq1, sq2, 0, 0);
    }

    public void allocateMatrices(int n, int m) {
        if (n > this.allocatedn || m > this.allocatedm) {
            n = NeedlemanWunschAffine.maxi(n, this.allocatedn + 5);
            m = NeedlemanWunschAffine.maxi(m, this.allocatedm + 5);
            this.allocatedn = n;
            this.allocatedm = m;
            this.F = new float[3][n + 1][m + 1];
            this.Bi = new int[3][n + 1][m + 1];
            this.Bj = new int[3][n + 1][m + 1];
            this.Bk = new int[3][n + 1][m + 1];
        }
    }

    public void prepareAlignment(String sq1, String sq2) {
        this.n = sq1.length();
        this.m = sq2.length();
        this.seq1 = sq1;
        this.seq2 = sq2;
        this.allocateMatrices(this.n, this.m);
    }

    public void doAlignment(String sequence1, String sequence2, int startType, int endType) {
        this.seq1 = sequence1;
        this.seq2 = sequence2;
        this.doAlignment(Profile.createImmutableProfile(0, sequence1), Profile.createImmutableProfile(0, sequence2), 0, 0, sequence1.length(), sequence2.length(), startType, endType);
    }

    public void doAlignment(Profile sequence1, Profile sequence2, int offset1, int offset2, int n, int m, int startType, int endType) {
        this.doAlignment(sequence1, sequence2, offset1, offset2, n, m, startType, endType, false, false);
    }

    private int convertType(int type) {
        if (type == 0) {
            return type;
        }
        if (type == 1) {
            return 2;
        }
        if (type == 2) {
            return 1;
        }
        throw new RuntimeException("invalid type");
    }

    public void doAlignment(Profile sequence1, Profile sequence2, int offset1, int offset2, int n, int m, int startType, int endType, boolean freeStartGap, boolean freeEndGap) {
        int j;
        float base;
        int i;
        this.invert = false;
        if (n > m) {
            this.invert = true;
            int temp = m;
            m = n;
            n = temp;
            temp = offset1;
            offset1 = offset2;
            offset2 = temp;
            startType = this.convertType(startType);
            endType = this.convertType(endType);
            Profile tempSequence = sequence1;
            sequence1 = sequence2;
            sequence2 = tempSequence;
        }
        this.n = n;
        this.m = m;
        this.allocateMatrices(n, m);
        float[][] score = this.sub.score;
        float[][] M = this.F[0];
        float[][] Ix = this.F[1];
        float[][] Iy = this.F[2];
        M[0][0] = 0.0f;
        Ix[0][0] = 0.0f;
        Iy[0][0] = 0.0f;
        for (i = 1; i <= n; ++i) {
            base = this.d;
            if (startType == 1) {
                base = this.e;
            }
            Ix[i][0] = -base - this.e * (float)(i - 1);
            if (freeStartGap) {
                Ix[i][0] = 0.0f;
            }
            this.Bk[1][i][0] = 1;
            this.Bi[1][i][0] = i - 1;
            this.Bj[1][i][0] = 0;
        }
        for (i = 1; i <= n; ++i) {
            M[i][0] = Float.NEGATIVE_INFINITY;
            Iy[i][0] = Float.NEGATIVE_INFINITY;
        }
        for (j = 1; j <= m; ++j) {
            base = this.d;
            if (startType == 2) {
                base = this.e;
            }
            Iy[0][j] = -base - this.e * (float)(j - 1);
            if (freeStartGap) {
                Iy[0][j] = 0.0f;
            }
            this.Bk[2][0][j] = 2;
            this.Bi[2][0][j] = 0;
            this.Bj[2][0][j] = j - 1;
        }
        for (j = 1; j <= m; ++j) {
            M[0][j] = Float.NEGATIVE_INFINITY;
            Ix[0][j] = Float.NEGATIVE_INFINITY;
        }
        for (i = 1; i <= n; ++i) {
            for (int j2 = 1; j2 <= m; ++j2) {
                float s = ProfileCharacter.score(sequence1.profile[offset1 + i - 1], sequence2.profile[offset2 + j2 - 1], this.sub);
                float a = M[i - 1][j2 - 1] + s;
                float b = Ix[i - 1][j2 - 1] + s;
                float c = Iy[i - 1][j2 - 1] + s;
                float f = NeedlemanWunschAffine.max(a, b, c);
                M[i][j2] = f;
                float val = f;
                this.Bi[0][i][j2] = i - 1;
                this.Bj[0][i][j2] = j2 - 1;
                if (val == a) {
                    this.Bk[0][i][j2] = 0;
                } else if (val == b) {
                    this.Bk[0][i][j2] = 1;
                } else if (val == c) {
                    this.Bk[0][i][j2] = 2;
                } else {
                    throw new Error("NWAffine 1");
                }
                float xd = this.d;
                float xe = this.e;
                if (j2 == m && freeEndGap) {
                    xd = 0.0f;
                    xe = 0.0f;
                }
                a = M[i - 1][j2] - xd;
                b = Ix[i - 1][j2] - xe;
                c = Iy[i - 1][j2] - xd;
                float f2 = NeedlemanWunschAffine.max(a, b, c);
                Ix[i][j2] = f2;
                val = f2;
                this.Bi[1][i][j2] = i - 1;
                this.Bj[1][i][j2] = j2;
                if (val == a) {
                    this.Bk[1][i][j2] = 0;
                } else if (val == b) {
                    this.Bk[1][i][j2] = 1;
                } else if (val == c) {
                    this.Bk[1][i][j2] = 2;
                } else {
                    throw new Error("NWAffine 2");
                }
                float yd = this.d;
                float ye = this.e;
                if (i == n && freeEndGap) {
                    yd = 0.0f;
                    ye = 0.0f;
                }
                a = M[i][j2 - 1] - yd;
                b = Iy[i][j2 - 1] - ye;
                c = Ix[i][j2 - 1] - yd;
                float f3 = NeedlemanWunschAffine.max(a, b, c);
                Iy[i][j2] = f3;
                val = f3;
                this.Bi[2][i][j2] = i;
                this.Bj[2][i][j2] = j2 - 1;
                if (val == a) {
                    this.Bk[2][i][j2] = 0;
                    continue;
                }
                if (val == b) {
                    this.Bk[2][i][j2] = 2;
                    continue;
                }
                if (val == c) {
                    this.Bk[2][i][j2] = 1;
                    continue;
                }
                throw new Error("NWAffine 3");
            }
        }
        int maxk = 0;
        float maxval = this.F[0][n][m];
        for (int k = 1; k < 3; ++k) {
            if (!(maxval < this.F[k][n][m])) continue;
            maxval = this.F[k][n][m];
            maxk = k;
        }
        if (endType == 1) {
            maxk = 1;
        }
        if (endType == 2) {
            maxk = 2;
        }
        this.B0k = maxk;
        this.B0i = n;
        this.B0j = m;
    }

    public void appendMatch(AlignmentResult result1, AlignmentResult result2) {
        String[] results = this.getMatch(null, null);
        result1.append(results[0]);
        result2.append(results[1]);
    }

    public String[] getMatch() {
        return this.getMatch(this.seq1.toCharArray(), this.seq2.toCharArray());
    }

    public String[] getMatch(char[] sq1, char[] sq2) {
        StringBuilder res1 = new StringBuilder();
        StringBuilder res2 = new StringBuilder();
        int i = this.B0i;
        int j = this.B0j;
        int k = this.B0k;
        while (i != 0 || j != 0) {
            int tbi = this.Bi[k][i][j];
            int tbj = this.Bj[k][i][j];
            int tbk = this.Bk[k][i][j];
            if (i == tbi) {
                res1.append('-');
            } else if (sq1 != null) {
                res1.append(sq1[i - 1]);
            } else {
                res1.append('X');
            }
            if (j == tbj) {
                res2.append('-');
            } else if (sq2 != null) {
                res2.append(sq2[j - 1]);
            } else {
                res2.append('X');
            }
            i = tbi;
            j = tbj;
            k = tbk;
        }
        if (this.invert) {
            return new String[]{res2.reverse().toString(), res1.reverse().toString()};
        }
        return new String[]{res1.reverse().toString(), res2.reverse().toString()};
    }

    public float getScore() {
        return this.F[this.B0k][this.B0i][this.B0j];
    }
}

