/*
 * Decompiled with CFR 0.152.
 */
package dr.math.matrixAlgebra.ejml;

import dr.math.matrixAlgebra.WrappedMatrix;

public class UnrolledDeterminantFromMinor {
    public static final int MAX = 6;

    public static double det(WrappedMatrix wrappedMatrix) {
        switch (wrappedMatrix.getMajorDim()) {
            case 2: {
                return UnrolledDeterminantFromMinor.det2(wrappedMatrix);
            }
            case 3: {
                return UnrolledDeterminantFromMinor.det3(wrappedMatrix);
            }
            case 4: {
                return UnrolledDeterminantFromMinor.det4(wrappedMatrix);
            }
            case 5: {
                return UnrolledDeterminantFromMinor.det5(wrappedMatrix);
            }
            case 6: {
                return UnrolledDeterminantFromMinor.det6(wrappedMatrix);
            }
        }
        throw new IllegalArgumentException("Not supported");
    }

    public static double det2(WrappedMatrix wrappedMatrix) {
        double d = wrappedMatrix.get(0, 0);
        double d2 = wrappedMatrix.get(0, 1);
        double d3 = wrappedMatrix.get(1, 0);
        double d4 = wrappedMatrix.get(1, 1);
        return d * d4 - d2 * d3;
    }

    public static double det3(WrappedMatrix wrappedMatrix) {
        double[] dArray = WrappedMatrix.data;
        double d = wrappedMatrix.get(0, 0);
        double d2 = wrappedMatrix.get(0, 1);
        double d3 = wrappedMatrix.get(0, 2);
        double d4 = wrappedMatrix.get(1, 0);
        double d5 = wrappedMatrix.get(1, 1);
        double d6 = wrappedMatrix.get(1, 2);
        double d7 = wrappedMatrix.get(2, 0);
        double d8 = wrappedMatrix.get(2, 1);
        double d9 = wrappedMatrix.get(2, 2);
        double d10 = d * (d5 * d9 - d6 * d8);
        double d11 = d2 * (d4 * d9 - d6 * d7);
        double d12 = d3 * (d4 * d8 - d7 * d5);
        return d10 - d11 + d12;
    }

    public static double det4(WrappedMatrix wrappedMatrix) {
        double[] dArray = WrappedMatrix.data;
        double d = dArray[5];
        double d2 = dArray[6];
        double d3 = dArray[7];
        double d4 = dArray[9];
        double d5 = dArray[10];
        double d6 = dArray[11];
        double d7 = dArray[13];
        double d8 = dArray[14];
        double d9 = dArray[15];
        double d10 = 0.0;
        d10 += dArray[0] * (d * (d5 * d9 - d6 * d8) - d2 * (d4 * d9 - d6 * d7) + d3 * (d4 * d8 - d5 * d7));
        d = dArray[4];
        d4 = dArray[8];
        d7 = dArray[12];
        d10 -= dArray[1] * (d * (d5 * d9 - d6 * d8) - d2 * (d4 * d9 - d6 * d7) + d3 * (d4 * d8 - d5 * d7));
        d2 = dArray[5];
        d5 = dArray[9];
        d8 = dArray[13];
        d10 += dArray[2] * (d * (d5 * d9 - d6 * d8) - d2 * (d4 * d9 - d6 * d7) + d3 * (d4 * d8 - d5 * d7));
        d3 = dArray[6];
        d6 = dArray[10];
        d9 = dArray[14];
        return d10 -= dArray[3] * (d * (d5 * d9 - d6 * d8) - d2 * (d4 * d9 - d6 * d7) + d3 * (d4 * d8 - d5 * d7));
    }

    public static double det5(WrappedMatrix wrappedMatrix) {
        double[] dArray = WrappedMatrix.data;
        double d = dArray[6];
        double d2 = dArray[7];
        double d3 = dArray[8];
        double d4 = dArray[9];
        double d5 = dArray[11];
        double d6 = dArray[12];
        double d7 = dArray[13];
        double d8 = dArray[14];
        double d9 = dArray[16];
        double d10 = dArray[17];
        double d11 = dArray[18];
        double d12 = dArray[19];
        double d13 = dArray[21];
        double d14 = dArray[22];
        double d15 = dArray[23];
        double d16 = dArray[24];
        double d17 = 0.0;
        d17 += dArray[0] * (d * (d6 * (d11 * d16 - d12 * d15) - d7 * (d10 * d16 - d12 * d14) + d8 * (d10 * d15 - d11 * d14)) - d2 * (d5 * (d11 * d16 - d12 * d15) - d7 * (d9 * d16 - d12 * d13) + d8 * (d9 * d15 - d11 * d13)) + d3 * (d5 * (d10 * d16 - d12 * d14) - d6 * (d9 * d16 - d12 * d13) + d8 * (d9 * d14 - d10 * d13)) - d4 * (d5 * (d10 * d15 - d11 * d14) - d6 * (d9 * d15 - d11 * d13) + d7 * (d9 * d14 - d10 * d13)));
        d = dArray[5];
        d5 = dArray[10];
        d9 = dArray[15];
        d13 = dArray[20];
        d17 -= dArray[1] * (d * (d6 * (d11 * d16 - d12 * d15) - d7 * (d10 * d16 - d12 * d14) + d8 * (d10 * d15 - d11 * d14)) - d2 * (d5 * (d11 * d16 - d12 * d15) - d7 * (d9 * d16 - d12 * d13) + d8 * (d9 * d15 - d11 * d13)) + d3 * (d5 * (d10 * d16 - d12 * d14) - d6 * (d9 * d16 - d12 * d13) + d8 * (d9 * d14 - d10 * d13)) - d4 * (d5 * (d10 * d15 - d11 * d14) - d6 * (d9 * d15 - d11 * d13) + d7 * (d9 * d14 - d10 * d13)));
        d2 = dArray[6];
        d6 = dArray[11];
        d10 = dArray[16];
        d14 = dArray[21];
        d17 += dArray[2] * (d * (d6 * (d11 * d16 - d12 * d15) - d7 * (d10 * d16 - d12 * d14) + d8 * (d10 * d15 - d11 * d14)) - d2 * (d5 * (d11 * d16 - d12 * d15) - d7 * (d9 * d16 - d12 * d13) + d8 * (d9 * d15 - d11 * d13)) + d3 * (d5 * (d10 * d16 - d12 * d14) - d6 * (d9 * d16 - d12 * d13) + d8 * (d9 * d14 - d10 * d13)) - d4 * (d5 * (d10 * d15 - d11 * d14) - d6 * (d9 * d15 - d11 * d13) + d7 * (d9 * d14 - d10 * d13)));
        d3 = dArray[7];
        d7 = dArray[12];
        d11 = dArray[17];
        d15 = dArray[22];
        d17 -= dArray[3] * (d * (d6 * (d11 * d16 - d12 * d15) - d7 * (d10 * d16 - d12 * d14) + d8 * (d10 * d15 - d11 * d14)) - d2 * (d5 * (d11 * d16 - d12 * d15) - d7 * (d9 * d16 - d12 * d13) + d8 * (d9 * d15 - d11 * d13)) + d3 * (d5 * (d10 * d16 - d12 * d14) - d6 * (d9 * d16 - d12 * d13) + d8 * (d9 * d14 - d10 * d13)) - d4 * (d5 * (d10 * d15 - d11 * d14) - d6 * (d9 * d15 - d11 * d13) + d7 * (d9 * d14 - d10 * d13)));
        d4 = dArray[8];
        d8 = dArray[13];
        d12 = dArray[18];
        d16 = dArray[23];
        return d17 += dArray[4] * (d * (d6 * (d11 * d16 - d12 * d15) - d7 * (d10 * d16 - d12 * d14) + d8 * (d10 * d15 - d11 * d14)) - d2 * (d5 * (d11 * d16 - d12 * d15) - d7 * (d9 * d16 - d12 * d13) + d8 * (d9 * d15 - d11 * d13)) + d3 * (d5 * (d10 * d16 - d12 * d14) - d6 * (d9 * d16 - d12 * d13) + d8 * (d9 * d14 - d10 * d13)) - d4 * (d5 * (d10 * d15 - d11 * d14) - d6 * (d9 * d15 - d11 * d13) + d7 * (d9 * d14 - d10 * d13)));
    }

    public static double det6(WrappedMatrix wrappedMatrix) {
        double[] dArray = WrappedMatrix.data;
        double d = dArray[7];
        double d2 = dArray[8];
        double d3 = dArray[9];
        double d4 = dArray[10];
        double d5 = dArray[11];
        double d6 = dArray[13];
        double d7 = dArray[14];
        double d8 = dArray[15];
        double d9 = dArray[16];
        double d10 = dArray[17];
        double d11 = dArray[19];
        double d12 = dArray[20];
        double d13 = dArray[21];
        double d14 = dArray[22];
        double d15 = dArray[23];
        double d16 = dArray[25];
        double d17 = dArray[26];
        double d18 = dArray[27];
        double d19 = dArray[28];
        double d20 = dArray[29];
        double d21 = dArray[31];
        double d22 = dArray[32];
        double d23 = dArray[33];
        double d24 = dArray[34];
        double d25 = dArray[35];
        double d26 = 0.0;
        d26 += dArray[0] * (d * (d7 * (d13 * (d19 * d25 - d20 * d24) - d14 * (d18 * d25 - d20 * d23) + d15 * (d18 * d24 - d19 * d23)) - d8 * (d12 * (d19 * d25 - d20 * d24) - d14 * (d17 * d25 - d20 * d22) + d15 * (d17 * d24 - d19 * d22)) + d9 * (d12 * (d18 * d25 - d20 * d23) - d13 * (d17 * d25 - d20 * d22) + d15 * (d17 * d23 - d18 * d22)) - d10 * (d12 * (d18 * d24 - d19 * d23) - d13 * (d17 * d24 - d19 * d22) + d14 * (d17 * d23 - d18 * d22))) - d2 * (d6 * (d13 * (d19 * d25 - d20 * d24) - d14 * (d18 * d25 - d20 * d23) + d15 * (d18 * d24 - d19 * d23)) - d8 * (d11 * (d19 * d25 - d20 * d24) - d14 * (d16 * d25 - d20 * d21) + d15 * (d16 * d24 - d19 * d21)) + d9 * (d11 * (d18 * d25 - d20 * d23) - d13 * (d16 * d25 - d20 * d21) + d15 * (d16 * d23 - d18 * d21)) - d10 * (d11 * (d18 * d24 - d19 * d23) - d13 * (d16 * d24 - d19 * d21) + d14 * (d16 * d23 - d18 * d21))) + d3 * (d6 * (d12 * (d19 * d25 - d20 * d24) - d14 * (d17 * d25 - d20 * d22) + d15 * (d17 * d24 - d19 * d22)) - d7 * (d11 * (d19 * d25 - d20 * d24) - d14 * (d16 * d25 - d20 * d21) + d15 * (d16 * d24 - d19 * d21)) + d9 * (d11 * (d17 * d25 - d20 * d22) - d12 * (d16 * d25 - d20 * d21) + d15 * (d16 * d22 - d17 * d21)) - d10 * (d11 * (d17 * d24 - d19 * d22) - d12 * (d16 * d24 - d19 * d21) + d14 * (d16 * d22 - d17 * d21))) - d4 * (d6 * (d12 * (d18 * d25 - d20 * d23) - d13 * (d17 * d25 - d20 * d22) + d15 * (d17 * d23 - d18 * d22)) - d7 * (d11 * (d18 * d25 - d20 * d23) - d13 * (d16 * d25 - d20 * d21) + d15 * (d16 * d23 - d18 * d21)) + d8 * (d11 * (d17 * d25 - d20 * d22) - d12 * (d16 * d25 - d20 * d21) + d15 * (d16 * d22 - d17 * d21)) - d10 * (d11 * (d17 * d23 - d18 * d22) - d12 * (d16 * d23 - d18 * d21) + d13 * (d16 * d22 - d17 * d21))) + d5 * (d6 * (d12 * (d18 * d24 - d19 * d23) - d13 * (d17 * d24 - d19 * d22) + d14 * (d17 * d23 - d18 * d22)) - d7 * (d11 * (d18 * d24 - d19 * d23) - d13 * (d16 * d24 - d19 * d21) + d14 * (d16 * d23 - d18 * d21)) + d8 * (d11 * (d17 * d24 - d19 * d22) - d12 * (d16 * d24 - d19 * d21) + d14 * (d16 * d22 - d17 * d21)) - d9 * (d11 * (d17 * d23 - d18 * d22) - d12 * (d16 * d23 - d18 * d21) + d13 * (d16 * d22 - d17 * d21))));
        d = dArray[6];
        d6 = dArray[12];
        d11 = dArray[18];
        d16 = dArray[24];
        d21 = dArray[30];
        d26 -= dArray[1] * (d * (d7 * (d13 * (d19 * d25 - d20 * d24) - d14 * (d18 * d25 - d20 * d23) + d15 * (d18 * d24 - d19 * d23)) - d8 * (d12 * (d19 * d25 - d20 * d24) - d14 * (d17 * d25 - d20 * d22) + d15 * (d17 * d24 - d19 * d22)) + d9 * (d12 * (d18 * d25 - d20 * d23) - d13 * (d17 * d25 - d20 * d22) + d15 * (d17 * d23 - d18 * d22)) - d10 * (d12 * (d18 * d24 - d19 * d23) - d13 * (d17 * d24 - d19 * d22) + d14 * (d17 * d23 - d18 * d22))) - d2 * (d6 * (d13 * (d19 * d25 - d20 * d24) - d14 * (d18 * d25 - d20 * d23) + d15 * (d18 * d24 - d19 * d23)) - d8 * (d11 * (d19 * d25 - d20 * d24) - d14 * (d16 * d25 - d20 * d21) + d15 * (d16 * d24 - d19 * d21)) + d9 * (d11 * (d18 * d25 - d20 * d23) - d13 * (d16 * d25 - d20 * d21) + d15 * (d16 * d23 - d18 * d21)) - d10 * (d11 * (d18 * d24 - d19 * d23) - d13 * (d16 * d24 - d19 * d21) + d14 * (d16 * d23 - d18 * d21))) + d3 * (d6 * (d12 * (d19 * d25 - d20 * d24) - d14 * (d17 * d25 - d20 * d22) + d15 * (d17 * d24 - d19 * d22)) - d7 * (d11 * (d19 * d25 - d20 * d24) - d14 * (d16 * d25 - d20 * d21) + d15 * (d16 * d24 - d19 * d21)) + d9 * (d11 * (d17 * d25 - d20 * d22) - d12 * (d16 * d25 - d20 * d21) + d15 * (d16 * d22 - d17 * d21)) - d10 * (d11 * (d17 * d24 - d19 * d22) - d12 * (d16 * d24 - d19 * d21) + d14 * (d16 * d22 - d17 * d21))) - d4 * (d6 * (d12 * (d18 * d25 - d20 * d23) - d13 * (d17 * d25 - d20 * d22) + d15 * (d17 * d23 - d18 * d22)) - d7 * (d11 * (d18 * d25 - d20 * d23) - d13 * (d16 * d25 - d20 * d21) + d15 * (d16 * d23 - d18 * d21)) + d8 * (d11 * (d17 * d25 - d20 * d22) - d12 * (d16 * d25 - d20 * d21) + d15 * (d16 * d22 - d17 * d21)) - d10 * (d11 * (d17 * d23 - d18 * d22) - d12 * (d16 * d23 - d18 * d21) + d13 * (d16 * d22 - d17 * d21))) + d5 * (d6 * (d12 * (d18 * d24 - d19 * d23) - d13 * (d17 * d24 - d19 * d22) + d14 * (d17 * d23 - d18 * d22)) - d7 * (d11 * (d18 * d24 - d19 * d23) - d13 * (d16 * d24 - d19 * d21) + d14 * (d16 * d23 - d18 * d21)) + d8 * (d11 * (d17 * d24 - d19 * d22) - d12 * (d16 * d24 - d19 * d21) + d14 * (d16 * d22 - d17 * d21)) - d9 * (d11 * (d17 * d23 - d18 * d22) - d12 * (d16 * d23 - d18 * d21) + d13 * (d16 * d22 - d17 * d21))));
        d2 = dArray[7];
        d7 = dArray[13];
        d12 = dArray[19];
        d17 = dArray[25];
        d22 = dArray[31];
        d26 += dArray[2] * (d * (d7 * (d13 * (d19 * d25 - d20 * d24) - d14 * (d18 * d25 - d20 * d23) + d15 * (d18 * d24 - d19 * d23)) - d8 * (d12 * (d19 * d25 - d20 * d24) - d14 * (d17 * d25 - d20 * d22) + d15 * (d17 * d24 - d19 * d22)) + d9 * (d12 * (d18 * d25 - d20 * d23) - d13 * (d17 * d25 - d20 * d22) + d15 * (d17 * d23 - d18 * d22)) - d10 * (d12 * (d18 * d24 - d19 * d23) - d13 * (d17 * d24 - d19 * d22) + d14 * (d17 * d23 - d18 * d22))) - d2 * (d6 * (d13 * (d19 * d25 - d20 * d24) - d14 * (d18 * d25 - d20 * d23) + d15 * (d18 * d24 - d19 * d23)) - d8 * (d11 * (d19 * d25 - d20 * d24) - d14 * (d16 * d25 - d20 * d21) + d15 * (d16 * d24 - d19 * d21)) + d9 * (d11 * (d18 * d25 - d20 * d23) - d13 * (d16 * d25 - d20 * d21) + d15 * (d16 * d23 - d18 * d21)) - d10 * (d11 * (d18 * d24 - d19 * d23) - d13 * (d16 * d24 - d19 * d21) + d14 * (d16 * d23 - d18 * d21))) + d3 * (d6 * (d12 * (d19 * d25 - d20 * d24) - d14 * (d17 * d25 - d20 * d22) + d15 * (d17 * d24 - d19 * d22)) - d7 * (d11 * (d19 * d25 - d20 * d24) - d14 * (d16 * d25 - d20 * d21) + d15 * (d16 * d24 - d19 * d21)) + d9 * (d11 * (d17 * d25 - d20 * d22) - d12 * (d16 * d25 - d20 * d21) + d15 * (d16 * d22 - d17 * d21)) - d10 * (d11 * (d17 * d24 - d19 * d22) - d12 * (d16 * d24 - d19 * d21) + d14 * (d16 * d22 - d17 * d21))) - d4 * (d6 * (d12 * (d18 * d25 - d20 * d23) - d13 * (d17 * d25 - d20 * d22) + d15 * (d17 * d23 - d18 * d22)) - d7 * (d11 * (d18 * d25 - d20 * d23) - d13 * (d16 * d25 - d20 * d21) + d15 * (d16 * d23 - d18 * d21)) + d8 * (d11 * (d17 * d25 - d20 * d22) - d12 * (d16 * d25 - d20 * d21) + d15 * (d16 * d22 - d17 * d21)) - d10 * (d11 * (d17 * d23 - d18 * d22) - d12 * (d16 * d23 - d18 * d21) + d13 * (d16 * d22 - d17 * d21))) + d5 * (d6 * (d12 * (d18 * d24 - d19 * d23) - d13 * (d17 * d24 - d19 * d22) + d14 * (d17 * d23 - d18 * d22)) - d7 * (d11 * (d18 * d24 - d19 * d23) - d13 * (d16 * d24 - d19 * d21) + d14 * (d16 * d23 - d18 * d21)) + d8 * (d11 * (d17 * d24 - d19 * d22) - d12 * (d16 * d24 - d19 * d21) + d14 * (d16 * d22 - d17 * d21)) - d9 * (d11 * (d17 * d23 - d18 * d22) - d12 * (d16 * d23 - d18 * d21) + d13 * (d16 * d22 - d17 * d21))));
        d3 = dArray[8];
        d8 = dArray[14];
        d13 = dArray[20];
        d18 = dArray[26];
        d23 = dArray[32];
        d26 -= dArray[3] * (d * (d7 * (d13 * (d19 * d25 - d20 * d24) - d14 * (d18 * d25 - d20 * d23) + d15 * (d18 * d24 - d19 * d23)) - d8 * (d12 * (d19 * d25 - d20 * d24) - d14 * (d17 * d25 - d20 * d22) + d15 * (d17 * d24 - d19 * d22)) + d9 * (d12 * (d18 * d25 - d20 * d23) - d13 * (d17 * d25 - d20 * d22) + d15 * (d17 * d23 - d18 * d22)) - d10 * (d12 * (d18 * d24 - d19 * d23) - d13 * (d17 * d24 - d19 * d22) + d14 * (d17 * d23 - d18 * d22))) - d2 * (d6 * (d13 * (d19 * d25 - d20 * d24) - d14 * (d18 * d25 - d20 * d23) + d15 * (d18 * d24 - d19 * d23)) - d8 * (d11 * (d19 * d25 - d20 * d24) - d14 * (d16 * d25 - d20 * d21) + d15 * (d16 * d24 - d19 * d21)) + d9 * (d11 * (d18 * d25 - d20 * d23) - d13 * (d16 * d25 - d20 * d21) + d15 * (d16 * d23 - d18 * d21)) - d10 * (d11 * (d18 * d24 - d19 * d23) - d13 * (d16 * d24 - d19 * d21) + d14 * (d16 * d23 - d18 * d21))) + d3 * (d6 * (d12 * (d19 * d25 - d20 * d24) - d14 * (d17 * d25 - d20 * d22) + d15 * (d17 * d24 - d19 * d22)) - d7 * (d11 * (d19 * d25 - d20 * d24) - d14 * (d16 * d25 - d20 * d21) + d15 * (d16 * d24 - d19 * d21)) + d9 * (d11 * (d17 * d25 - d20 * d22) - d12 * (d16 * d25 - d20 * d21) + d15 * (d16 * d22 - d17 * d21)) - d10 * (d11 * (d17 * d24 - d19 * d22) - d12 * (d16 * d24 - d19 * d21) + d14 * (d16 * d22 - d17 * d21))) - d4 * (d6 * (d12 * (d18 * d25 - d20 * d23) - d13 * (d17 * d25 - d20 * d22) + d15 * (d17 * d23 - d18 * d22)) - d7 * (d11 * (d18 * d25 - d20 * d23) - d13 * (d16 * d25 - d20 * d21) + d15 * (d16 * d23 - d18 * d21)) + d8 * (d11 * (d17 * d25 - d20 * d22) - d12 * (d16 * d25 - d20 * d21) + d15 * (d16 * d22 - d17 * d21)) - d10 * (d11 * (d17 * d23 - d18 * d22) - d12 * (d16 * d23 - d18 * d21) + d13 * (d16 * d22 - d17 * d21))) + d5 * (d6 * (d12 * (d18 * d24 - d19 * d23) - d13 * (d17 * d24 - d19 * d22) + d14 * (d17 * d23 - d18 * d22)) - d7 * (d11 * (d18 * d24 - d19 * d23) - d13 * (d16 * d24 - d19 * d21) + d14 * (d16 * d23 - d18 * d21)) + d8 * (d11 * (d17 * d24 - d19 * d22) - d12 * (d16 * d24 - d19 * d21) + d14 * (d16 * d22 - d17 * d21)) - d9 * (d11 * (d17 * d23 - d18 * d22) - d12 * (d16 * d23 - d18 * d21) + d13 * (d16 * d22 - d17 * d21))));
        d4 = dArray[9];
        d9 = dArray[15];
        d14 = dArray[21];
        d19 = dArray[27];
        d24 = dArray[33];
        d26 += dArray[4] * (d * (d7 * (d13 * (d19 * d25 - d20 * d24) - d14 * (d18 * d25 - d20 * d23) + d15 * (d18 * d24 - d19 * d23)) - d8 * (d12 * (d19 * d25 - d20 * d24) - d14 * (d17 * d25 - d20 * d22) + d15 * (d17 * d24 - d19 * d22)) + d9 * (d12 * (d18 * d25 - d20 * d23) - d13 * (d17 * d25 - d20 * d22) + d15 * (d17 * d23 - d18 * d22)) - d10 * (d12 * (d18 * d24 - d19 * d23) - d13 * (d17 * d24 - d19 * d22) + d14 * (d17 * d23 - d18 * d22))) - d2 * (d6 * (d13 * (d19 * d25 - d20 * d24) - d14 * (d18 * d25 - d20 * d23) + d15 * (d18 * d24 - d19 * d23)) - d8 * (d11 * (d19 * d25 - d20 * d24) - d14 * (d16 * d25 - d20 * d21) + d15 * (d16 * d24 - d19 * d21)) + d9 * (d11 * (d18 * d25 - d20 * d23) - d13 * (d16 * d25 - d20 * d21) + d15 * (d16 * d23 - d18 * d21)) - d10 * (d11 * (d18 * d24 - d19 * d23) - d13 * (d16 * d24 - d19 * d21) + d14 * (d16 * d23 - d18 * d21))) + d3 * (d6 * (d12 * (d19 * d25 - d20 * d24) - d14 * (d17 * d25 - d20 * d22) + d15 * (d17 * d24 - d19 * d22)) - d7 * (d11 * (d19 * d25 - d20 * d24) - d14 * (d16 * d25 - d20 * d21) + d15 * (d16 * d24 - d19 * d21)) + d9 * (d11 * (d17 * d25 - d20 * d22) - d12 * (d16 * d25 - d20 * d21) + d15 * (d16 * d22 - d17 * d21)) - d10 * (d11 * (d17 * d24 - d19 * d22) - d12 * (d16 * d24 - d19 * d21) + d14 * (d16 * d22 - d17 * d21))) - d4 * (d6 * (d12 * (d18 * d25 - d20 * d23) - d13 * (d17 * d25 - d20 * d22) + d15 * (d17 * d23 - d18 * d22)) - d7 * (d11 * (d18 * d25 - d20 * d23) - d13 * (d16 * d25 - d20 * d21) + d15 * (d16 * d23 - d18 * d21)) + d8 * (d11 * (d17 * d25 - d20 * d22) - d12 * (d16 * d25 - d20 * d21) + d15 * (d16 * d22 - d17 * d21)) - d10 * (d11 * (d17 * d23 - d18 * d22) - d12 * (d16 * d23 - d18 * d21) + d13 * (d16 * d22 - d17 * d21))) + d5 * (d6 * (d12 * (d18 * d24 - d19 * d23) - d13 * (d17 * d24 - d19 * d22) + d14 * (d17 * d23 - d18 * d22)) - d7 * (d11 * (d18 * d24 - d19 * d23) - d13 * (d16 * d24 - d19 * d21) + d14 * (d16 * d23 - d18 * d21)) + d8 * (d11 * (d17 * d24 - d19 * d22) - d12 * (d16 * d24 - d19 * d21) + d14 * (d16 * d22 - d17 * d21)) - d9 * (d11 * (d17 * d23 - d18 * d22) - d12 * (d16 * d23 - d18 * d21) + d13 * (d16 * d22 - d17 * d21))));
        d5 = dArray[10];
        d10 = dArray[16];
        d15 = dArray[22];
        d20 = dArray[28];
        d25 = dArray[34];
        return d26 -= dArray[5] * (d * (d7 * (d13 * (d19 * d25 - d20 * d24) - d14 * (d18 * d25 - d20 * d23) + d15 * (d18 * d24 - d19 * d23)) - d8 * (d12 * (d19 * d25 - d20 * d24) - d14 * (d17 * d25 - d20 * d22) + d15 * (d17 * d24 - d19 * d22)) + d9 * (d12 * (d18 * d25 - d20 * d23) - d13 * (d17 * d25 - d20 * d22) + d15 * (d17 * d23 - d18 * d22)) - d10 * (d12 * (d18 * d24 - d19 * d23) - d13 * (d17 * d24 - d19 * d22) + d14 * (d17 * d23 - d18 * d22))) - d2 * (d6 * (d13 * (d19 * d25 - d20 * d24) - d14 * (d18 * d25 - d20 * d23) + d15 * (d18 * d24 - d19 * d23)) - d8 * (d11 * (d19 * d25 - d20 * d24) - d14 * (d16 * d25 - d20 * d21) + d15 * (d16 * d24 - d19 * d21)) + d9 * (d11 * (d18 * d25 - d20 * d23) - d13 * (d16 * d25 - d20 * d21) + d15 * (d16 * d23 - d18 * d21)) - d10 * (d11 * (d18 * d24 - d19 * d23) - d13 * (d16 * d24 - d19 * d21) + d14 * (d16 * d23 - d18 * d21))) + d3 * (d6 * (d12 * (d19 * d25 - d20 * d24) - d14 * (d17 * d25 - d20 * d22) + d15 * (d17 * d24 - d19 * d22)) - d7 * (d11 * (d19 * d25 - d20 * d24) - d14 * (d16 * d25 - d20 * d21) + d15 * (d16 * d24 - d19 * d21)) + d9 * (d11 * (d17 * d25 - d20 * d22) - d12 * (d16 * d25 - d20 * d21) + d15 * (d16 * d22 - d17 * d21)) - d10 * (d11 * (d17 * d24 - d19 * d22) - d12 * (d16 * d24 - d19 * d21) + d14 * (d16 * d22 - d17 * d21))) - d4 * (d6 * (d12 * (d18 * d25 - d20 * d23) - d13 * (d17 * d25 - d20 * d22) + d15 * (d17 * d23 - d18 * d22)) - d7 * (d11 * (d18 * d25 - d20 * d23) - d13 * (d16 * d25 - d20 * d21) + d15 * (d16 * d23 - d18 * d21)) + d8 * (d11 * (d17 * d25 - d20 * d22) - d12 * (d16 * d25 - d20 * d21) + d15 * (d16 * d22 - d17 * d21)) - d10 * (d11 * (d17 * d23 - d18 * d22) - d12 * (d16 * d23 - d18 * d21) + d13 * (d16 * d22 - d17 * d21))) + d5 * (d6 * (d12 * (d18 * d24 - d19 * d23) - d13 * (d17 * d24 - d19 * d22) + d14 * (d17 * d23 - d18 * d22)) - d7 * (d11 * (d18 * d24 - d19 * d23) - d13 * (d16 * d24 - d19 * d21) + d14 * (d16 * d23 - d18 * d21)) + d8 * (d11 * (d17 * d24 - d19 * d22) - d12 * (d16 * d24 - d19 * d21) + d14 * (d16 * d22 - d17 * d21)) - d9 * (d11 * (d17 * d23 - d18 * d22) - d12 * (d16 * d23 - d18 * d21) + d13 * (d16 * d22 - d17 * d21))));
    }
}

