/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import cern.jet.stat.Gamma;
import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;

public class BifractionalDiffusionDensity
implements Distribution {
    private static double oneOverSqrtPi = 1.0 / Math.sqrt(Math.PI);
    private static double oneOverPi = 0.3183098861837907;
    public static final int maxK = 50;
    private double alpha;
    private double beta;
    private double v;
    private double[][][] coefficients;

    public BifractionalDiffusionDensity(double d, double d2, double d3) {
        this.v = d;
        this.alpha = d2;
        this.beta = d3;
        this.coefficients = BifractionalDiffusionDensity.constructBifractionalDiffusionCoefficients(d2, d3);
    }

    public BifractionalDiffusionDensity(double d, double d2) {
        this(1.0, d, d2);
    }

    @Override
    public double pdf(double d) {
        return this.pdf(d, this.v);
    }

    public double pdf(double d, double d2) {
        return BifractionalDiffusionDensity.pdf(d, d2, this.alpha, this.beta, this.coefficients);
    }

    @Override
    public double logPdf(double d) {
        return BifractionalDiffusionDensity.logPdf(d, this.v, this.alpha, this.beta, this.coefficients);
    }

    @Override
    public double cdf(double d) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double quantile(double d) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double mean() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double variance() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public UnivariateFunction getProbabilityDensityFunction() {
        throw new RuntimeException("Not yet implemented");
    }

    public static double logPdf(double d, double d2, double d3, double d4) {
        return Math.log(BifractionalDiffusionDensity.pdf(d, d2, d3, d4));
    }

    public static double logPdf(double d, double d2, double d3, double d4, double[][][] dArray) {
        return Math.log(BifractionalDiffusionDensity.pdf(d, d2, d3, d4, dArray));
    }

    public static SignedDouble logGamma(double d) {
        if (d > 0.0) {
            return new SignedDouble(Gamma.logGamma(d), true);
        }
        int n = (int)(-d);
        if (d + (double)n == 0.0) {
            return new SignedDouble(Double.NaN, true);
        }
        boolean bl = ++n % 2 == 0;
        return new SignedDouble(Gamma.logGamma(d + (double)n) - Gamma.logGamma(-d + 1.0) + Gamma.logGamma(-d - (double)n + 1.0), bl);
    }

    public static double gamma(double d) {
        if (d > 0.0) {
            return Gamma.gamma(d);
        }
        int n = (int)(-d);
        if (d + (double)n == 0.0) {
            return Double.NaN;
        }
        boolean bl = ++n % 2 == 0;
        double d2 = Gamma.gamma(d + (double)n) / Gamma.gamma(-d + 1.0) * Gamma.gamma(-d - (double)n + 1.0);
        if (!bl) {
            d2 *= -1.0;
        }
        return d2;
    }

    private static double evaluateGreensFunctionAtZero(double d, double d2, double d3) {
        if (d3 == 1.0) {
            double d4 = 1.0 / d2;
            return BifractionalDiffusionDensity.gamma(d4) / (Math.PI * d2 * Math.pow(d, d4));
        }
        double d5 = d3 / d2;
        return 1.0 / (d2 * Math.pow(d, d5) * Math.sin(Math.PI / d2) * BifractionalDiffusionDensity.gamma(1.0 - d5));
    }

    private static double evaluateGreensFunctionAlphaEqualsBeta(double d, double d2, double d3) {
        double d4 = Math.abs(d);
        double d5 = 2.0 * d3;
        double d6 = Math.pow(d2, d3);
        double d7 = 1.5707963267948966 * d3;
        double d8 = Math.pow(d4, d3 - 1.0) * d6 * Math.sin(d7) / (Math.pow(d2, d5) + 2.0 * Math.pow(d4, d3) * d6 * Math.cos(d7) + Math.pow(d4, d5));
        return oneOverPi * d8;
    }

    private static double evaluateGreensFunctionBetaGreaterThanAlpha(double d, double d2, double d3, double d4, double[][][] dArray) {
        double d5 = Math.pow(2.0, d3) * Math.pow(d2, d4) / Math.pow(Math.abs(d), d3);
        return oneOverSqrtPi / Math.sqrt(Math.abs(d)) * BifractionalDiffusionDensity.generalizedWrightFunction(-d5, dArray[0], dArray[1]);
    }

    private static double evaluateGreensFunctionAlphaGreaterThanBeta(double d, double d2, double d3, double d4, double[][][] dArray) {
        double d5 = Math.pow(Math.abs(d), d3) / (Math.pow(2.0, d3) * Math.pow(d2, d4));
        double d6 = d * d / (4.0 * Math.pow(d2, 2.0 * d4 / d3));
        double d7 = oneOverSqrtPi * Math.pow(Math.abs(d), d3 - 1.0) / (Math.pow(2.0, d3) * Math.pow(d2, d4)) * BifractionalDiffusionDensity.generalizedWrightFunction(-d5, dArray[2], dArray[3]);
        double d8 = oneOverSqrtPi / (d3 * Math.pow(d2, d4 / d3)) * BifractionalDiffusionDensity.generalizedWrightFunction(-d6, dArray[4], dArray[5]);
        return d7 + d8;
    }

    public static double pdf(double d, double d2, double d3, double d4) {
        return BifractionalDiffusionDensity.pdf(d, d2, d3, d4, null);
    }

    public static double pdf(double d, double d2, double d3, double d4, double[][][] dArray) {
        double d5 = 0.5 * d2;
        if (d == 0.0) {
            return BifractionalDiffusionDensity.evaluateGreensFunctionAtZero(d5, d3, d4);
        }
        if (d3 == d4) {
            return BifractionalDiffusionDensity.evaluateGreensFunctionAlphaEqualsBeta(d, d5, d3);
        }
        if (dArray == null) {
            dArray = BifractionalDiffusionDensity.constructBifractionalDiffusionCoefficients(d3, d4);
        }
        if (d3 > d4) {
            return BifractionalDiffusionDensity.evaluateGreensFunctionAlphaGreaterThanBeta(d, d5, d3, d4, dArray);
        }
        return BifractionalDiffusionDensity.evaluateGreensFunctionBetaGreaterThanAlpha(d, d5, d3, d4, dArray);
    }

    public static double[][][] constructBifractionalDiffusionCoefficients(double d, double d2) {
        double[][][] dArrayArray = new double[][][]{new double[][]{{0.5, d / 2.0}, {1.0, 1.0}}, new double[][]{{1.0, d2}, {0.0, -d / 2.0}}, new double[][]{{0.5 - d / 2.0, -d / 2.0}, {1.0, 1.0}}, new double[][]{{1.0 - d2, -d2}, {d / 2.0, d / 2.0}}, new double[][]{{1.0 / d, 2.0 / d}, {1.0 - 1.0 / d, -2.0 / d}}, new double[][]{{0.5, 1.0}, {1.0 - d2 / d, -2.0 * d2 / d}}};
        return dArrayArray;
    }

    public static double generalizedWrightFunction(double d, double[][] dArray, double[][] dArray2) {
        int n = dArray.length;
        int n2 = dArray2.length;
        double d2 = 0.0;
        double d3 = 1.0;
        for (int i = 0; i < 50; ++i) {
            double d4;
            double[] dArray3;
            int n3;
            double d5 = 1.0;
            for (n3 = 0; n3 < n; ++n3) {
                dArray3 = dArray[n3];
                d4 = BifractionalDiffusionDensity.gamma(dArray3[0] + dArray3[1] * (double)i);
                if (!Double.isNaN(d4)) {
                    d5 *= d4;
                    continue;
                }
                d5 = Double.NaN;
            }
            for (n3 = 0; n3 < n2; ++n3) {
                dArray3 = dArray2[n3];
                d4 = BifractionalDiffusionDensity.gamma(dArray3[0] + dArray3[1] * (double)i);
                if (!Double.isNaN(d4)) {
                    d5 /= d4;
                    continue;
                }
                d5 = 0.0;
            }
            d5 /= BifractionalDiffusionDensity.gamma(i + 1);
            d2 += (d5 *= d3);
            d3 *= d;
        }
        return d2;
    }

    public static void main(String[] stringArray) {
        double d = 2.0;
        double d2 = 0.8;
        double d3 = -2.34;
        SignedDouble signedDouble = BifractionalDiffusionDensity.logGamma(d3);
        System.err.println("logGamma(" + d3 + ") = " + signedDouble.x + " " + (signedDouble.positive ? "(+)" : "(-)"));
        System.err.println("gamma(" + d3 + ") = " + BifractionalDiffusionDensity.gamma(d3));
        System.err.println("gamma(-2.0) = " + BifractionalDiffusionDensity.gamma(-2.0));
        System.err.println("");
        double d4 = 4.0;
        double d5 = 0.5 * d4;
        double d6 = 1.0;
        double[][][] dArray = BifractionalDiffusionDensity.constructBifractionalDiffusionCoefficients(d, d2);
        System.err.println("p(x = " + d6 + ", v = " + d4 + ") = " + BifractionalDiffusionDensity.evaluateGreensFunctionAlphaGreaterThanBeta(d6, d5, d, d2, dArray));
        d = 0.7;
        d2 = 1.4;
        dArray = BifractionalDiffusionDensity.constructBifractionalDiffusionCoefficients(d, d2);
        System.err.println("p(x = " + d6 + ", v = " + d4 + ") = " + BifractionalDiffusionDensity.evaluateGreensFunctionBetaGreaterThanAlpha(d6, d5, d, d2, dArray));
    }

    static class SignedDouble {
        double x;
        boolean positive;

        SignedDouble(double d, boolean bl) {
            this.x = d;
            this.positive = bl;
        }
    }
}

