/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.model.MatrixParameterInterface;
import dr.inference.multidimensionalscaling.mm.MMAlgorithm;
import dr.inference.multidimensionalscaling.mm.MultiDimensionalScalingMM;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class ModeFindOperator
extends AbstractAdaptableOperator {
    public static final String OPERATOR = "modeFindOperator";
    public static final String MAX_TIMES = "maxTimes";
    public static final String SCALE_FACTOR = "sd";
    private double scaleFactor;
    private final int maxTimes;
    private final int maxSteps;
    private int executeTimes = 0;
    private final MultiDimensionalScalingMM mm;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newIntegerRule("maxTimes", true), AttributeRule.newDoubleRule("weight"), AttributeRule.newBooleanRule("autoOptimize", true), AttributeRule.newDoubleRule("sd", true), new ElementRule(MultiDimensionalScalingMM.class)};

        @Override
        public String getParserName() {
            return ModeFindOperator.OPERATOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            AdaptationMode adaptationMode = AdaptationMode.parseMode(xMLObject);
            double d = xMLObject.getAttribute(ModeFindOperator.SCALE_FACTOR, 1.0);
            System.err.println((Object)adaptationMode);
            double d2 = xMLObject.getDoubleAttribute("weight");
            int n = xMLObject.getAttribute(ModeFindOperator.MAX_TIMES, Integer.MAX_VALUE);
            MultiDimensionalScalingMM multiDimensionalScalingMM = (MultiDimensionalScalingMM)xMLObject.getChild(MMAlgorithm.class);
            return new ModeFindOperator(multiDimensionalScalingMM, n, d2, adaptationMode, d);
        }

        @Override
        public String getParserDescription() {
            return "This element returns a mode finder that always accepts.";
        }

        @Override
        public Class getReturnType() {
            return ModeFindOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public ModeFindOperator(MultiDimensionalScalingMM multiDimensionalScalingMM, int n, double d, AdaptationMode adaptationMode, double d2) {
        this(multiDimensionalScalingMM, n, d, 1000, adaptationMode, d2);
    }

    public ModeFindOperator(MultiDimensionalScalingMM multiDimensionalScalingMM, int n, double d, int n2, AdaptationMode adaptationMode, double d2) {
        super(adaptationMode);
        this.setWeight(d);
        this.maxTimes = n;
        this.mm = multiDimensionalScalingMM;
        this.maxSteps = n2;
        this.scaleFactor = d2;
    }

    @Override
    public double doOperation() {
        if (this.executeTimes < this.maxTimes) {
            MatrixParameterInterface matrixParameterInterface = this.mm.getLikelihood().getMatrixParameter();
            boolean bl = this.mode == AdaptationMode.ADAPTATION_ON || this.mode == AdaptationMode.DEFAULT;
            this.mm.run(this.maxSteps);
            ++this.executeTimes;
            double d = Double.POSITIVE_INFINITY;
            if (bl) {
                System.err.println("Adaptive sampling: " + this.scaleFactor);
                d = 0.0;
            }
            return d;
        }
        throw new RuntimeException("Finished max times");
    }

    @Override
    public final String getOperatorName() {
        return OPERATOR;
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(this.scaleFactor);
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        this.scaleFactor = Math.exp(d);
    }

    @Override
    public double getRawParameter() {
        return this.scaleFactor;
    }

    @Override
    public String getAdaptableParameterName() {
        return "scaleFactor";
    }
}

