/*
 * Decompiled with CFR 0.152.
 */
package dr.geo;

import dr.geo.AbstractPolygon2D;
import dr.geo.GeoSpatialCollectionModel;
import dr.geo.MultiRegionGeoSpatialDistribution;
import dr.geo.Polygon2D;
import dr.inference.distribution.CachedDistributionLikelihood;
import dr.inference.distribution.MultivariateDistributionLikelihood;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.math.distributions.MultivariateDistribution;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import dr.xml.XORRule;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class GeoSpatialDistribution
implements MultivariateDistribution,
Citable {
    public static final String FLAT_SPATIAL_DISTRIBUTION = "flatGeoSpatialPrior";
    public static final String DATA = "data";
    public static final String TYPE = "geoSpatial";
    public static final String NODE_LABEL = "taxon";
    public static final String KML_FILE = "kmlFileName";
    public static final String INSIDE = "inside";
    public static final String UNION = "union";
    public static final String CACHE = "cache";
    private static final String DEFAULT_LABEL = "";
    public static final int dimPoint = 2;
    protected AbstractPolygon2D region;
    protected String label = null;
    private boolean outside = false;
    public static XMLObjectParser FLAT_GEOSPATIAL_PRIOR_PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newStringRule("taxon", true), AttributeRule.newBooleanRule("inside", true), AttributeRule.newBooleanRule("union", true), AttributeRule.newBooleanRule("cache", true), new XORRule(AttributeRule.newStringRule("kmlFileName"), new ElementRule(Polygon2D.class, 1, Integer.MAX_VALUE)), new ElementRule("data", new XMLSyntaxRule[]{new ElementRule(Parameter.class, 1, Integer.MAX_VALUE)})};

        @Override
        public String getParserName() {
            return GeoSpatialDistribution.FLAT_SPATIAL_DISTRIBUTION;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Object object;
            Object object2;
            Object object3;
            String string = xMLObject.getAttribute(GeoSpatialDistribution.NODE_LABEL, GeoSpatialDistribution.DEFAULT_LABEL);
            boolean bl = xMLObject.getAttribute(GeoSpatialDistribution.INSIDE, true);
            boolean bl2 = xMLObject.getAttribute(GeoSpatialDistribution.UNION, false);
            boolean bl3 = false;
            boolean bl4 = xMLObject.getAttribute(GeoSpatialDistribution.CACHE, false);
            ArrayList<GeoSpatialDistribution> arrayList = new ArrayList<GeoSpatialDistribution>();
            boolean bl5 = false;
            if (xMLObject.hasAttribute(GeoSpatialDistribution.KML_FILE)) {
                object3 = xMLObject.getStringAttribute(GeoSpatialDistribution.KML_FILE);
                object2 = Polygon2D.readKMLFile((String)object3);
                AbstractPolygon2D abstractPolygon2D = object2.get(0);
                boolean bl6 = abstractPolygon2D.hasFillValue();
                if (object2.size() > 1) {
                    for (int i = 1; i < object2.size(); ++i) {
                        if (bl6 == ((AbstractPolygon2D)object2.get(i)).hasFillValue()) continue;
                        throw new XMLParseException("Inconsistent fillValue attributes provided.");
                    }
                }
                if (bl6) {
                    double d = 0.0;
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        AbstractPolygon2D abstractPolygon2D2 = (AbstractPolygon2D)iterator.next();
                        d += abstractPolygon2D2.getFillValue();
                    }
                    if (Math.abs(d - 1.0) > 1.0E-12) {
                        throw new XMLParseException("Fill values in " + (String)object3 + " do not sum to 1 : " + d);
                    }
                }
                bl5 = bl6;
                object = object2.iterator();
                while (object.hasNext()) {
                    AbstractPolygon2D abstractPolygon2D3 = (AbstractPolygon2D)object.next();
                    arrayList.add(new GeoSpatialDistribution(string, abstractPolygon2D3, bl));
                }
                bl3 = true;
            } else {
                for (int i = 0; i < xMLObject.getChildCount(); ++i) {
                    if (!(xMLObject.getChild(i) instanceof Polygon2D)) continue;
                    object2 = (Polygon2D)xMLObject.getChild(i);
                    arrayList.add(new GeoSpatialDistribution(string, (AbstractPolygon2D)object2, bl));
                }
            }
            object3 = new ArrayList();
            object2 = xMLObject.getChild(GeoSpatialDistribution.DATA);
            for (int i = 0; i < ((XMLObject)object2).getChildCount(); ++i) {
                Parameter parameter = (Parameter)((XMLObject)object2).getChild(i);
                object3.add(parameter);
            }
            if (arrayList.size() == 1) {
                MultivariateDistributionLikelihood multivariateDistributionLikelihood = new MultivariateDistributionLikelihood((MultivariateDistribution)arrayList.get(0));
                Iterator iterator = object3.iterator();
                if (iterator.hasNext()) {
                    object = (Parameter)iterator.next();
                    if (object.getDimension() % 2 != 0) {
                        throw new XMLParseException("Spatial priors currently only work in 2D");
                    }
                    if (!string.equals(GeoSpatialDistribution.DEFAULT_LABEL)) {
                        multivariateDistributionLikelihood.addData((Parameter)object);
                        return multivariateDistributionLikelihood;
                    }
                    Logger.getLogger("dr.geo").info("\nConstructing a GeoSpatialCollectionModel:\n\tParameter: " + object.getId() + "\n\tNumber of regions: " + arrayList.size() + "\n\n");
                    return new GeoSpatialCollectionModel(xMLObject.getId(), (Parameter)object, arrayList, !bl2);
                }
            }
            if (arrayList.size() == 0) {
                throw new XMLParseException("Error constructing geo spatial distributions in " + xMLObject.getId());
            }
            if (object3.size() == 1) {
                Parameter parameter = (Parameter)object3.get(0);
                if (parameter.getDimension() % 2 != 0) {
                    throw new XMLParseException("Spatial priors currently only work in 2D");
                }
                if (!string.equals(GeoSpatialDistribution.DEFAULT_LABEL)) {
                    Logger.getLogger("dr.geo").info("\nConstructing a multiple-region spatial prior:\n\tTaxon: " + string + "\n\tNumber of regions: " + arrayList.size() + "\n\n");
                    MultivariateDistributionLikelihood multivariateDistributionLikelihood = new MultivariateDistributionLikelihood(new MultiRegionGeoSpatialDistribution(string, arrayList, bl2, bl5));
                    multivariateDistributionLikelihood.addData(parameter);
                    multivariateDistributionLikelihood.setId(xMLObject.getId());
                    if (bl4) {
                        return new CachedDistributionLikelihood(xMLObject.getId(), multivariateDistributionLikelihood, parameter);
                    }
                    return multivariateDistributionLikelihood;
                }
                Logger.getLogger("dr.geo").info("\nConstructing a GeoSpatialCollectionModel:\n\tParameter: " + parameter.getId() + "\n\tNumber of regions: " + arrayList.size() + "\n\n");
                return new GeoSpatialCollectionModel(xMLObject.getId(), parameter, arrayList, !bl2);
            }
            throw new XMLParseException("Multiple separate parameters and multiple regions not yet implemented");
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "Calculates the likelihood of some data under a 2D geospatial distribution.";
        }

        @Override
        public Class getReturnType() {
            return MultivariateDistributionLikelihood.class;
        }
    };

    public GeoSpatialDistribution(String string) {
        this.label = string;
    }

    public GeoSpatialDistribution(String string, AbstractPolygon2D abstractPolygon2D, boolean bl) {
        this.label = string;
        this.region = abstractPolygon2D;
        this.outside = !bl;
    }

    @Override
    public double logPdf(double[] dArray) {
        return this.region.getLogProbability(new Point2D.Double(dArray[0], dArray[1]), this.outside);
    }

    @Override
    public double[][] getScaleMatrix() {
        return null;
    }

    @Override
    public double[] getMean() {
        return null;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean getOutside() {
        return this.outside;
    }

    public AbstractPolygon2D getRegion() {
        return this.region;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.PRIOR_MODELS;
    }

    @Override
    public String getDescription() {
        return "Integrated continuous traits over polygons";
    }

    @Override
    public List<Citation> getCitations() {
        ArrayList<Citation> arrayList = new ArrayList<Citation>();
        arrayList.add(new Citation(new Author[]{new Author("S", "Nylinder"), new Author("P", "Lemey"), new Author("M", "de Bruyn"), new Author("MA", "Suchard"), new Author("BE", "Pfeil"), new Author("N", "Walsh"), new Author("AA", "Anderberg")}, "On the biogeography of Centipeda: a species-tree diffusion approach", 2014, "Systematic Biology", 63, 178, 191, Citation.Status.PUBLISHED));
        return arrayList;
    }

    public static void main(String[] stringArray) {
        int n;
        List<AbstractPolygon2D> list = Polygon2D.readKMLFile("Multiple_polygons/9.285_105.7244444.kml");
        System.out.println(list.size() + " polygons found.");
        AbstractPolygon2D abstractPolygon2D = list.get(0);
        int n2 = abstractPolygon2D.hasFillValue();
        if (list.size() > 1) {
            for (n = 1; n < list.size(); n += 1) {
                if (n2 == list.get(n).hasFillValue()) continue;
                System.out.println("Inconsistent fillValue attributes provided.");
            }
        }
        if (n2) {
            double d = 0.0;
            for (AbstractPolygon2D object2 : list) {
                d += object2.getFillValue();
            }
            if (Math.abs(d - 1.0) > 1.0E-12) {
                System.out.println("\nFill values do not sum to 1 : " + d);
            }
        }
        n = n2;
        ArrayList<GeoSpatialDistribution> arrayList = new ArrayList<GeoSpatialDistribution>();
        for (AbstractPolygon2D abstractPolygon2D2 : list) {
            arrayList.add(new GeoSpatialDistribution("test", abstractPolygon2D2, false));
        }
        Object object3 = new MultivariateDistributionLikelihood(new MultiRegionGeoSpatialDistribution("multi", arrayList, false, n != 0));
        Parameter.Default default_ = new Parameter.Default("coordinate", 2);
        ((MultivariateDistributionLikelihood)object3).addData(default_);
        double d = ((MultivariateDistributionLikelihood)object3).calculateLogLikelihood();
        System.out.println("\n(" + default_.getParameterValue(0) + "," + default_.getParameterValue(1) + ")");
        System.out.println("logL = " + d);
        System.out.println("L = " + Math.exp(d));
        default_.setParameterValue(0, 11.4);
        default_.setParameterValue(1, 106.9);
        ((Likelihood.Abstract)object3).makeDirty();
        d = ((MultivariateDistributionLikelihood)object3).calculateLogLikelihood();
        System.out.println("\n(" + default_.getParameterValue(0) + "," + default_.getParameterValue(1) + ")");
        System.out.println("logL = " + d);
        System.out.println("L = " + Math.exp(d));
        list = Polygon2D.readKMLFile("Districts_polygons/21.035_106.063.kml");
        System.out.println("\n" + list.size() + " polygons found.");
        abstractPolygon2D = list.get(0);
        n2 = abstractPolygon2D.hasFillValue();
        if (list.size() > 1) {
            for (int i = 1; i < list.size(); ++i) {
                if (n2 == list.get(i).hasFillValue()) continue;
                System.out.println("Inconsistent fillValue attributes provided.");
            }
        }
        if (n2) {
            double d2 = 0.0;
            for (AbstractPolygon2D abstractPolygon2D3 : list) {
                d2 += abstractPolygon2D3.getFillValue();
            }
            if (Math.abs(d2 - 1.0) > 1.0E-12) {
                System.out.println("\nFill values do not sum to 1 : " + d2);
            }
        }
        n = n2;
        arrayList = new ArrayList();
        for (AbstractPolygon2D abstractPolygon2D4 : list) {
            arrayList.add(new GeoSpatialDistribution("test", abstractPolygon2D4, false));
        }
        object3 = new MultivariateDistributionLikelihood(new MultiRegionGeoSpatialDistribution("multi", arrayList, false, n != 0));
        ((MultivariateDistributionLikelihood)object3).addData(default_);
        d = ((MultivariateDistributionLikelihood)object3).calculateLogLikelihood();
        System.out.println("\n(" + default_.getParameterValue(0) + "," + default_.getParameterValue(1) + ")");
        System.out.println("logL = " + d);
        System.out.println("L = " + Math.exp(d));
        default_.setParameterValue(0, 21.0);
        default_.setParameterValue(1, 106.03);
        ((Likelihood.Abstract)object3).makeDirty();
        d = ((MultivariateDistributionLikelihood)object3).calculateLogLikelihood();
        System.out.println("\n(" + default_.getParameterValue(0) + "," + default_.getParameterValue(1) + ")");
        System.out.println("logL = " + d);
        System.out.println("L = " + Math.exp(d));
        default_.setParameterValue(0, 21.0);
        default_.setParameterValue(1, 106.1);
        ((Likelihood.Abstract)object3).makeDirty();
        d = ((MultivariateDistributionLikelihood)object3).calculateLogLikelihood();
        System.out.println("\n(" + default_.getParameterValue(0) + "," + default_.getParameterValue(1) + ")");
        System.out.println("logL = " + d);
        System.out.println("L = " + Math.exp(d));
    }
}

