/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.evolution.datatype.DataType;
import dr.evolution.datatype.GeneralDataType;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;

public class CompositeDataTypeParser
extends AbstractXMLObjectParser {
    public static final String COMPOSITE_DATA_TYPE = "compositeDataType";
    public static final String COMPOSITE_STATE_SEPARATOR = "-";
    private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(DataType.class, 2, 2)};

    @Override
    public String getParserName() {
        return COMPOSITE_DATA_TYPE;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<DataType> arrayList2 = new ArrayList<DataType>();
        for (int i = 0; i < xMLObject.getChildCount(); ++i) {
            if (!(xMLObject.getChild(i) instanceof DataType)) {
                throw new XMLParseException("illegal element in " + this.getParserName() + " element");
            }
            arrayList2.add((DataType)xMLObject.getChild(i));
        }
        if (arrayList2.size() != 2) {
            throw new XMLParseException("CompositeDataType requires exactly 2 component DataTypes");
        }
        DataType dataType = (DataType)arrayList2.get(0);
        DataType dataType2 = (DataType)arrayList2.get(1);
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (int i = 0; i < dataType.getStateCount(); ++i) {
            String string = dataType.getCode(i);
            for (int j = 0; j < dataType2.getStateCount(); ++j) {
                String string2 = dataType2.getCode(j);
                arrayList3.add(string + COMPOSITE_STATE_SEPARATOR + string2);
            }
        }
        if (arrayList.size() == 0) {
            throw new XMLParseException("No state elements defined in " + this.getParserName() + " element");
        }
        if (arrayList.size() < 2) {
            throw new XMLParseException("Fewer than two state elements defined in " + this.getParserName() + " element");
        }
        GeneralDataType generalDataType = new GeneralDataType(arrayList);
        return generalDataType;
    }

    @Override
    public String getParserDescription() {
        return "Defines a composite DataType consisting of multiple data types";
    }

    @Override
    public Class getReturnType() {
        return DataType.class;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }
}

