/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.preorder;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.TransformableTree;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evolution.tree.TreeTraitProvider;
import dr.evomodel.continuous.MultivariateDiffusionModel;
import dr.evomodel.treedatalikelihood.ProcessOnTreeDelegate;
import dr.evomodel.treedatalikelihood.ProcessSimulation;
import dr.evomodel.treedatalikelihood.TreeTraversal;
import dr.evomodel.treedatalikelihood.continuous.ConjugateRootTraitPrior;
import dr.evomodel.treedatalikelihood.continuous.ContinuousDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.continuous.ContinuousRateTransformation;
import dr.evomodel.treedatalikelihood.continuous.ContinuousTraitPartialsProvider;
import dr.evomodel.treedatalikelihood.continuous.PartiallyMissingInformation;
import dr.evomodel.treedatalikelihood.continuous.RootProcessDelegate;
import dr.evomodel.treedatalikelihood.preorder.ConditionalVarianceAndTransform;
import dr.inference.model.Model;
import dr.inference.model.ModelListener;
import dr.math.matrixAlgebra.IllegalDimension;
import dr.math.matrixAlgebra.Matrix;
import dr.math.matrixAlgebra.SymmetricMatrix;
import dr.math.matrixAlgebra.missingData.MissingOps;
import java.util.List;
import java.util.Map;
import org.ejml.data.DenseMatrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.CholeskyDecomposition;

public interface ProcessSimulationDelegate
extends ProcessOnTreeDelegate,
TreeTraitProvider,
ModelListener {
    public void simulate(int[] var1, int var2, int var3);

    public void setCallback(ProcessSimulation var1);

    public int vectorizeNodeOperations(List<ProcessOnTreeDelegate.NodeOperation> var1, int[] var2);

    public int getSingleOperationSize();

    public static abstract class AbstractContinuousTraitDelegate
    extends AbstractDelegate {
        final int dimTrait;
        final int numTraits;
        final int dimNode;
        final MultivariateDiffusionModel diffusionModel;
        final ContinuousTraitPartialsProvider dataModel;
        final ConjugateRootTraitPrior rootPrior;
        final RootProcessDelegate rootProcessDelegate;
        final ContinuousDataLikelihoodDelegate likelihoodDelegate;
        double[] diffusionVariance;
        DenseMatrix64F Vd;
        DenseMatrix64F Pd;
        double[][] cholesky;
        Map<PartiallyMissingInformation.HashedIntArray, ConditionalVarianceAndTransform> conditionalMap;
        private final ContinuousRateTransformation rateTransformation;

        AbstractContinuousTraitDelegate(String string, Tree tree, MultivariateDiffusionModel multivariateDiffusionModel, ContinuousTraitPartialsProvider continuousTraitPartialsProvider, ConjugateRootTraitPrior conjugateRootTraitPrior, ContinuousRateTransformation continuousRateTransformation, ContinuousDataLikelihoodDelegate continuousDataLikelihoodDelegate) {
            super(string, tree);
            this.dimTrait = continuousDataLikelihoodDelegate.getTraitDim();
            this.numTraits = continuousDataLikelihoodDelegate.getTraitCount();
            this.dimNode = this.dimTrait * this.numTraits;
            this.diffusionModel = multivariateDiffusionModel;
            this.dataModel = continuousTraitPartialsProvider;
            this.rateTransformation = continuousRateTransformation;
            this.rootPrior = conjugateRootTraitPrior;
            this.rootProcessDelegate = continuousDataLikelihoodDelegate.getRootProcessDelegate();
            this.likelihoodDelegate = continuousDataLikelihoodDelegate;
            multivariateDiffusionModel.addModelListener(this);
        }

        @Override
        public int getSingleOperationSize() {
            return 5;
        }

        @Override
        protected final double getNormalization() {
            return this.rateTransformation.getNormalization();
        }

        protected boolean isLoggable() {
            return true;
        }

        @Override
        public void modelChangedEvent(Model model, Object object, int n) {
            if (model != this.diffusionModel) {
                throw new IllegalArgumentException("Unknown model");
            }
            this.clearCache();
        }

        @Override
        public void modelRestored(Model model) {
        }

        @Override
        protected void setupStatistics() {
            if (this.diffusionVariance == null) {
                double[][] dArray = this.diffusionModel.getPrecisionmatrix();
                this.diffusionVariance = AbstractContinuousTraitDelegate.getVectorizedVarianceFromPrecision(dArray);
                this.Vd = MissingOps.wrap(this.diffusionVariance, 0, this.dimTrait, this.dimTrait);
                this.Pd = new DenseMatrix64F(dArray);
            }
            if (this.cholesky == null) {
                this.cholesky = AbstractContinuousTraitDelegate.getCholeskyOfVariance(this.diffusionVariance, this.dimTrait);
            }
        }

        void clearCache() {
            this.diffusionVariance = null;
            this.Vd = null;
            this.Pd = null;
            this.cholesky = null;
            this.conditionalMap = null;
        }

        static double[][] getCholeskyOfVariance(Matrix matrix) {
            double[][] dArray;
            try {
                dArray = new dr.math.matrixAlgebra.CholeskyDecomposition(matrix).getL();
            }
            catch (IllegalDimension illegalDimension) {
                throw new RuntimeException("Attempted Cholesky decomposition on non-square matrix");
            }
            return dArray;
        }

        static double[][] getCholeskyOfVariance(double[] dArray, int n) {
            return dr.math.matrixAlgebra.CholeskyDecomposition.execute(dArray, 0, n);
        }

        static DenseMatrix64F getCholeskyOfVariance(DenseMatrix64F denseMatrix64F, int n) {
            CholeskyDecomposition<DenseMatrix64F> choleskyDecomposition = DecompositionFactory.chol(n, true);
            choleskyDecomposition.decompose(denseMatrix64F);
            return choleskyDecomposition.getT(null);
        }

        private static double[] getVectorizedVarianceFromPrecision(double[][] dArray) {
            return new SymmetricMatrix(dArray).inverse().toArrayComponents();
        }
    }

    public static abstract class AbstractDelegate
    implements ProcessSimulationDelegate {
        final TreeTraitProvider.Helper treeTraitHelper = new TreeTraitProvider.Helper();
        ProcessSimulation simulationProcess = null;
        final Tree tree;
        final Tree baseTree;
        final String name;

        AbstractDelegate(String string, Tree tree) {
            this.name = string;
            this.tree = tree;
            this.baseTree = AbstractDelegate.getBaseTree(tree);
            this.constructTraits(this.treeTraitHelper);
        }

        protected abstract void constructTraits(TreeTraitProvider.Helper var1);

        @Override
        public final TreeTraversal.TraversalType getOptimalTraversalType() {
            return TreeTraversal.TraversalType.PRE_ORDER;
        }

        @Override
        public final void setCallback(ProcessSimulation processSimulation) {
            this.simulationProcess = processSimulation;
        }

        @Override
        public void simulate(int[] nArray, int n, int n2) {
            this.setupStatistics();
            this.simulateRoot(n2);
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                this.simulateNode(nArray[n3], nArray[n3 + 1], nArray[n3 + 2], nArray[n3 + 3], nArray[n3 + 4]);
                n3 += 5;
            }
        }

        private static Tree getBaseTree(Tree tree) {
            while (tree instanceof TransformableTree) {
                tree = ((TransformableTree)((Object)tree)).getOriginalTree();
            }
            return tree;
        }

        static NodeRef getBaseNode(Tree tree, NodeRef nodeRef) {
            while (tree instanceof TransformableTree) {
                tree = ((TransformableTree)((Object)tree)).getOriginalTree();
                nodeRef = ((TransformableTree)((Object)tree)).getOriginalNode(nodeRef);
            }
            return nodeRef;
        }

        protected double getNormalization() {
            return 1.0;
        }

        @Override
        public final TreeTrait[] getTreeTraits() {
            return this.treeTraitHelper.getTreeTraits();
        }

        @Override
        public final TreeTrait getTreeTrait(String string) {
            return this.treeTraitHelper.getTreeTrait(string);
        }

        protected abstract void setupStatistics();

        protected abstract void simulateRoot(int var1);

        protected abstract void simulateNode(int var1, int var2, int var3, int var4, int var5);
    }
}

