/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.continuous;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.treedatalikelihood.continuous.ContinuousTraitDataModel;
import dr.evomodel.treedatalikelihood.continuous.ContinuousTraitPartialsProvider;
import dr.evomodel.treedatalikelihood.continuous.cdi.PrecisionType;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.ejml.data.DenseMatrix64F;

public class TaxonEffectTraitDataModel
extends ContinuousTraitDataModel
implements ContinuousTraitPartialsProvider {
    private final EffectMap map;
    private final Parameter effects;
    private final Tree tree;
    private final Parameter sign;
    private static final boolean DEBUG = false;

    public TaxonEffectTraitDataModel(String string, Tree tree, CompoundParameter compoundParameter, EffectMap effectMap, boolean[] blArray, boolean bl, int n, PrecisionType precisionType) {
        super(string, compoundParameter, blArray, bl, n, precisionType);
        this.tree = tree;
        this.map = effectMap;
        this.effects = effectMap.parameter;
        this.sign = effectMap.sign;
        if (compoundParameter.getDimension() != this.effects.getDimension()) {
            throw new IllegalArgumentException("Unequal effects dimension");
        }
        if (n != 1) {
            throw new IllegalArgumentException("Not yet implemented");
        }
        this.addVariable(this.effects);
        if (this.sign != null) {
            this.addVariable(this.sign);
        }
    }

    public EffectMap getMap() {
        return this.map;
    }

    public Tree getTree() {
        return this.tree;
    }

    public Parameter getEffects() {
        return this.map.getEffects();
    }

    @Override
    public double[] getTipPartial(int n, boolean bl) {
        double[] dArray = super.getTipPartial(n, bl);
        int n2 = this.map.getEffectIndex(n);
        double d = this.effects.getParameterValue(n2);
        int n3 = this.map.getSign();
        dArray[0] = dArray[0] - (double)n3 * d;
        return dArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        super.handleVariableChangedEvent(variable, n, changeType);
        if (variable == this.effects) {
            if (changeType == Variable.ChangeType.VALUE_CHANGED && n != -1) {
                this.fireModelChanged(this, this.getTaxonIndex(n));
                return;
            } else {
                if (changeType != Variable.ChangeType.ALL_VALUES_CHANGED && n != -1) throw new RuntimeException("Unhandled parameter change type");
                this.fireModelChanged(this);
            }
            return;
        } else {
            if (variable != this.sign || variable == null) return;
            this.fireModelChanged(this);
        }
    }

    @Override
    protected int getTaxonIndex(int n) {
        return this.map.getTaxonIndex(n / (this.dimTrait * this.numTraits));
    }

    @Override
    public void updateTipDataGradient(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, NodeRef nodeRef, int n, int n2) {
        throw new RuntimeException("not yet implemented");
    }

    @Override
    public boolean needToUpdateTipDataGradient(int n, int n2) {
        throw new RuntimeException("not yet implemented");
    }

    public static class EffectMap {
        private final Parameter parameter;
        private final Parameter sign;
        private final Map<String, Integer> taxonNameToIndex;
        private final Map<Integer, String> indexToTaxonName;
        private final int[] map;
        private final int[] inverseMap;
        private final int dim;

        public EffectMap(Tree tree, Parameter parameter, Parameter parameter2, int n) {
            if (tree.getExternalNodeCount() != parameter.getDimension() * n) {
                throw new IllegalArgumentException("Invalid effect dimension");
            }
            this.parameter = parameter;
            this.sign = parameter2;
            this.dim = n;
            this.taxonNameToIndex = new HashMap<String, Integer>();
            this.indexToTaxonName = new HashMap<Integer, String>();
            String string = parameter.getParameterName();
            String[] stringArray = new String[tree.getExternalNodeCount() * n];
            for (int i = 0; i < tree.getExternalNodeCount(); ++i) {
                String string2 = tree.getTaxonId(i);
                this.taxonNameToIndex.put(string2, i);
                this.indexToTaxonName.put(i, string2);
                for (int j = 0; j < n; ++j) {
                    stringArray[n * i + j] = EffectMap.makeName(string, string2, j + 1);
                }
            }
            parameter.setDimensionNames(stringArray);
            this.map = this.makeMap(tree, this.taxonNameToIndex);
            this.inverseMap = this.makeInverseMap(this.map);
        }

        public EffectMap(Tree tree, Parameter parameter, Parameter parameter2, int n, EffectMap effectMap) {
            if (tree.getExternalNodeCount() != parameter.getDimension() * n) {
                throw new IllegalArgumentException("Invalid effect dimension");
            }
            this.parameter = parameter;
            this.sign = parameter2;
            this.dim = n;
            this.taxonNameToIndex = effectMap.taxonNameToIndex;
            this.indexToTaxonName = effectMap.indexToTaxonName;
            String string = parameter.getParameterName();
            String[] stringArray = new String[tree.getExternalNodeCount() * n];
            for (int i = 0; i < tree.getExternalNodeCount(); ++i) {
                for (int j = 0; j < n; ++j) {
                    stringArray[n * i + j] = EffectMap.makeName(string, this.indexToTaxonName.get(i), j + 1);
                }
            }
            parameter.setDimensionNames(stringArray);
            this.map = this.makeMap(tree, this.taxonNameToIndex);
            this.inverseMap = this.makeInverseMap(this.map);
        }

        public EffectMap(Tree tree, EffectMap effectMap) {
            this.parameter = effectMap.parameter;
            this.sign = effectMap.sign;
            this.taxonNameToIndex = effectMap.taxonNameToIndex;
            this.indexToTaxonName = effectMap.indexToTaxonName;
            this.dim = effectMap.dim;
            this.map = this.makeMap(tree, this.taxonNameToIndex);
            this.inverseMap = this.makeInverseMap(this.map);
        }

        public int getEffectIndex(int n) {
            return this.map[n];
        }

        public int getSign() {
            if (this.sign == null || this.sign.getParameterValue(0) > 0.0) {
                return 1;
            }
            return -1;
        }

        public int getTaxonIndex(int n) {
            return this.inverseMap[n];
        }

        public Parameter getEffects() {
            return this.parameter;
        }

        private int[] makeInverseMap(int[] nArray) {
            int[] nArray2 = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray2[nArray[i]] = i;
            }
            return nArray2;
        }

        private int[] makeMap(Tree tree, Map<String, Integer> map) {
            int[] nArray = new int[tree.getExternalNodeCount()];
            Arrays.fill(nArray, -1);
            for (int i = 0; i < tree.getExternalNodeCount(); ++i) {
                String string = tree.getTaxonId(i);
                Integer n = map.get(string);
                if (n == null) {
                    throw new IllegalArgumentException("Unable to find taxon '" + string + "'");
                }
                nArray[i] = n;
            }
            return nArray;
        }

        private static String makeName(String string, String string2, int n) {
            return string + "." + string2 + "." + n;
        }
    }
}

