/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.treedatalikelihood.ProcessOnTreeDelegate;
import dr.evomodel.treedatalikelihood.TreeTraversal;
import java.util.ArrayList;
import java.util.List;

public class SimulationTreeTraversal
extends TreeTraversal {
    private final List<ProcessOnTreeDelegate.BranchNodeOperation> branchNodeOperations = new ArrayList<ProcessOnTreeDelegate.BranchNodeOperation>();
    private final List<ProcessOnTreeDelegate.NodeOperation> nodeOperations = new ArrayList<ProcessOnTreeDelegate.NodeOperation>();

    public SimulationTreeTraversal(Tree tree, BranchRateModel branchRateModel, TreeTraversal.TraversalType traversalType) {
        super(tree, branchRateModel, traversalType);
    }

    @Override
    public final void dispatchTreeTraversalCollectBranchAndNodeOperations() {
        this.branchNodeOperations.clear();
        this.nodeOperations.clear();
        switch (this.traversalType) {
            case PRE_ORDER: {
                this.traversePreOrder(this.treeModel);
                break;
            }
            default: {
                assert (false) : "Unknown traversal type";
                break;
            }
        }
    }

    public List<ProcessOnTreeDelegate.BranchNodeOperation> getBranchNodeOperations() {
        return this.branchNodeOperations;
    }

    public List<ProcessOnTreeDelegate.NodeOperation> getNodeOperations() {
        return this.nodeOperations;
    }

    private void traversePreOrder(Tree tree) {
        this.traversePreOrder(tree, tree.getRoot(), null, null);
    }

    private boolean traversePreOrder(Tree tree, NodeRef nodeRef, NodeRef nodeRef2, NodeRef nodeRef3) {
        boolean bl = nodeRef2 == null;
        int n = nodeRef.getNumber();
        if (nodeRef2 != null && this.updateNode[n]) {
            this.branchNodeOperations.add(new ProcessOnTreeDelegate.BranchNodeOperation(n, nodeRef2.getNumber(), this.computeBranchLength(tree, nodeRef)));
            this.nodeOperations.add(new ProcessOnTreeDelegate.NodeOperation(nodeRef2.getNumber(), n, nodeRef3.getNumber()));
            bl = true;
        }
        if (!tree.isExternal(nodeRef)) {
            NodeRef nodeRef4 = tree.getChild(nodeRef, 0);
            NodeRef nodeRef5 = tree.getChild(nodeRef, 1);
            if (bl) {
                boolean bl2 = this.traversePreOrder(tree, nodeRef4, nodeRef, nodeRef5);
                boolean bl3 = this.traversePreOrder(tree, nodeRef5, nodeRef, nodeRef4);
            }
        }
        return bl;
    }
}

