/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.siteratemodel;

import dr.evomodel.siteratemodel.SiteRateModel;
import dr.evomodel.substmodel.SubstitutionModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.Collections;
import java.util.List;

public class PdfSiteRateModel
extends AbstractModel
implements SiteRateModel,
Citable {
    public static final Citation CITATION = new Citation(new Author[]{new Author("Z", "Yang")}, "Maximum likelihood phylogenetic estimation from DNA sequences with variable rates over sites: approximate methods", 1994, "J. Mol. Evol.", 39, 306, 314, Citation.Status.PUBLISHED);
    private final Parameter rates;
    private final Parameter weights;
    private final int dim;
    private double[] categoryRates;
    private double[] categoryProportions;
    private boolean ratesKnown;
    private SubstitutionModel substitutionModel;

    public PdfSiteRateModel(String string, Parameter parameter, Parameter parameter2) {
        super(string);
        this.rates = parameter;
        this.weights = parameter2;
        this.dim = Math.min(parameter.getDimension(), parameter2.getDimension());
        this.addVariable(parameter);
        this.addVariable(parameter2);
        this.ratesKnown = false;
    }

    @Override
    public int getCategoryCount() {
        return this.dim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[] getCategoryRates() {
        PdfSiteRateModel pdfSiteRateModel = this;
        synchronized (pdfSiteRateModel) {
            if (!this.ratesKnown) {
                this.calculateCategoryRates();
            }
        }
        return this.categoryRates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[] getCategoryProportions() {
        PdfSiteRateModel pdfSiteRateModel = this;
        synchronized (pdfSiteRateModel) {
            if (!this.ratesKnown) {
                this.calculateCategoryRates();
            }
        }
        return this.categoryProportions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getRateForCategory(int n) {
        PdfSiteRateModel pdfSiteRateModel = this;
        synchronized (pdfSiteRateModel) {
            if (!this.ratesKnown) {
                this.calculateCategoryRates();
            }
        }
        return this.categoryRates[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getProportionForCategory(int n) {
        PdfSiteRateModel pdfSiteRateModel = this;
        synchronized (pdfSiteRateModel) {
            if (!this.ratesKnown) {
                this.calculateCategoryRates();
            }
        }
        return this.categoryProportions[n];
    }

    private void calculateCategoryRates() {
        int n;
        double d = 0.0;
        double d2 = 0.0;
        for (n = 0; n < this.dim; ++n) {
            d += this.rates.getParameterValue(n) * this.weights.getParameterValue(n);
            d2 += this.weights.getParameterValue(n);
        }
        if (this.categoryRates == null) {
            this.categoryRates = new double[this.dim];
        }
        if (this.categoryProportions == null) {
            this.categoryProportions = new double[this.dim];
        }
        for (n = 0; n < this.dim; ++n) {
            this.categoryRates[n] = this.rates.getParameterValue(n) / d;
            this.categoryProportions[n] = this.weights.getParameterValue(n) / d2;
        }
        this.ratesKnown = true;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.listenerHelper.fireModelChanged(this, object, n);
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable != this.rates && variable != this.weights) {
            throw new RuntimeException("Unknown variable in PdfSiteRateModel.handleVariableChangedEvent");
        }
        this.ratesKnown = false;
        this.listenerHelper.fireModelChanged(this, variable, n);
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
        this.ratesKnown = false;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.SUBSTITUTION_MODELS;
    }

    @Override
    public String getDescription() {
        return "Discrete probability distribution free rate heterogeneity model";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CITATION);
    }

    public SubstitutionModel getSubstitutionModel() {
        return this.substitutionModel;
    }

    public void setSubstitutionModel(SubstitutionModel substitutionModel) {
        this.substitutionModel = substitutionModel;
    }
}

