/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.tree.NodeRef;
import dr.evomodel.bigfasttree.thorney.ConstrainableTreeOperator;
import dr.evomodel.operators.AbstractTreeOperator;
import dr.evomodel.tree.TreeModel;
import dr.math.MathUtils;

public class ExchangeOperator
extends AbstractTreeOperator
implements ConstrainableTreeOperator {
    public static final int NARROW = 0;
    public static final int WIDE = 1;
    private static final int MAX_TRIES = 100;
    private int mode = 0;
    private final TreeModel tree;
    private double[] distances;

    public ExchangeOperator(int n, TreeModel treeModel, double d) {
        this.mode = n;
        this.tree = treeModel;
        this.setWeight(d);
    }

    @Override
    public double doOperation(TreeModel treeModel) {
        double d;
        int n = treeModel.getExternalNodeCount();
        switch (this.mode) {
            case 0: {
                d = this.narrow(treeModel) ? 0.0 : Double.NEGATIVE_INFINITY;
                break;
            }
            case 1: {
                d = this.wide(treeModel) ? 0.0 : Double.NEGATIVE_INFINITY;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow Exchange Mode");
            }
        }
        assert (treeModel.getExternalNodeCount() == n) : "Lost some tips in " + (this.mode == 0 ? "NARROW mode." : "WIDE mode.");
        return d;
    }

    @Override
    public double doOperation() {
        return this.doOperation(this.tree);
    }

    public boolean narrow(TreeModel treeModel) {
        NodeRef nodeRef;
        int n = treeModel.getNodeCount();
        NodeRef nodeRef2 = nodeRef = treeModel.getRoot();
        while (nodeRef == nodeRef2 || treeModel.getParent(nodeRef2) == nodeRef) {
            nodeRef2 = treeModel.getNode(MathUtils.nextInt(n));
        }
        NodeRef nodeRef3 = treeModel.getParent(nodeRef2);
        NodeRef nodeRef4 = treeModel.getParent(nodeRef3);
        NodeRef nodeRef5 = treeModel.getChild(nodeRef4, 0);
        if (nodeRef5 == nodeRef3) {
            nodeRef5 = treeModel.getChild(nodeRef4, 1);
        }
        assert (nodeRef5 == this.getOtherChild(treeModel, nodeRef4, nodeRef3));
        assert (treeModel.getNodeHeight(nodeRef2) <= treeModel.getNodeHeight(nodeRef4));
        if (treeModel.getNodeHeight(nodeRef5) < treeModel.getNodeHeight(nodeRef3)) {
            this.exchangeNodes(treeModel, nodeRef2, nodeRef5, nodeRef3, nodeRef4);
            return true;
        }
        return false;
    }

    public boolean wide(TreeModel treeModel) {
        NodeRef nodeRef;
        NodeRef nodeRef2;
        int n = treeModel.getNodeCount();
        NodeRef nodeRef3 = nodeRef2 = treeModel.getRoot();
        while (nodeRef2 == nodeRef3) {
            nodeRef3 = treeModel.getNode(MathUtils.nextInt(n));
        }
        NodeRef nodeRef4 = nodeRef3;
        while (nodeRef4 == nodeRef3 || nodeRef4 == nodeRef2) {
            nodeRef4 = treeModel.getNode(MathUtils.nextInt(n));
        }
        NodeRef nodeRef5 = treeModel.getParent(nodeRef3);
        if (nodeRef5 != (nodeRef = treeModel.getParent(nodeRef4)) && nodeRef3 != nodeRef && nodeRef4 != nodeRef5 && treeModel.getNodeHeight(nodeRef4) < treeModel.getNodeHeight(nodeRef5) && treeModel.getNodeHeight(nodeRef3) < treeModel.getNodeHeight(nodeRef)) {
            this.exchangeNodes(treeModel, nodeRef3, nodeRef4, nodeRef5, nodeRef);
            return true;
        }
        return false;
    }

    private int indexOf(NodeRef[] nodeRefArray, NodeRef nodeRef) {
        for (int i = 0; i < nodeRefArray.length; ++i) {
            if (nodeRefArray[i] != nodeRef) continue;
            return i;
        }
        return -1;
    }

    private double getWinningChance(int n) {
        double d = 0.0;
        for (double d2 : this.distances) {
            d += 1.0 / d2;
        }
        return 1.0 / this.distances[n] / d;
    }

    private void calcDistances(NodeRef[] nodeRefArray, NodeRef nodeRef) {
        this.distances = new double[nodeRefArray.length];
        for (int i = 0; i < nodeRefArray.length; ++i) {
            this.distances[i] = this.getNodeDistance(nodeRef, nodeRefArray[i]) + 1;
        }
    }

    private NodeRef getRandomNode(NodeRef[] nodeRefArray, NodeRef nodeRef) {
        this.calcDistances(nodeRefArray, nodeRef);
        double d = 0.0;
        for (double d2 : this.distances) {
            d += 1.0 / d2;
        }
        double d3 = MathUtils.nextDouble() * d;
        NodeRef nodeRef2 = null;
        for (int i = 0; i < this.distances.length; ++i) {
            if (!((d3 -= 1.0 / this.distances[i]) <= 0.0)) continue;
            nodeRef2 = nodeRefArray[i];
            break;
        }
        return nodeRef2;
    }

    private int getNodeDistance(NodeRef nodeRef, NodeRef nodeRef2) {
        int n = 0;
        while (nodeRef != nodeRef2) {
            ++n;
            if (this.tree.getNodeHeight(nodeRef) < this.tree.getNodeHeight(nodeRef2)) {
                nodeRef = this.tree.getParent(nodeRef);
                continue;
            }
            nodeRef2 = this.tree.getParent(nodeRef2);
        }
        return n;
    }

    public int getMode() {
        return this.mode;
    }

    @Override
    public String getOperatorName() {
        return (this.mode == 0 ? "Narrow" : "Wide") + " Exchange(" + this.tree.getId() + ")";
    }

    public double getMinimumAcceptanceLevel() {
        if (this.mode == 0) {
            return 0.05;
        }
        return 0.01;
    }

    public double getMinimumGoodAcceptanceLevel() {
        if (this.mode == 0) {
            return 0.05;
        }
        return 0.01;
    }

    public String getPerformanceSuggestion() {
        return "";
    }
}

