/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic;

import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class ClusterSingleMoveOperator
extends SimpleMCMCOperator {
    public static final boolean DEBUG = false;
    public static final String CLUSTER_SINGLE_MOVE_OPERATOR = "clusterSingleMoveOperator";
    private final int N;
    private int K;
    private final Parameter allocationParameter;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), new ElementRule(Parameter.class)};

        @Override
        public String getParserName() {
            return ClusterSingleMoveOperator.CLUSTER_SINGLE_MOVE_OPERATOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getDoubleAttribute("weight");
            Parameter parameter = (Parameter)xMLObject.getChild(Parameter.class);
            return new ClusterSingleMoveOperator(parameter, d);
        }

        @Override
        public String getParserDescription() {
            return "An operator that moves single elements between clusters.";
        }

        @Override
        public Class getReturnType() {
            return ClusterSingleMoveOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public ClusterSingleMoveOperator(Parameter parameter, double d) {
        this.allocationParameter = parameter;
        this.N = parameter.getDimension();
        this.setWeight(d);
    }

    @Override
    public Parameter getParameter() {
        return this.allocationParameter;
    }

    public Variable getVariable() {
        return this.allocationParameter;
    }

    @Override
    public final double doOperation() {
        int[] nArray = new int[this.allocationParameter.getDimension()];
        int[] nArray2 = new int[this.N];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (int)this.allocationParameter.getParameterValue(i);
            int n2 = nArray[i];
            nArray2[n2] = nArray2[n2] + 1;
            if (nArray2[nArray[i]] != 1) continue;
            ++n;
        }
        double d = 0.0;
        int n3 = MathUtils.nextInt(this.N);
        int n4 = nArray[n3];
        int n5 = nArray2[n4];
        int n6 = MathUtils.nextInt(this.N);
        while (n3 == n6) {
            n6 = MathUtils.nextInt(this.N);
        }
        int n7 = nArray[n6];
        int n8 = nArray2[n7];
        if (n4 != n7) {
            nArray[n3] = n7;
            this.allocationParameter.setParameterValue(n3, n7);
            if (n5 > 1) {
                d = Math.log(n5 - 1) - Math.log(n8);
            }
        } else {
            int n9 = 0;
            int n10 = MathUtils.nextInt(this.N - n);
            int n11 = 0;
            for (int i = 0; i < this.N; ++i) {
                if (nArray2[i] != 0) continue;
                if (n9 == n10) {
                    n11 = i;
                }
                ++n9;
            }
            while (nArray2[n11] > 0) {
                ++n11;
            }
            nArray[n3] = n11;
            this.allocationParameter.setParameterValue(n3, n11);
        }
        return d;
    }

    @Override
    public final String getOperatorName() {
        return "clusterSingleMoveOperator(" + this.allocationParameter.getId() + ")";
    }

    public final void optimize(double d) {
        throw new RuntimeException("This operator cannot be optimized!");
    }

    public boolean isOptimizing() {
        return false;
    }

    public void setOptimizing(boolean bl) {
        throw new RuntimeException("This operator cannot be optimized!");
    }

    public double getMinimumAcceptanceLevel() {
        return 0.1;
    }

    public double getMaximumAcceptanceLevel() {
        return 0.4;
    }

    public double getMinimumGoodAcceptanceLevel() {
        return 0.2;
    }

    public double getMaximumGoodAcceptanceLevel() {
        return 0.3;
    }

    public String getPerformanceSuggestion() {
        if (this.getAcceptanceProbability() < this.getMinimumAcceptanceLevel()) {
            return "";
        }
        if (this.getAcceptanceProbability() > this.getMaximumAcceptanceLevel()) {
            return "";
        }
        return "";
    }

    public String toString() {
        return this.getOperatorName();
    }

    public int getStepCount() {
        return 1;
    }
}

