/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.tree;

import dr.evolution.distance.DistanceMatrix;
import dr.evolution.tree.ClusteringTree;
import dr.evolution.tree.SimpleNode;

public class NeighborJoiningTree
extends ClusteringTree {
    private double[] r;
    private double scale;
    private double maxHeight;

    public NeighborJoiningTree(DistanceMatrix distanceMatrix) {
        super(distanceMatrix, 3);
    }

    @Override
    protected void init(DistanceMatrix distanceMatrix) {
        super.init(distanceMatrix);
        this.r = new double[this.numClusters];
        this.maxHeight = 0.0;
    }

    @Override
    protected void findNextPair() {
        for (int i = 0; i < this.numClusters; ++i) {
            this.r[i] = 0.0;
            for (int j = 0; j < this.numClusters; ++j) {
                int n = i;
                this.r[n] = this.r[n] + this.getDist(i, j);
            }
        }
        this.besti = 0;
        this.bestj = 1;
        double d = -1.0;
        this.scale = 1.0 / (double)(this.numClusters - 2);
        for (int i = 0; i < this.numClusters - 1; ++i) {
            for (int j = i + 1; j < this.numClusters; ++j) {
                double d2 = (this.r[i] + this.r[j]) * this.scale - this.getDist(i, j);
                if (!(d2 > d)) continue;
                d = d2;
                this.besti = i;
                this.bestj = j;
            }
        }
        this.abi = this.alias[this.besti];
        this.abj = this.alias[this.bestj];
    }

    @Override
    protected void finish() {
        this.abi = this.alias[0];
        this.abj = this.alias[1];
        this.newCluster = new SimpleNode();
        double d = this.getDist(0, 1);
        double d2 = d * 0.5;
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        this.appendHeight(this.clusters[this.abi], d2);
        this.appendHeight(this.clusters[this.abj], d2);
        this.newCluster.setHeight(0.0);
        this.newCluster.addChild(this.clusters[this.abi]);
        this.newCluster.addChild(this.clusters[this.abj]);
        this.reverseHeights(this.newCluster, this.maxHeight);
        super.finish();
    }

    private void reverseHeights(SimpleNode simpleNode, double d) {
        double d2 = d - simpleNode.getHeight();
        simpleNode.setHeight(d2);
        if (!simpleNode.isExternal()) {
            int n = simpleNode.getChildCount();
            for (int i = 0; i < n; ++i) {
                this.reverseHeights(simpleNode.getChild(i), d);
            }
        }
    }

    @Override
    protected double newNodeHeight() {
        double d = this.getDist(this.besti, this.bestj);
        double d2 = (d + (this.r[this.besti] - this.r[this.bestj]) * this.scale) * 0.5;
        double d3 = d - d2;
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        this.appendHeight(this.clusters[this.abi], d2);
        this.appendHeight(this.clusters[this.abj], d3);
        return 0.0;
    }

    private void appendHeight(SimpleNode simpleNode, double d) {
        double d2 = simpleNode.getHeight() + d;
        simpleNode.setHeight(d2);
        if (!simpleNode.isExternal()) {
            int n = simpleNode.getChildCount();
            for (int i = 0; i < n; ++i) {
                this.appendHeight(simpleNode.getChild(i), d);
            }
        } else if (d2 > this.maxHeight) {
            this.maxHeight = d2;
        }
    }

    @Override
    protected double updatedDistance(int n, int n2, int n3) {
        return (this.getDist(n3, n) + this.getDist(n3, n2) - this.getDist(n, n2)) * 0.5;
    }
}

