/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.alignment;

import dr.evolution.alignment.Alignment;
import dr.evolution.datatype.DataType;
import dr.evolution.sequence.Sequence;
import dr.evolution.util.Taxon;

public class Consensus {
    int[] counts;
    int[] consensus;
    int total;
    String name;
    DataType dataType = null;

    public Consensus(String string, Alignment alignment, boolean bl) {
        int n;
        int n2;
        int n3;
        this.name = string;
        this.dataType = alignment.getDataType();
        int[][] nArray = new int[alignment.getSiteCount()][this.dataType.getAmbiguousStateCount()];
        for (n3 = 0; n3 < alignment.getSequenceCount(); ++n3) {
            for (n2 = 0; n2 < alignment.getSiteCount(); ++n2) {
                n = alignment.getState(n3, n2);
                if (bl) {
                    if (n >= this.dataType.getStateCount()) continue;
                    int[] nArray2 = nArray[n2];
                    int n4 = n;
                    nArray2[n4] = nArray2[n4] + 1;
                    continue;
                }
                int[] nArray3 = nArray[n2];
                int n5 = n;
                nArray3[n5] = nArray3[n5] + 1;
            }
        }
        this.counts = new int[alignment.getSiteCount()];
        this.total = alignment.getSequenceCount();
        this.consensus = new int[alignment.getSiteCount()];
        for (n3 = 0; n3 < alignment.getSiteCount(); ++n3) {
            n2 = 0;
            n = nArray[n3][0];
            for (int i = 1; i < nArray[n3].length; ++i) {
                int n6 = nArray[n3][i];
                if (n6 <= n) continue;
                n2 = i;
                n = n6;
            }
            this.consensus[n3] = n2;
            this.counts[n3] = n;
        }
    }

    public double getReliability(int n) {
        return (double)this.counts[n] / (double)this.total;
    }

    public int getState(int n) {
        return this.consensus[n];
    }

    public final Sequence getConsensusSequence() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.consensus.length; ++i) {
            stringBuffer.append(this.dataType.getChar(this.getState(i)));
        }
        Sequence sequence = new Sequence(new Taxon(this.name), stringBuffer.toString());
        sequence.setDataType(this.dataType);
        return sequence;
    }
}

