/*
 * Decompiled with CFR 0.152.
 */
package sample;

import beagleutil.CenteredIntIntervalTree;
import beagleutil.IntIntervalTree;
import blbutil.IndexSet;
import dag.Dag;
import dag.MergeableDag;
import haplotype.HapPairs;
import haplotype.SampleHapPairs;
import ibd.HapSegment;
import ibd.IbsHapSegments;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import sample.DiploidStates;

public class RestrictedDag {
    private static final int END_FILTER = 1;
    private final SampleHapPairs haps;
    private final Dag dag;
    private final int[][] hapStates;
    private final IbsHapSegments hapSegments;
    private final double[] pos;
    private final double ibdExtend;

    public RestrictedDag(SampleHapPairs sampleHapPairs, float[] fArray, int n, float f, double d, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException(String.valueOf(d));
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException(String.valueOf(d2));
        }
        this.haps = sampleHapPairs;
        this.ibdExtend = d2;
        this.dag = MergeableDag.dag(sampleHapPairs, fArray, f, n);
        this.pos = RestrictedDag.pos(this.dag);
        this.hapStates = RestrictedDag.hapStates(this.dag, sampleHapPairs);
        this.hapSegments = new IbsHapSegments(sampleHapPairs, this.pos, d);
    }

    private static double[] pos(Dag dag) {
        double[] dArray = dag.posArray();
        double d = 0.2;
        int n = 0;
        while (n < dArray.length) {
            int n2 = n++;
            dArray[n2] = dArray[n2] * d;
        }
        return dArray;
    }

    private static int[][] hapStates(Dag dag, HapPairs hapPairs) {
        if (dag.nLevels() != hapPairs.nMarkers()) {
            throw new IllegalArgumentException("dag.nMarkers()!=haps.nMarkers()");
        }
        int n = hapPairs.nHaps();
        int[][] nArray = new int[dag.nLevels()][n];
        for (int i = 0; i < n; ++i) {
            int n2 = 0;
            int n3 = hapPairs.allele(0, i);
            nArray[0][i] = dag.outEdgeBySymbol(0, n2, n3);
            for (int j = 1; j < nArray.length; ++j) {
                n2 = dag.childNode(j - 1, nArray[j - 1][i]);
                n3 = hapPairs.allele(j, i);
                nArray[j][i] = dag.outEdgeBySymbol(j, n2, n3);
                assert (nArray[j][i] != -1);
            }
        }
        return nArray;
    }

    public SampleHapPairs sampleHaps() {
        return this.haps;
    }

    public Dag dag() {
        return this.dag;
    }

    public DiploidStates singleStates(int n) {
        if (n < 0 || n >= this.haps.nSamples()) {
            throw new IndexOutOfBoundsException("sample: " + n);
        }
        int n2 = 2 * n;
        int n3 = 2 * n + 1;
        List<HapSegment> list = this.ibsSegs(n2);
        List<HapSegment> list2 = this.ibsSegs(n3);
        return new SinglePermittedStates(this.haps.nMarkers(), this.haps.nHaps(), n, list, list2);
    }

    private List<HapSegment> ibsSegs(int n) {
        List<HapSegment> list = this.hapSegments.filteredFind(n);
        this.containmentFilter(list, 1);
        return list;
    }

    private void containmentFilter(List<HapSegment> list, int n) {
        assert (n >= 0);
        Collections.sort(list, RestrictedDag.modStartComparator());
        if (!list.isEmpty()) {
            LinkedList<HapSegment> linkedList = new LinkedList<HapSegment>();
            ArrayList<HapSegment> arrayList = new ArrayList<HapSegment>(list.size() / 5);
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                HapSegment hapSegment = list.get(i);
                boolean bl = false;
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext() && !bl) {
                    HapSegment hapSegment2 = (HapSegment)iterator.next();
                    int n3 = hapSegment2.start();
                    int n4 = hapSegment2.end();
                    if (n4 <= hapSegment.start()) {
                        iterator.remove();
                        continue;
                    }
                    if (hapSegment.start() - n3 < n || n4 - hapSegment.end() < n) continue;
                    bl = true;
                }
                if (bl) continue;
                linkedList.add(hapSegment);
                arrayList.add(hapSegment);
            }
            list.clear();
            list.addAll(arrayList);
        }
    }

    private static Comparator<HapSegment> modStartComparator() {
        return (hapSegment, hapSegment2) -> {
            if (hapSegment.start() != hapSegment2.start()) {
                return hapSegment.start() < hapSegment2.start() ? -1 : 1;
            }
            if (hapSegment.end() != hapSegment2.end()) {
                return hapSegment.end() > hapSegment2.end() ? -1 : 1;
            }
            if (hapSegment.hap() != hapSegment2.hap()) {
                return hapSegment.hap() < hapSegment2.hap() ? -1 : 1;
            }
            return 0;
        };
    }

    private int modifyStart(HapSegment hapSegment, IntIntervalTree<HapSegment> intIntervalTree) {
        int n = RestrictedDag.extStartIndex(hapSegment.start(), this.ibdExtend, this.pos);
        int n2 = hapSegment.end();
        ArrayList arrayList = new ArrayList(10);
        intIntervalTree.intersectAll(n, n2, arrayList);
        return arrayList.isEmpty() ? n : hapSegment.start();
    }

    private int modifyEnd(HapSegment hapSegment, IntIntervalTree<HapSegment> intIntervalTree) {
        int n = hapSegment.start();
        int n2 = RestrictedDag.extEndIndex(hapSegment.end(), this.ibdExtend, this.pos);
        ArrayList arrayList = new ArrayList(10);
        intIntervalTree.intersectAll(n, n2, arrayList);
        return arrayList.isEmpty() ? n2 : hapSegment.end();
    }

    private static int extStartIndex(int n, double d, double[] dArray) {
        double d2 = dArray[n] - d;
        int n2 = Arrays.binarySearch(dArray, d2);
        return n2 < 0 ? -n2 - 1 : n2;
    }

    private static int extEndIndex(int n, double d, double[] dArray) {
        double d2 = dArray[n] + d;
        int n2 = Arrays.binarySearch(dArray, d2);
        return n2 < 0 ? -n2 - 2 : n2;
    }

    private class SinglePermittedStates
    implements DiploidStates {
        private final int nMarkers;
        private final IndexSet indices1;
        private final IndexSet indices2;
        private final IntIntervalTree<HapSegment> tree1;
        private final IntIntervalTree<HapSegment> tree2;
        private int marker = -1;
        private int i1 = 0;
        private int i2 = 0;
        private int edge1 = -1;
        private int edge2 = -1;
        private boolean rev = false;

        private SinglePermittedStates(int n, int n2, int n3, List<HapSegment> list, List<HapSegment> list2) {
            int n4 = 2 * n3;
            int n5 = 2 * n3 + 1;
            this.nMarkers = n;
            this.indices1 = new IndexSet(n2);
            this.indices2 = new IndexSet(n2);
            List<HapSegment> list3 = this.extendSegment(n4, list);
            List<HapSegment> list4 = this.extendSegment(n5, list2);
            this.tree1 = this.getTree(n, list3);
            this.tree2 = this.getTree(n, list4);
        }

        private List<HapSegment> extendSegment(int n, List<HapSegment> list) {
            ArrayList<HapSegment> arrayList = new ArrayList<HapSegment>(list.size());
            IntIntervalTree<HapSegment> intIntervalTree = this.getTree(RestrictedDag.this.haps.nMarkers(), list);
            int n2 = RestrictedDag.this.haps.nMarkers() - 1;
            arrayList.add(new HapSegment(n, 0, n2));
            if (!list.isEmpty()) {
                int n3 = list.size();
                for (int i = 0; i < n3; ++i) {
                    HapSegment hapSegment = list.get(i);
                    int n4 = RestrictedDag.this.modifyStart(hapSegment, intIntervalTree);
                    int n5 = RestrictedDag.this.modifyEnd(hapSegment, intIntervalTree);
                    arrayList.add(new HapSegment(hapSegment.hap(), n4, n5));
                }
            }
            return arrayList;
        }

        private IntIntervalTree<HapSegment> getTree(int n, Collection<HapSegment> collection) {
            CenteredIntIntervalTree<HapSegment> centeredIntIntervalTree = new CenteredIntIntervalTree<HapSegment>(0, n - 1);
            collection.stream().forEach(hapSegment -> centeredIntIntervalTree.add((HapSegment)hapSegment));
            return centeredIntIntervalTree;
        }

        private void convertToIndices(int n, IntIntervalTree<HapSegment> intIntervalTree, IndexSet indexSet) {
            indexSet.clear();
            ArrayList arrayList = new ArrayList(30);
            intIntervalTree.intersect(n, arrayList);
            arrayList.stream().forEach(hapSegment -> indexSet.add(RestrictedDag.this.hapStates[n][hapSegment.hap()]));
        }

        @Override
        public int nMarkers() {
            return this.nMarkers;
        }

        @Override
        public int marker() {
            return this.marker;
        }

        @Override
        public void setMarker(int n) {
            this.marker = n;
            this.i1 = 0;
            this.i2 = 0;
            this.edge1 = -1;
            this.edge2 = -1;
            this.rev = false;
            this.convertToIndices(n, this.tree1, this.indices1);
            this.convertToIndices(n, this.tree2, this.indices2);
        }

        @Override
        public boolean hasNext() {
            return this.i1 < this.indices1.size();
        }

        @Override
        public void next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.rev) {
                int n = this.edge1;
                this.edge1 = this.edge2;
                this.edge2 = n;
                ++this.i2;
                if (this.i2 == this.indices2.size()) {
                    ++this.i1;
                    this.i2 = 0;
                }
                this.rev = false;
            } else {
                this.edge1 = this.indices1.enumeratedValue(this.i1);
                this.edge2 = this.indices2.enumeratedValue(this.i2);
                if (!this.indices1.contains(this.edge2) || !this.indices2.contains(this.edge1)) {
                    this.rev = true;
                } else {
                    ++this.i2;
                    if (this.i2 == this.indices2.size()) {
                        ++this.i1;
                        this.i2 = 0;
                    }
                }
            }
        }

        @Override
        public int edge1() {
            return this.edge1;
        }

        @Override
        public int edge2() {
            return this.edge2;
        }
    }
}

