/*
 * Decompiled with CFR 0.152.
 */
package haplotype;

import beagleutil.Samples;
import blbutil.Const;
import haplotype.HapPair;
import java.util.BitSet;
import vcf.Marker;
import vcf.Markers;

public final class BitHapPair
implements HapPair {
    private final Markers markers;
    private final Samples samples;
    private final int sampleIndex;
    private final BitSet alleles1;
    private final BitSet alleles2;

    public BitHapPair(Markers markers, Samples samples, int n, int[] nArray, int[] nArray2) {
        if (nArray.length != markers.nMarkers() || nArray2.length != markers.nMarkers()) {
            throw new IllegalArgumentException("inconsistent markers");
        }
        if (n < 0 || n >= samples.nSamples()) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        this.markers = markers;
        this.samples = samples;
        this.sampleIndex = n;
        this.alleles1 = BitHapPair.toBitSet(markers, nArray);
        this.alleles2 = BitHapPair.toBitSet(markers, nArray2);
    }

    private static BitSet toBitSet(Markers markers, int[] nArray) {
        int n = 0;
        BitSet bitSet = new BitSet(markers.sumHaplotypeBits());
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (n2 < 0 || n2 >= markers.marker(i).nAlleles()) {
                String string = "allele \"" + n2 + "\" out of bounds for marker: " + markers.marker(i);
                throw new IllegalArgumentException(string);
            }
            int n3 = 1;
            int n4 = markers.sumHaplotypeBits(i + 1) - markers.sumHaplotypeBits(i);
            for (int j = 0; j < n4; ++j) {
                boolean bl = (n2 & n3) == n3;
                bitSet.set(n++, bl);
                n3 <<= 1;
            }
        }
        return bitSet;
    }

    @Override
    public int allele1(int n) {
        return this.allele(this.alleles1, n);
    }

    @Override
    public int allele2(int n) {
        return this.allele(this.alleles2, n);
    }

    private int allele(BitSet bitSet, int n) {
        int n2 = this.markers.sumHaplotypeBits(n);
        int n3 = this.markers.sumHaplotypeBits(n + 1);
        if (n3 == n2 + 1) {
            return bitSet.get(n2) ? 1 : 0;
        }
        int n4 = 0;
        int n5 = 1;
        for (int i = n2; i < n3; ++i) {
            if (bitSet.get(i)) {
                n4 += n5;
            }
            n5 <<= 1;
        }
        return n4;
    }

    @Override
    public Markers markers() {
        return this.markers;
    }

    @Override
    public Marker marker(int n) {
        return this.markers.marker(n);
    }

    @Override
    public int nMarkers() {
        return this.markers.nMarkers();
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    @Override
    public int sampleIndex() {
        return this.sampleIndex;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("sampleIndex=");
        stringBuilder.append(this.sampleIndex);
        stringBuilder.append(Const.nl);
        stringBuilder.append(this.alleles1);
        stringBuilder.append(Const.nl);
        stringBuilder.append(this.alleles2);
        return stringBuilder.toString();
    }
}

