/*
 * Decompiled with CFR 0.152.
 */
package haplotype;

import beagleutil.Samples;
import haplotype.HapPair;
import haplotype.SampleHapPairs;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import vcf.Marker;
import vcf.Markers;

public final class BasicSampleHapPairs
implements SampleHapPairs {
    private final Markers markers;
    private final Samples samples;
    private final HapPair[] hapPairs;

    public BasicSampleHapPairs(Samples samples, List<HapPair> list) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("haps.isEmpy()==true");
        }
        Collections.sort(list, BasicSampleHapPairs.hapsComparator(samples));
        this.checkSamples(samples, list);
        this.markers = BasicSampleHapPairs.checkAndExtractMarkers(list);
        this.samples = samples;
        this.hapPairs = list.toArray(new HapPair[0]);
    }

    private void checkSamples(Samples samples, List<HapPair> list) {
        if (samples.nSamples() != list.size()) {
            throw new IllegalArgumentException("inconsistent samples");
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            int n2;
            if (samples.equals(list.get(i).samples())) continue;
            HapPair hapPair = list.get(i);
            int n3 = samples.idIndex(i);
            if (n3 == (n2 = hapPair.samples().idIndex(hapPair.sampleIndex()))) continue;
            throw new IllegalArgumentException("inconsistent samples");
        }
    }

    static Markers checkAndExtractMarkers(List<HapPair> list) {
        if (list.isEmpty()) {
            return Markers.create(new Marker[0]);
        }
        Markers markers = list.get(0).markers();
        int n = list.size();
        for (int i = 1; i < n; ++i) {
            if (list.get(i).markers().equals(markers)) continue;
            throw new IllegalArgumentException("inconsistent markers");
        }
        return markers;
    }

    @Override
    public int allele1(int n, int n2) {
        return this.hapPairs[n2].allele1(n);
    }

    @Override
    public int allele2(int n, int n2) {
        return this.hapPairs[n2].allele2(n);
    }

    @Override
    public int allele(int n, int n2) {
        int n3 = n2 / 2;
        if ((n2 & 1) == 0) {
            return this.hapPairs[n3].allele1(n);
        }
        return this.hapPairs[n3].allele2(n);
    }

    @Override
    public int nMarkers() {
        return this.markers.nMarkers();
    }

    @Override
    public Markers markers() {
        return this.markers;
    }

    @Override
    public Marker marker(int n) {
        return this.markers.marker(n);
    }

    @Override
    public int nHaps() {
        return 2 * this.hapPairs.length;
    }

    @Override
    public int nHapPairs() {
        return this.hapPairs.length;
    }

    @Override
    public int nSamples() {
        return this.samples.nSamples();
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    @Override
    public Samples samples(int n) {
        if (n < 0 || n >= this.hapPairs.length) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return this.samples;
    }

    @Override
    public int sampleIndex(int n) {
        if (n < 0 || n >= this.hapPairs.length) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return n;
    }

    @Override
    public int nAlleles(int n) {
        return this.markers.marker(n).nAlleles();
    }

    @Override
    public boolean storesNonMajorIndices(int n) {
        return false;
    }

    @Override
    public int majorAllele(int n) {
        String string = "this.storesNonMajorIndices(marker)==false";
        throw new UnsupportedOperationException(string);
    }

    @Override
    public int alleleCount(int n, int n2) {
        String string = "this.storesNonMajorIndices(marker)==false";
        throw new UnsupportedOperationException(string);
    }

    @Override
    public int hapIndex(int n, int n2, int n3) {
        String string = "this.storesNonMajorIndices(marker)==false";
        throw new UnsupportedOperationException(string);
    }

    private static Comparator<HapPair> hapsComparator(Samples samples) {
        if (samples == null) {
            throw new NullPointerException("samples==null");
        }
        return (hapPair, hapPair2) -> {
            int n = hapPair.samples().idIndex(hapPair.sampleIndex());
            int n2 = hapPair2.samples().idIndex(hapPair2.sampleIndex());
            int n3 = samples.index(n);
            int n4 = samples.index(n2);
            if (n3 == -1 || n4 == -1) {
                String string = n3 == -1 ? hapPair.samples().id(hapPair.sampleIndex()) : hapPair2.samples().id(hapPair2.sampleIndex());
                String string2 = "samples do not contain: " + string;
                throw new IllegalArgumentException(string2);
            }
            if (n3 == n4) {
                return 0;
            }
            return n3 < n4 ? -1 : 1;
        };
    }
}

