## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----eval = TRUE, comment = ""------------------------------------------------
library(smsets)
data("sparrows")
str(sparrows)

## ----eval = TRUE, comment = ""------------------------------------------------
# Table 4.1
# Means
aggregate(sparrows[, 2:5], by = list(Survivorship = sparrows$Survivorship),
          FUN = mean)
# Variances
aggregate(sparrows[, 2:5], by = list(Survivorship = sparrows$Survivorship),
          FUN = var)
# t.test using a formula
t.test(Total_length ~ Survivorship, data = sparrows, var.equal = TRUE)

## ----eval = TRUE, comment = ""------------------------------------------------
# Two-sample t-tests with p values adjusted by the Bonferroni correction. 
# The default alternatives are two-sided.
ttests.sparrows <- ttests2s.mv(sparrows, group = Survivorship, level1 = "S", 
                               var.equal = TRUE, P.adjust = "bonferroni", unit = "mm")
ttests.sparrows


## ----eval = TRUE, comment = ""------------------------------------------------
library(Hotelling)  
#  Hotelling's T2 test. The result is a list
T2.sparrows <- with(sparrows, hotelling.test(Total_length + Alar_extent + 
                                             L_beak_head + L_humerus + 
                                             L_keel_sternum ~ Survivorship))
# Output of the function hotelling.test is given
T2.sparrows

## ----eval = FALSE-------------------------------------------------------------
# Hotelling.mat(x, group, level1)

## ----evalu = TRUE, comment = ""-----------------------------------------------
# Hotelling's T2 test. Comparing multivariate means between survivor and 
# nonsurvivor sparrows using function Hotelling.mat
results.T2 <- Hotelling.mat(sparrows, group = Survivorship, level1 = "S")
# Long output
print(results.T2, long = TRUE)

## ----eval = TRUE, comment = ""------------------------------------------------
# F-test for Total length (not recommended)
with(sparrows, var.test(Total_length[Survivorship == "S"],
                        Total_length[Survivorship == "NS"]))

## ----eval = TRUE, comment = ""------------------------------------------------
library(car)
leveneTest(Total_length ~ Survivorship, data = sparrows)

## ----eval = TRUE, comment = ""------------------------------------------------
p.value.lower <- 0.235 / 2
p.value.lower

## ----eval = TRUE, comment = ""------------------------------------------------
fdr.Levene2s.mv <- Levenetests2s.mv(sparrows, Survivorship, "S",
                                alternative = "less", var.equal = TRUE,
                                P.adjust = "fdr", unit = "mm")
fdr.Levene2s.mv

## ----eval = TRUE, comment = ""------------------------------------------------
none.Levene2s.mv <- Levenetests2s.mv(sparrows, Survivorship, "S",
                                alternative = "less", var.equal = TRUE, unit = "mm")
none.Levene2s.mv

## ----eval = TRUE, comment = ""------------------------------------------------
# Levene's test based on Hotelling's T2
LeveneT2.sparrows <- LeveneT2(sparrows, group = Survivorship, level1 = "S",
                              var.equal = TRUE)
LeveneT2.sparrows

## ----eval = FALSE, comment = ""-----------------------------------------------
# print(LeveneT2.sparrows, long = TRUE)

## ----eval = TRUE, comment = ""------------------------------------------------
# Van Valen's test. A t-test based on absolute differences around medians from 
# standardized data
res.VanValen <- VanValen(sparrows, group = "Survivorship", level1 = "S", 
                         alternative = "less", var.equal = TRUE)
print(res.VanValen, long = TRUE)

## ----eval = TRUE, comment = ""------------------------------------------------
# One-factor ANOVA tests: comparing univariate means
# Variable: Maximum_breadth
library("smsets")
skulls.aovMB <- aov(Maximum_breadth ~ Period, data = skulls)
summary(skulls.aovMB)

## ----eval = TRUE, comment = ""------------------------------------------------
# One-factor MANOVA: comparing multivariate means
skulls.mnv <- manova(as.matrix(skulls[, -1]) ~ Period, data = skulls)
# Approximate F-test after the one-factor MANOVA
summary(skulls.mnv, test="Wilks")

## ----eval = TRUE, comment = ""------------------------------------------------
res.MANOVA <- OnewayMANOVA(skulls, group = Period)
print(res.MANOVA, long = TRUE)

## ----eval = TRUE, comment = ""------------------------------------------------
library(biotools)
groups <- skulls[, 1] # The grouping variable is located in the 1st column 
vars <- skulls[, -1]  # The y-variables are not located in the 1st column
# Producing the chi-square test of homogeneity of variance-covariance matrices
chitest.boxM <- boxM(vars, groups)
chitest.boxM

## ----eval = TRUE, comment = ""------------------------------------------------
resBoxM.F <- BoxM.F(skulls, Period)
print(resBoxM.F, long = TRUE)

## ----eval = TRUE, comment = ""------------------------------------------------
res.Penrose <- Penrose.dist(x = skulls, group = Period)
# Long output
print(res.Penrose, long = TRUE)

