/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.propagation;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.stream.Stream;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.propagation.PropagationObserver;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.SetEventType;

public class PropagationProfiler
implements PropagationObserver {
    private final Model model;
    private final long[] propCounters = new long[4];
    private final HashMap<Propagator<?>, Long> coarses;
    private final HashMap<Propagator<?>, Long> fines;
    private final HashMap<Propagator<?>, Long> failures;
    private final HashMap<Propagator<?>, Long> filters;
    private final HashMap<Variable, HashMap<IEventType, Long>> changes;

    public PropagationProfiler(Model model) {
        this.model = model;
        this.coarses = new HashMap();
        this.fines = new HashMap();
        this.filters = new HashMap();
        this.failures = new HashMap();
        this.changes = new HashMap();
    }

    @Override
    public void onCoarseEvent(Propagator<?> propagator) {
        this.coarses.compute(propagator, (k, c) -> c == null ? 1L : c + 1L);
        this.propCounters[0] = this.propCounters[0] + 1L;
    }

    @Override
    public void onFineEvent(Propagator<?> propagator) {
        this.fines.compute(propagator, (k, c) -> c == null ? 1L : c + 1L);
        this.propCounters[1] = this.propCounters[1] + 1L;
    }

    @Override
    public void onFailure(ICause cause, Propagator<?> propagator) {
        this.failures.compute(propagator, (k, c) -> c == null ? 1L : c + 1L);
        this.propCounters[3] = this.propCounters[3] + 1L;
    }

    @Override
    public void onFiltering(ICause cause, Propagator<?> propagator) {
        if (cause instanceof Propagator && cause.equals(propagator)) {
            this.filters.compute((Propagator)cause, (k, c) -> c == null ? 1L : c + 1L);
            this.propCounters[2] = this.propCounters[2] + 1L;
        }
    }

    @Override
    public void onVariableModification(Variable variable, IEventType type, ICause cause) {
        HashMap evt = this.changes.computeIfAbsent(variable, k -> new HashMap());
        evt.compute(type, (t, c) -> c == null ? 1L : c + 1L);
    }

    public void writeTo(File file, boolean rawValues) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        PrintWriter writer = new PrintWriter(fileWriter);
        this.writeTo(writer, rawValues);
        writer.close();
    }

    public void writeTo(PrintWriter writer, boolean rawValues) {
        this.profilePropagators(writer, rawValues);
        this.profileVariables(writer);
    }

    private void profilePropagators(PrintWriter writer, boolean rawValues) {
        writer.println("Propagators\n \n* id      : row id\n* coarse  : for a given propagator, number of coarse propagations, i.e., calls to `propagate(int)`\n* fine    : for a given propagator, number of fine propagations, i.e., calls to `propagate(int,int)`\n* filter  : for a given propagator, number of times a call to propagation removes a value from a variable's domain\n* fails   : for a given propagator, number of times it throws a failure\n* name    : name of the given propagator \n \n id        coarse      fine    filter     fails  name");
        Propagator[] propagators = (Propagator[])Stream.of(this.model.getCstrs()).flatMap(c -> Stream.of(c.getPropagators())).toArray(Propagator[]::new);
        for (int i = 0; i < propagators.length; ++i) {
            Propagator p = propagators[i];
            long c2 = this.coarses.getOrDefault(p, 0L);
            long fi = this.fines.getOrDefault(p, 0L);
            long fl = this.filters.getOrDefault(p, 0L);
            long fa = this.failures.getOrDefault(p, 0L);
            if (rawValues) {
                writer.printf(" %-6d %9d %9d %9d %9d  \"%s\"%n", i, c2, fi, fl, fa, p.toString());
                continue;
            }
            writer.printf(" %-6d %8.2f%% %8.2f%% %8.2f%% %8.2f%%  \"%s\"%n", i, (double)c2 * 100.0 / (double)this.propCounters[0], (double)fi * 100.0 / (double)this.propCounters[1], (double)fl * 100.0 / (double)this.propCounters[2], (double)fa * 100.0 / (double)this.propCounters[3], p.toString());
        }
        writer.printf("Total   %9d %9d %9d %9d%n", this.propCounters[0], this.propCounters[1], this.propCounters[2], this.propCounters[3]);
        writer.println();
    }

    private void profileVariables(PrintWriter writer) {
        SetVar[] svars;
        IntVar[] ivars = this.model.retrieveIntVars(true);
        int k = 0;
        if (ivars.length > 0) {
            writer.println("Integer variables\n \n* id      : row id\n* inst    : for a given integer variable, number of instantiation events\n* lower   : for a given integer variable, number of lower bound increasing events\n* upper   : for a given integer variable, number of upper bound decreasing events\n* bounds  : for a given integer variable, number of bounds modification events\n* remove  : for a given integer variable, number of value removal events\n* name    : name of the given variable \n \n id          inst     lower     upper    bounds    remove  name");
            for (int i = 0; i < ivars.length; ++i) {
                HashMap evts = this.changes.getOrDefault(ivars[i], new HashMap());
                long in = evts.getOrDefault(IntEventType.INSTANTIATE, 0L);
                long lb = evts.getOrDefault(IntEventType.INCLOW, 0L);
                long ub = evts.getOrDefault(IntEventType.DECUPP, 0L);
                long bd = evts.getOrDefault(IntEventType.BOUND, 0L);
                long rm = evts.getOrDefault(IntEventType.REMOVE, 0L);
                writer.printf(" %-6d %9d %9d %9d %9d %9d  \"%s\"%n", k++, in, lb, ub, bd, rm, ivars[i].getName());
            }
            writer.println();
        }
        if ((svars = this.model.retrieveSetVars()).length > 0) {
            writer.println("Set variables\n \n* id      : row id\n* kernel  : for a given integer variable, number of instantiation events\n* envel   : for a given integer variable, number of lower bound increasing events\n* name    : name of the given variable \n \n id       kernel     envel  name");
            writer.println("Set variables");
            writer.printf(" id       kernel     envel  name%n", new Object[0]);
            for (int i = 0; i < svars.length; ++i) {
                HashMap evts = this.changes.getOrDefault(svars[i], new HashMap());
                long ka = evts.getOrDefault(SetEventType.ADD_TO_KER, 0L);
                long re = evts.getOrDefault(SetEventType.REMOVE_FROM_ENVELOPE, 0L);
                writer.printf(" %-6d %9d %9d  \"%s\"%n", k++, ka, re, svars[i].getName());
            }
            writer.println();
        }
    }
}

