/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary;

import java.util.Arrays;
import java.util.stream.IntStream;
import org.chocosolver.memory.IStateBitSet;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;
import org.chocosolver.util.tools.ArrayUtils;

public class PropSweepBasedDiffN
extends Propagator<IntVar> {
    private final int nbOrthotopes;
    private final Orthotope[] os;
    private final IStateBitSet unfixed;
    private final UndirectedGraph overlapping;
    private final int[] maxl;
    private final int nbDimensions;
    private final Forbidden[] fs;
    private final IntIterableRangeSet supports;
    private final int[] c;
    private final int[] j;
    private final int[] dl;
    private final int[] ur;
    private final int[] ls;
    private final int options;
    private final boolean dom;

    public PropSweepBasedDiffN(IntVar[][] x, int[][] l) {
        super((Variable[])ArrayUtils.flatten(x), (Priority)PropagatorPriority.QUADRATIC, true);
        int i;
        this.dom = (Integer)this.model.getHookOrDefault("diffn", 2) == 2;
        this.options = (Integer)this.model.getHookOrDefault("diffnOpt", 1);
        this.nbDimensions = x[0].length;
        this.nbOrthotopes = x.length;
        this.os = new Orthotope[this.nbOrthotopes];
        this.overlapping = new UndirectedGraph(this.model, this.os.length, SetType.BITSET, true);
        this.maxl = new int[this.nbDimensions];
        this.c = new int[this.nbDimensions];
        this.j = new int[this.nbDimensions];
        this.dl = new int[this.nbDimensions];
        this.ur = new int[this.nbDimensions];
        this.ls = new int[this.nbDimensions];
        this.supports = new IntIterableRangeSet();
        this.unfixed = this.getModel().getEnvironment().makeBitSet(this.nbOrthotopes);
        this.unfixed.set(0, this.nbOrthotopes);
        for (i = 0; i < this.nbOrthotopes; ++i) {
            this.os[i] = new Orthotope(x[i], l[i], true);
            for (int d = 0; d < this.nbDimensions; ++d) {
                this.maxl[d] = Math.max(this.maxl[d], l[i][d]);
            }
        }
        this.fs = new Forbidden[this.os.length - 1];
        for (i = 0; i < this.fs.length; ++i) {
            this.fs[i] = new Forbidden(this.nbDimensions);
        }
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            for (int i = 0; i < this.nbOrthotopes; ++i) {
                for (int j = 0; j < i; ++j) {
                    if (!this.os[i].mayOverlap(this.os[j])) continue;
                    this.overlapping.addEdge(j, i);
                }
            }
        }
        this.filter();
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        int i = idxVarInProp / this.nbDimensions;
        this.os[i].checkSkippable(this.maxl);
        this.forcePropagate(PropagatorEventType.CUSTOM_PROPAGATION);
    }

    @Override
    public ESat isEntailed() {
        for (int i = 0; i < this.os.length; ++i) {
            if (!this.os[i].assignedInAllDimensions()) continue;
            for (int j = i + 1; j < this.os.length; ++j) {
                if (!this.os[j].assignedInAllDimensions() || !this.os[i].mayOverlap(this.os[j])) continue;
                return ESat.FALSE;
            }
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    private void filter() throws ContradictionException {
        boolean nonfix = true;
        boolean allFixed = true;
        boolean checkArea = false;
        while (nonfix) {
            nonfix = false;
            allFixed = true;
            int i = this.unfixed.nextSetBit(0);
            while (i > -1) {
                Orthotope o = this.os[i];
                o.modified = false;
                int nbF = this.getOutBoxes(this.os, this.nbDimensions, o, i);
                if (o.assignedInAllDimensions()) {
                    if (nbF > 0) {
                        this.fails();
                    }
                } else {
                    for (int d = 0; d < this.nbDimensions && nbF > 0; ++d) {
                        if (o.assignedInDimension(d)) continue;
                        this.pruneMin(o, d, nbF);
                        this.pruneMax(o, d, nbF);
                        if (o.enumeratedOnDimension(d) && this.dom) {
                            this.pruneDom(o, d, nbF);
                        }
                        if (!o.modified) continue;
                        nonfix = true;
                    }
                }
                if (!o.assignedInAllDimensions()) {
                    allFixed = false;
                } else {
                    this.unfixed.clear(i);
                }
                if (this.options == 1 || this.options == 3) {
                    checkArea = this.checkEnergy(i);
                }
                i = this.unfixed.nextSetBit(i + 1);
            }
        }
        if (this.options == 2 || checkArea && this.options == 3) {
            this.checkArea();
        }
        if (allFixed) {
            this.setPassive();
        }
    }

    private int getOutBoxes(Orthotope[] os, int k, Orthotope o, int i) {
        int m = 0;
        ISetIterator iter = this.overlapping.getNeighborsOf(i).iterator();
        while (iter.hasNext()) {
            int j = iter.nextInt();
            Orthotope o2 = os[j];
            Forbidden f = this.fs[m];
            boolean exists = true;
            boolean overlap = true;
            for (int d = 0; d < k; ++d) {
                overlap &= o.mayOverlap(o2, d);
                if (o2.x[d].getUB() - o.l[d] + 1 <= o2.x[d].getLB() + o2.l[d] - 1) {
                    f.set(d, o2.x[d].getUB() - o.l[d] + 1, o2.x[d].getLB() + o2.l[d] - 1);
                    continue;
                }
                exists = false;
            }
            if (exists && this.overlaps(o, f)) {
                ++m;
            }
            if (overlap) continue;
            this.overlapping.removeEdge(i, j);
        }
        return m;
    }

    private boolean overlaps(Orthotope o, Forbidden f) {
        for (int d = 0; d < this.nbDimensions; ++d) {
            if (o.x[d].getUB() >= f.min(d) && o.x[d].getLB() <= f.max(d)) continue;
            return false;
        }
        return true;
    }

    private void pruneMin(Orthotope o, int d, int nbF) throws ContradictionException {
        boolean b = true;
        for (int i = 0; i < this.nbDimensions; ++i) {
            this.c[i] = o.x[i].getLB();
            this.j[i] = o.x[i].getUB() + 1;
        }
        Forbidden f = this.getFR(this.c, nbF);
        while (b && f != null) {
            for (int i = 0; i < this.j.length; ++i) {
                this.j[i] = Math.min(this.j[i], f.max(i) + 1);
            }
            b = this.adjust(this.c, this.j, o, d, true);
            f = this.getFR(this.c, nbF);
        }
        o.modified |= o.x[d].updateLowerBound(this.c[d], (ICause)this);
        o.checkSkippable(this.maxl);
    }

    private void pruneMax(Orthotope o, int d, int nbF) throws ContradictionException {
        boolean b = true;
        for (int i = 0; i < this.nbDimensions; ++i) {
            this.c[i] = o.x[i].getUB();
            this.j[i] = o.x[i].getLB() - 1;
        }
        Forbidden f = this.getFR(this.c, nbF);
        while (b && f != null) {
            for (int i = 0; i < this.j.length; ++i) {
                this.j[i] = Math.max(this.j[i], f.min(i) - 1);
            }
            b = this.adjust(this.c, this.j, o, d, false);
            f = this.getFR(this.c, nbF);
        }
        o.modified |= o.x[d].updateUpperBound(this.c[d], (ICause)this);
        o.checkSkippable(this.maxl);
    }

    private void pruneDom(Orthotope o, int d, int nbF) throws ContradictionException {
        boolean b = true;
        this.supports.clear();
        for (int i = 0; i < this.nbDimensions; ++i) {
            this.c[i] = o.x[i].getLB();
            this.j[i] = o.x[i].getUB() + 1;
        }
        Forbidden f = this.getFR(this.c, nbF);
        while (b) {
            while (b && f != null) {
                for (int i = 0; i < this.j.length; ++i) {
                    this.j[i] = Math.min(this.j[i], f.max(i) + 1);
                }
                b = this.adjustDom(this.c, this.j, o, d, false);
                f = this.getFR(this.c, nbF);
            }
            if (!b) continue;
            this.supports.add(this.c[d]);
            b = this.adjustDom(this.c, this.j, o, d, true);
            f = this.getFR(this.c, nbF);
        }
        o.modified |= o.x[d].removeAllValuesBut(this.supports, this);
        o.checkSkippable(this.maxl);
    }

    private Forbidden getFR(int[] c, int nbF) {
        int i;
        for (i = 0; i < nbF && this.isFeasible(this.fs[i], c); ++i) {
        }
        if (i < nbF) {
            return this.fs[i];
        }
        return null;
    }

    private boolean isFeasible(Forbidden f, int[] c) {
        for (int j = 0; j < this.nbDimensions; ++j) {
            if (c[j] >= f.min(j) && c[j] <= f.max(j)) continue;
            return true;
        }
        return false;
    }

    private boolean adjust(int[] c, int[] j, Orthotope o, int d, boolean minimum) {
        if (minimum) {
            for (int i = this.nbDimensions - 1; i >= 0; --i) {
                int r = (i + d) % this.nbDimensions;
                c[r] = j[r];
                j[r] = o.x[r].getUB() + 1;
                if (c[r] <= o.x[r].getUB()) {
                    return true;
                }
                c[r] = o.x[r].getLB();
            }
        } else {
            for (int i = this.nbDimensions - 1; i >= 0; --i) {
                int r = (i + d) % this.nbDimensions;
                c[r] = j[r];
                j[r] = o.x[r].getLB() - 1;
                if (c[r] >= o.x[r].getLB()) {
                    return true;
                }
                c[r] = o.x[r].getUB();
            }
        }
        c[d] = j[d];
        return false;
    }

    private boolean adjustDom(int[] c, int[] j, Orthotope o, int d, boolean next) {
        if (next) {
            for (int i = this.nbDimensions - 1; i > 0; --i) {
                int r = (i + d) % this.nbDimensions;
                c[r] = o.x[r].getLB();
                j[r] = o.x[r].getUB() + 1;
            }
            c[d] = o.x[d].nextValue(c[d]);
            j[d] = o.x[d].getUB() + 1;
            if (c[d] <= j[d] - 1) {
                return true;
            }
            c[d] = o.x[d].getLB();
            return false;
        }
        for (int i = this.nbDimensions - 1; i >= 0; --i) {
            int r = (i + d) % this.nbDimensions;
            c[r] = j[r];
            int u = o.x[r].getUB();
            j[r] = u + 1;
            if (c[r] <= u) {
                return true;
            }
            c[r] = o.x[r].getLB();
        }
        c[d] = j[d];
        return false;
    }

    private boolean checkEnergy(int i) throws ContradictionException {
        long am = this.os[i].al;
        for (int d = 0; d < this.nbDimensions; ++d) {
            this.dl[d] = this.os[i].x[d].getLB();
            this.ur[d] = this.os[i].x[d].getUB() + this.os[i].l[d];
            this.ls[d] = this.os[i].l[d];
        }
        ISet neigh = this.overlapping.getNeighborsOf(i);
        for (int j : neigh.toArray()) {
            long ar = 1L;
            for (int d = 0; d < this.nbDimensions; ++d) {
                this.dl[d] = Math.min(this.dl[d], this.os[j].x[d].getLB());
                this.ur[d] = Math.max(this.ur[d], this.os[j].x[d].getUB() + this.os[j].l[d]);
                this.ls[d] = Math.min(this.ls[d], this.os[j].l[d]);
                ar *= (long)(this.ur[d] - this.dl[d]);
            }
            if ((am += this.os[j].al) <= ar) continue;
            this.fails();
        }
        if (Arrays.stream(this.ls).min().orElse(0) > 0) {
            double nbOr = 1.0;
            for (int d = 0; d < this.nbDimensions; ++d) {
                nbOr *= (double)(this.ur[d] - this.dl[d]) * 1.0 / (double)this.ls[d];
            }
            if (nbOr <= (double)neigh.size()) {
                this.fails();
            }
        }
        return this.os[i].area() < am;
    }

    private void checkArea() throws ContradictionException {
        for (int i = 0; i < this.os.length; ++i) {
            long area_i;
            int j;
            long limArea = this.os[i].area();
            ISet neigh = this.overlapping.getNeighborsOf(i);
            ISetIterator iter = neigh.iterator();
            for (area_i = this.os[i].al; iter.hasNext() && area_i <= limArea; area_i += this.computeArea(i, j)) {
                j = iter.nextInt();
            }
            if (area_i <= limArea) continue;
            this.fails();
        }
    }

    private long computeArea(int i, int j) {
        long aa;
        long area_ks = 1L;
        for (int d = 0; d < this.nbDimensions && area_ks > 0L; area_ks *= aa, ++d) {
            aa = this.computeAreaForDim(i, j, d);
        }
        return area_ks;
    }

    private long computeAreaForDim(int i, int j, int d) {
        int min_i = this.os[i].x[d].getLB();
        int max_i = this.os[i].x[d].getUB() + this.os[i].l[d];
        long ld = this.os[j].l[d];
        if (this.os[j].x[d].getLB() <= min_i) {
            if (this.os[j].x[d].getUB() + this.os[j].l[d] <= max_i) {
                int dist = this.os[j].x[d].getLB() + this.os[j].l[d] - min_i;
                ld = Math.max(dist, 0);
            } else {
                int d1 = this.os[j].x[d].getLB() + this.os[j].l[d] - min_i;
                int d2 = -this.os[j].x[d].getUB() + max_i;
                if ((d1 = Math.min(d1, max_i - min_i)) < (d2 = Math.min(d2, max_i - min_i))) {
                    ld = Math.max(d1, 0);
                } else if (d2 > 0) {
                    if (d2 < this.os[j].l[d]) {
                        ld = d2;
                    }
                } else {
                    ld = 0L;
                }
            }
        } else if (this.os[j].x[d].getUB() + this.os[j].l[d] > max_i) {
            int distance2 = -this.os[j].x[d].getUB() + this.os[i].x[d].getLB() + this.os[i].l[d];
            if (distance2 > 0) {
                if (distance2 < this.os[j].l[d]) {
                    ld = distance2;
                }
            } else {
                ld = 0L;
            }
        }
        return ld;
    }

    private static class Orthotope {
        final IntVar[] x;
        final int[] l;
        final long al;
        boolean modified = false;
        boolean skippable;

        public Orthotope(IntVar[] x, int[] l, boolean sk) {
            this.x = x;
            this.l = l;
            this.al = IntStream.of(l).reduce((i, j) -> i * j).orElse(0);
            this.skippable = sk;
        }

        public boolean isSkippable() {
            return this.skippable;
        }

        private int dsize(int d) {
            return this.x[d].getUB() - this.x[d].getLB() - this.l[d];
        }

        private void checkSkippable(int[] maxl) {
            this.skippable = true;
            for (int d = 0; d < this.x.length && this.skippable; ++d) {
                if (this.dsize(d) > maxl[d] - 2) continue;
                this.skippable = false;
            }
        }

        boolean assignedInAllDimensions() {
            int i;
            for (i = 0; i < this.x.length && this.x[i].isInstantiated(); ++i) {
            }
            return i == this.x.length;
        }

        boolean assignedInDimension(int k) {
            return this.x[k].isInstantiated();
        }

        boolean enumeratedOnDimension(int k) {
            return this.x[k].hasEnumeratedDomain();
        }

        long area() {
            long a = 1L;
            for (int i = 0; i < this.x.length; ++i) {
                a *= (long)(this.x[i].getUB() - this.x[i].getLB() + this.l[i]);
            }
            return a;
        }

        public boolean mayOverlap(Orthotope o2) {
            boolean overlap = true;
            for (int d = 0; d < this.x.length && overlap; ++d) {
                overlap = this.mayOverlap(o2, d);
            }
            return overlap;
        }

        public boolean mayOverlap(Orthotope o, int d) {
            return this.x[d].getLB() < o.x[d].getUB() + o.l[d] && o.x[d].getLB() < this.x[d].getUB() + this.l[d];
        }
    }

    private static class Forbidden {
        private final int[][] f;

        public Forbidden(int k) {
            this.f = new int[k][2];
        }

        public int min(int i) {
            return this.f[i][0];
        }

        public int max(int i) {
            return this.f[i][1];
        }

        public void set(int d, int fmin, int fmax) {
            this.f[d][0] = fmin;
            this.f[d][1] = fmax;
        }

        public String toString() {
            StringBuilder st = new StringBuilder("FR [");
            for (int d = 0; d < this.f.length; ++d) {
                st.append('(').append(this.f[d][0]).append(',').append(this.f[d][1]).append(')');
            }
            st.append("]");
            return st.toString();
        }
    }
}

