/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints;

import org.chocosolver.solver.ISelf;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Operator;
import org.chocosolver.solver.constraints.real.PropMixed;
import org.chocosolver.solver.constraints.real.PropMixedElement;
import org.chocosolver.solver.constraints.real.PropScalarMixed;
import org.chocosolver.solver.constraints.real.RealConstraint;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.Variable;

public interface IRealConstraintFactory
extends ISelf<Model> {
    default public RealConstraint realIbexGenericConstraint(String functions, double contractionRatio, Variable ... rvars) {
        return new RealConstraint(functions, contractionRatio, rvars);
    }

    default public RealConstraint realIbexGenericConstraint(String functions, Variable ... rvars) {
        return this.realIbexGenericConstraint(functions, ((Model)this.ref()).getSettings().getIbexContractionRatio(), rvars);
    }

    default public RealConstraint ibex(String functions, Variable ... rvars) {
        return this.realIbexGenericConstraint(functions, rvars);
    }

    default public Constraint scalar(Variable[] vars, double[] coeffs, String op, double bound) {
        return new Constraint("MIXEDSCALAR", new PropScalarMixed(vars, coeffs, Operator.get(op), bound));
    }

    default public Constraint eq(RealVar x, IntVar y) {
        return new Constraint("ARITHM", new PropMixed(x, y));
    }

    default public Constraint element(RealVar value, double[] table, IntVar index) {
        for (int i = 0; i < table.length - 2; ++i) {
            if (!(table[i] >= table[i + 1])) continue;
            throw new SolverException("element requires 'table' to be strictly ordered.");
        }
        return new Constraint("ELEMENT", new PropMixedElement(value, index, table));
    }
}

