/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r.Fares;

import com.conveyal.r5.transit.RouteInfo;
import com.conveyal.r5.transit.TransitLayer;
import com.conveyal.r5.transit.TransportNetwork;
import java.lang.invoke.CallSite;
import java.util.HashSet;
import java.util.List;
import org.ipea.r5r.Fares.FarePerRoute;
import org.ipea.r5r.Fares.FarePerTransfer;
import org.ipea.r5r.Fares.FarePerType;
import org.ipea.r5r.Fares.FareStructure;

public class FareStructureBuilder {
    private final TransportNetwork transportNetwork;
    private FareStructure fareStructure;

    public FareStructure getFareStructure() {
        return this.fareStructure;
    }

    public FareStructureBuilder(TransportNetwork transportNetwork) {
        this.transportNetwork = transportNetwork;
    }

    public FareStructure build(float baseFare, String routeType) {
        this.fareStructure = new FareStructure();
        this.populateFareStructure(routeType, baseFare);
        return this.fareStructure;
    }

    private void populateFareStructure(String type, float fare) {
        HashSet<String> modes = new HashSet<String>();
        HashSet<CallSite> transfers = new HashSet<CallSite>();
        List<FarePerRoute> routes = this.fareStructure.getFaresPerRoute();
        for (RouteInfo routeInfo : this.transportNetwork.transitLayer.routes) {
            FarePerRoute newRoute = new FarePerRoute();
            newRoute.setAgencyId(routeInfo.agency_id);
            newRoute.setAgencyName(routeInfo.agency_name);
            newRoute.setRouteId(routeInfo.route_id);
            newRoute.setRouteShortName(routeInfo.route_short_name);
            newRoute.setRouteLongName(routeInfo.route_long_name);
            newRoute.setMode(TransitLayer.getTransitModes((int)routeInfo.route_type).toString());
            newRoute.setRouteFare(fare);
            switch (type) {
                case "MODE": {
                    newRoute.setFareType(TransitLayer.getTransitModes((int)routeInfo.route_type).toString());
                    modes.add(TransitLayer.getTransitModes((int)routeInfo.route_type).toString());
                    break;
                }
                case "AGENCY": 
                case "AGENCY_ID": {
                    newRoute.setFareType(routeInfo.agency_id);
                    modes.add(routeInfo.agency_id);
                    break;
                }
                case "AGENCY_NAME": {
                    newRoute.setFareType(routeInfo.agency_name);
                    modes.add(routeInfo.agency_name);
                    break;
                }
                default: {
                    newRoute.setFareType("GENERIC");
                    modes.add("GENERIC");
                }
            }
            routes.add(newRoute);
        }
        for (String string : modes) {
            for (String string2 : modes) {
                String legs = string + "&" + string2;
                transfers.add((CallSite)((Object)legs));
            }
        }
        List<FarePerType> faresPerMode = this.fareStructure.getFaresPerType();
        for (String mode : modes) {
            FarePerType farePerType = new FarePerType();
            farePerType.setType(mode);
            farePerType.setFare(fare);
            faresPerMode.add(farePerType);
        }
        List<FarePerTransfer> list = this.fareStructure.getFaresPerTransfer();
        for (String string : transfers) {
            String[] legs = string.split("&");
            FarePerTransfer newTransfer = new FarePerTransfer();
            newTransfer.setFirstLeg(legs[0]);
            newTransfer.setSecondLeg(legs[1]);
            newTransfer.setFare(fare);
            list.add(newTransfer);
        }
    }
}

