## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(comment = '.', warning = FALSE, message = FALSE)

## -----------------------------------------------------------------------------
library(mrgsim.parallel)
library(dplyr)

## -----------------------------------------------------------------------------
data <- expand.ev(amt = c(100, 200, 300), ID = seq(100))
count(data, amt)

## -----------------------------------------------------------------------------
mod <- house(end = 72)

## -----------------------------------------------------------------------------
outx <- mrgsim_d(mod, data, output = "df")

## ----eval = FALSE-------------------------------------------------------------
# future::plan(future::multisession, workers = 2L)

## -----------------------------------------------------------------------------
out <- fu_mrgsim_d(mod, data, .seed = 123, nchunk = 6)

## ----include = FALSE----------------------------------------------------------
future::plan(future::sequential)

## ----eval = FALSE-------------------------------------------------------------
# out <- mc_mrgsim_d(mod, data, mc.cores = 2, .seed = 123,  nchunk = 6)

## ----eval = FALSE, warning = FALSE--------------------------------------------
# future::plan(future::multicore)
# out <- fu_mrgsim_d(mod, data, .seed = 123, nchunk = 6)

## -----------------------------------------------------------------------------
e <- ev(amt = 100, ii = 24, addl = 27)

## -----------------------------------------------------------------------------
idata <- data.frame(WT = runif(25, 40, 140))
head(idata)

## -----------------------------------------------------------------------------
out <- mrgsim_ei(mod, e, idata)

## ----eval = FALSE-------------------------------------------------------------
# future::plan(future::multisession, workers = 2L)
# 
# out <- fu_mrgsim_ei(mod, e, idata,.seed = 123, nchunks = 6)

## ----eval = FALSE-------------------------------------------------------------
# out <- mc_mrgsim_ei(mod, e, idata, .seed = 123, nchunks = 6, mc.cores = 2)

## -----------------------------------------------------------------------------
out <- bg_mrgsim_d(mod, data, nchunk = 2)

## -----------------------------------------------------------------------------
out

## -----------------------------------------------------------------------------
sims <- out$get_result()

## -----------------------------------------------------------------------------
length(sims)
head(sims[[1]])

## -----------------------------------------------------------------------------
locker <- file.path(tempdir(), "foo")

out <- bg_mrgsim_d(mod, data, .locker = locker, nchunk = 4)

## -----------------------------------------------------------------------------
files <- out$get_result()
files

## -----------------------------------------------------------------------------
library(fst)
sims <- lapply(files, read_fst)
head(sims[[2]])

## -----------------------------------------------------------------------------
sims <- internalize_fst(locker)

head(sims)

## -----------------------------------------------------------------------------
out <- bg_mrgsim_d(
  mod, 
  data, 
  nchunk = 4,
  .plan = "multisession", 
  .locker = locker, 
  .cores = 2
)
sims <- internalize_fst(locker)

## -----------------------------------------------------------------------------
data <- data.frame(i = seq(10))

data_list <- chunk_by_row(data, nchunk = 2)

## -----------------------------------------------------------------------------
length(data_list)
data_list[[2]]

## -----------------------------------------------------------------------------
set.seed(8789)

data <- data.frame(id = c(rep("a", 4), rep("b", 3), rep("c", 2), rep("d", 5)))

data

data_list <- chunk_by_id(data, id_col = "id", nchunk = 2)

data_list[[2]]

