## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "",
  eval = TRUE
)

## ----eval = FALSE-------------------------------------------------------------
#  install.packages("calms",dependencies=TRUE)

## ----eval = FALSE-------------------------------------------------------------
#  calms::run_calms()

## ----eval = FALSE-------------------------------------------------------------
#  ###Load necessary packages
#  library(foreign)
#  library(haven)
#  
#  ### Read in data set without labels
#  dso <-
#    read.spss("ZA6770_v2-1-0.sav",
#    use.value.labels=FALSE, max.value.labels=Inf, to.data.frame=TRUE)
#  nrow(dso)
#  names(dso)
#  
#  ### Read in data set with labels
#  dsoa <-
#    read.spss("ZA6770_v2-1-0.sav",
#    use.value.labels=TRUE, max.value.labels=Inf, to.data.frame=TRUE)
#  nrow(dsoa)
#  names(dsoa)
#  
#  ### Select only needed columns
#  #quality of job content (JC: v22-v24) and quality of work environment (WE: v25-v27)
#  #demographics:SEX,EMPREL,TYPORG2,DEGREE
#  ds<-subset(dso,select=c(country,v22:v27,SEX,DEGREE,EMPREL,TYPORG2))
#  names(ds)
#  
#  ds[,c("country","SEX","DEGREE","EMPREL","TYPORG2")]<-dsoa[,c("country","SEX","DEGREE","EMPREL","TYPORG2")]
#  
#  ###Get data for the groups (i.e., countries)
#  #country numerical codes in SPSS: UK = 826, US = 840
#  table(ds$country)
#  ds<-subset(ds,(country=="GB-Great Britain and/or United Kingdom" | country=="US-United States"))
#  ds$country<-factor(ds$country)
#  table(ds$country)
#  nrow(ds)
#  
#  ###getting rid of missing values
#  nrow(ds)
#  ds<-na.omit(ds)
#  nrow(ds)
#  
#  ###check values
#  table(ds$SEX)
#  table(ds$DEGREE)
#  table(ds$EMPREL)
#  table(ds$TYPORG2)
#  table(ds$country)
#  
#  levels(ds$EMPREL)<-c("Employee","Self-employed","Self-employed",NA)
#  levels (ds$DEGREE)<-c(rep("no univ",5),rep("univ",2))
#  
#  ###getting rid of missing values
#  nrow(ds)
#  ds<-na.omit(ds)
#  nrow(ds)
#  
#  ds$SEX
#  levels(ds$SEX)
#  levels(ds$SEX)<-c(1,0)     #Set "Male" to 1
#  
#  levels(ds$EMPREL)
#  levels(ds$EMPREL)<-c(0,1)  #Set "Employee" to 1
#  
#  levels(ds$TYPORG2)
#  levels(ds$TYPORG2)<-c(0,1) #Set "Private employer" to 1
#  
#  levels(ds$DEGREE)
#  levels(ds$DEGREE)<-c(0,1)  #Set "univ" to 1
#  
#  levels(ds$country)
#  levels(ds$country)<-c(1,0) #Set "US-United States" to 1
#  
#  ds$SEX<-as.numeric(ds$SEX)-1
#  ds$EMPREL<-as.numeric(ds$EMPREL)-1
#  ds$TYPORG2<-as.numeric(ds$TYPORG2)-1
#  ds$DEGREE<-as.numeric(ds$DEGREE)-1
#  ds$country<-as.numeric(ds$country)-1
#  
#  nrow(ds)
#  names(ds)
#  
#  write_sav(ds,"WosDemo.sav")

## ----results="markup",echo=FALSE----------------------------------------------
library(calms)
data("WosDemoMeta")
WosDemoMeta

