## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(collapse = TRUE, comment = "#>")

## ----message=FALSE, echo=F, warning=F-----------------------------------------
# Load SemanticDistance
library(SemanticDistance)

## ----echo=F-------------------------------------------------------------------
knitr::kable(head(Monologue_Typical, 1), format = "pipe")

## ----echo=F-------------------------------------------------------------------
knitr::kable(head(Unordered_List, 1), format = "pipe")

## ----message=FALSE------------------------------------------------------------
Monologue_Cleaned <- clean_monologue_or_list(dat=Monologue_Typical, wordcol='mytext', omit_stops=TRUE, lemmatize=TRUE)
knitr::kable(head(Monologue_Cleaned, 12), format = "pipe", digits=2)

## ----message=FALSE------------------------------------------------------------
Ngram2Word_Dists1 <- dist_ngram2word(dat=Monologue_Cleaned, ngram=1) #distance word-to-word
head(Ngram2Word_Dists1)

## ----message=FALSE------------------------------------------------------------
Ngram2Ngram_Dist1 <- dist_ngram2ngram(dat=Monologue_Cleaned, ngram=2)
head(Ngram2Ngram_Dist1)

## ----message=FALSE------------------------------------------------------------
Anchored_Dists1 <- dist_anchor(dat=Monologue_Cleaned, anchor_size=4)
head(Anchored_Dists1)

