/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.ifx.qhts.curvefitting.algorithm;

import gov.nih.ncats.ifx.qhts.curvefitting.algorithm.AlgotithmUtils;
import gov.nih.ncats.ifx.qhts.curvefitting.algorithm.Masking;
import gov.nih.ncats.ifx.qhts.utils.HillConstants;
import gov.nih.ncats.ifx.qhts.utils.HillStat;
import java.util.ArrayList;
import java.util.HashMap;

public class HillFit {
    public static double LN10 = Math.log(10.0);
    protected static boolean[] maskings_ = null;
    private static boolean fastFlag = false;
    private static boolean slopeFlag = true;
    private static boolean p4Fit = true;

    public static void setFastFlag(boolean flag) {
        fastFlag = flag;
    }

    public static void setSlopeFlag(boolean flag) {
        slopeFlag = flag;
    }

    public static Object[] doHill(double[] x, double[] y) throws Exception {
        return HillFit.doHill(x, y, null, HillConstants.PARTIAL_FIT_MASK_NO, null, 1, HillConstants.CLASSIFICATION_SD, HillConstants.CLASSIFICATION_SD_FACTOR);
    }

    public static Object[] doHill(double[] x, double[] y, boolean flag) throws Exception {
        p4Fit = flag;
        return HillFit.doHill(x, y);
    }

    public static Object[] doHill(double[] x, double[] y, String maskFlag, int iterNo, String fixPara) throws Exception {
        return HillFit.doHill(x, y, maskFlag, iterNo, fixPara, 1, HillConstants.CLASSIFICATION_SD, HillConstants.CLASSIFICATION_SD_FACTOR);
    }

    public static Object[] doHill(double[] conc, double[] y, String maskFlag, int iterNo, String fixPara, int dn, double sd, double sdf) throws Exception {
        int i;
        int i2;
        int numPoints = conc.length;
        if (numPoints < 3) {
            throw new Exception("Concentratrion points should be equl or greater than 3");
        }
        double bestR2 = 0.0;
        HashMap[] bestMaps = null;
        double[] bestFitValues = null;
        boolean[] bestFlags = null;
        double bestDelta = 0.0;
        int bestIterNo = 0;
        boolean[] maskFlags = AlgotithmUtils.parseMaskFlag(maskFlag);
        if (maskFlags != null || !HillConstants.MASK_FLAG) {
            iterNo = 1;
        }
        for (int i3 = 0; i3 < iterNo; ++i3) {
            double[] xs = new double[numPoints - i3];
            double[] ys = new double[xs.length];
            for (int j = 0; j < xs.length; ++j) {
                xs[j] = conc[j];
                ys[j] = y[j];
            }
            double ys0 = ys[0];
            if (HillConstants.SHIFT_ACTIVITY) {
                int j = 0;
                while (j < xs.length) {
                    int n = j++;
                    ys[n] = ys[n] - ys0;
                }
            }
            HashMap[] maps = new HashMap[xs.length];
            boolean noChangeFlag = false;
            boolean[] flags = null;
            if (maskFlags != null) {
                flags = maskFlags;
                noChangeFlag = true;
            } else {
                flags = Masking.maskDif(xs, ys, null, null, maps, dn, sd, sdf);
            }
            if (xs.length < 3) break;
            if (HillConstants.BELL_MASK) {
                noChangeFlag = true;
            }
            double[] fitValues = null;
            fitValues = HillConstants.FIT_TYPE.equals("P5") ? HillFit.hillFit5P(HillConstants.PI_MAX, HillConstants.PS_MIN, flags, null, xs, ys, noChangeFlag, fixPara) : HillFit.hillFit(HillConstants.PI_MAX, HillConstants.PS_MIN, flags, null, xs, ys, noChangeFlag, fixPara);
            if (fitValues == null && bestFlags == null) {
                bestFlags = flags;
            }
            if (fitValues == null) continue;
            if (HillConstants.SHIFT_ACTIVITY) {
                fitValues[1] = fitValues[1] + ys0;
                fitValues[6] = fitValues[6] + ys0;
            }
            double r2 = fitValues[3];
            double delta = Math.abs(fitValues[1] - fitValues[6]);
            if (!(r2 * (double)xs.length > bestR2) || !(delta > bestDelta)) break;
            bestR2 = r2 * (double)xs.length;
            bestFitValues = fitValues;
            bestFlags = flags;
            bestMaps = maps;
            bestDelta = delta;
            bestIterNo = i3;
        }
        if (bestFitValues == null) {
            Object[] values = new Object[]{bestFlags, bestFitValues, bestMaps, String.valueOf(bestIterNo)};
            return values;
        }
        boolean[] flags = new boolean[numPoints];
        for (i2 = 0; i2 < bestFlags.length; ++i2) {
            flags[i2] = bestFlags[i2];
        }
        for (i2 = bestFlags.length; i2 < numPoints; ++i2) {
            flags[i2] = false;
        }
        HashMap[] maps = new HashMap[numPoints];
        for (i = 0; i < bestFlags.length; ++i) {
            maps[i] = bestMaps[i];
        }
        for (i = bestFlags.length; i < numPoints; ++i) {
            maps[i] = null;
        }
        Object[] values = new Object[]{flags, bestFitValues, maps, String.valueOf(bestIterNo)};
        return values;
    }

    public static double[] hillFit5p(double ymin, double ymax, boolean[] flags, double[] ws, double[] xs, double[] ys, String fixPara, boolean upFlag) {
        if (!AlgotithmUtils.checkRange(ymin, ymax, flags, ys)) {
            return null;
        }
        double xl = -10.0;
        if (xs[0] * 1.2 < xl) {
            xl = xs[0] * 1.2;
        }
        double xr = -2.0;
        double xd = 0.5;
        double y0l = -150.0;
        double y0r = 150.0;
        double y0d = 5.0;
        double yl = -150.0;
        double yr = 150.0;
        double yd = 5.0;
        double sl = HillConstants.MIN_SLOPE;
        double sr = HillConstants.MAX_SLOPE;
        double sd = 0.2;
        double ml = 0.1;
        double mr = 10.0;
        double md = 1.0;
        double max_y = -1.7976931348623157E308;
        double min_y = Double.MAX_VALUE;
        for (int i = 0; i < ys.length; ++i) {
            if (!flags[i]) continue;
            if (ys[i] > max_y) {
                max_y = ys[i];
            }
            if (!(ys[i] < min_y)) continue;
            min_y = ys[i];
        }
        if (upFlag) {
            if (min_y < 0.0) {
                y0l = HillConstants.Y0_INF_COEF * min_y;
                y0r = 0.0;
            } else {
                y0l = 0.0;
                y0r = HillConstants.Y0_INF_COEF * min_y;
            }
            if (max_y > 0.0) {
                yl = 0.0;
                yr = HillConstants.Y0_INF_COEF * max_y;
            } else {
                yr = 0.0;
                yl = HillConstants.Y0_INF_COEF * max_y;
            }
            sl = HillConstants.MIN_SLOPE;
            sr = HillConstants.MAX_SLOPE;
        } else {
            if (max_y < 0.0) {
                y0l = HillConstants.Y0_INF_COEF * max_y;
                y0r = 0.0;
            } else {
                y0l = 0.0;
                y0r = HillConstants.Y0_INF_COEF * max_y;
            }
            if (min_y < 0.0) {
                yl = HillConstants.Y0_INF_COEF * min_y;
                yr = 0.0;
            } else {
                yr = HillConstants.Y0_INF_COEF * min_y;
                yl = 0.0;
            }
            sl = HillConstants.MIN_SLOPE;
            sr = HillConstants.MAX_SLOPE;
        }
        double delta_y = 0.05 * (max_y - min_y);
        y0d = 0.05 * (y0r - y0l);
        y0d = y0d < 2.0 ? 2.0 : y0d;
        y0d = y0d < delta_y ? delta_y : y0d;
        yd = 0.05 * (yr - yl);
        yd = yd < 2.0 ? 2.0 : yd;
        double d = yd = yd < delta_y ? delta_y : yd;
        if (delta_y < 1.0 && y0d > 1.0) {
            y0d = 1.0;
        }
        if (delta_y < 1.0 && yd > 1.0) {
            yd = 1.0;
        }
        double[] fitValues = null;
        fitValues = HillFit.hillFit(y0l, y0r, y0d, yl, yr, yd, xl, xr, xd, sl, sr, sd, flags, ws, xs, ys, fixPara);
        if (fitValues == null) {
            return null;
        }
        xl = fitValues[0] - 1.0;
        xr = fitValues[0] + 1.0;
        xd = HillConstants.EC50_GRID_SIZE;
        y0l = fitValues[6] - 2.0 * y0d;
        y0r = fitValues[6] + 2.0 * y0d;
        yl = fitValues[1] - 2.0 * yd;
        yr = fitValues[1] + 2.0 * yd;
        y0d = (y0d = 0.2 * y0d) < 1.0 ? 1.0 : y0d;
        yd = 0.2 * yd;
        yd = yd < 1.0 ? 1.0 : yd;
        sl = fitValues[2] - 0.5 < 0.1 ? 0.1 : fitValues[2] - 0.4;
        sr = fitValues[2] + 0.4;
        sd = 0.2;
        ml = 0.4;
        mr = 2.0;
        md = 0.2;
        fitValues = HillFit.hillFit5p(y0l, y0r, y0d, yl, yr, yd, xl, xr, xd, sl, sr, sd, ml, mr, md, flags, ws, xs, ys, fixPara);
        return fitValues;
    }

    public static double[] hillFitFast5P(double ymin, double ymax, boolean[] flags, double[] ws, double[] xs, double[] ys, String fixPara, boolean upFlag) {
        if (!AlgotithmUtils.checkRange(ymin, ymax, flags, ys)) {
            return null;
        }
        double xl = -10.0;
        if (xs[0] * 1.2 < xl) {
            xl = xs[0] * 1.2;
        }
        double xr = -2.0;
        double xd = 0.5;
        double y0l = -150.0;
        double y0r = 150.0;
        double y0d = 5.0;
        double yl = -150.0;
        double yr = 150.0;
        double yd = 5.0;
        double sl = HillConstants.MIN_SLOPE;
        double sr = HillConstants.MAX_SLOPE;
        double sd = 0.2;
        double ml = 0.1;
        double mr = 10.0;
        double md = 1.0;
        double max_y = -1.7976931348623157E308;
        double min_y = Double.MAX_VALUE;
        for (int i = 0; i < ys.length; ++i) {
            if (!flags[i]) continue;
            if (ys[i] > max_y) {
                max_y = ys[i];
            }
            if (!(ys[i] < min_y)) continue;
            min_y = ys[i];
        }
        if (upFlag) {
            if (min_y < 0.0) {
                y0l = HillConstants.Y0_INF_COEF * min_y;
                y0r = 0.0;
            } else {
                y0l = 0.0;
                y0r = HillConstants.Y0_INF_COEF * min_y;
            }
            if (max_y > 0.0) {
                yl = 0.0;
                yr = HillConstants.Y0_INF_COEF * max_y;
            } else {
                yr = 0.0;
                yl = HillConstants.Y0_INF_COEF * max_y;
            }
            sl = HillConstants.MIN_SLOPE;
            sr = HillConstants.MAX_SLOPE;
        } else {
            if (max_y < 0.0) {
                y0l = HillConstants.Y0_INF_COEF * max_y;
                y0r = 0.0;
            } else {
                y0l = 0.0;
                y0r = HillConstants.Y0_INF_COEF * max_y;
            }
            if (min_y < 0.0) {
                yl = HillConstants.Y0_INF_COEF * min_y;
                yr = 0.0;
            } else {
                yr = HillConstants.Y0_INF_COEF * min_y;
                yl = 0.0;
            }
            sl = HillConstants.MIN_SLOPE;
            sr = HillConstants.MAX_SLOPE;
        }
        double delta_y = 0.05 * (max_y - min_y);
        y0d = 0.05 * (y0r - y0l);
        y0d = y0d < 2.0 ? 2.0 : y0d;
        y0d = y0d < delta_y ? delta_y : y0d;
        yd = 0.05 * (yr - yl);
        yd = yd < 2.0 ? 2.0 : yd;
        double d = yd = yd < delta_y ? delta_y : yd;
        if (delta_y < 1.0 && y0d > 1.0) {
            y0d = 1.0;
        }
        if (delta_y < 1.0 && yd > 1.0) {
            yd = 1.0;
        }
        double[] fitValues = null;
        fitValues = HillFit.hillFit(y0l, y0r, y0d, yl, yr, yd, xl, xr, xd, sl, sr, sd, flags, ws, xs, ys, fixPara);
        if (fitValues == null) {
            return null;
        }
        xl = fitValues[0] - 1.0;
        xr = fitValues[0] + 1.0;
        xd = HillConstants.EC50_GRID_SIZE;
        y0l = fitValues[6] - 2.0 * y0d;
        y0r = fitValues[6] + 2.0 * y0d;
        yl = fitValues[1] - 2.0 * yd;
        yr = fitValues[1] + 2.0 * yd;
        y0d = (y0d = 0.2 * y0d) < 1.0 ? 1.0 : y0d;
        yd = 0.2 * yd;
        yd = yd < 1.0 ? 1.0 : yd;
        sl = fitValues[2] - 0.5 < 0.1 ? 0.1 : fitValues[2] - 0.4;
        sr = fitValues[2] + 0.4;
        sd = 0.2;
        ml = 0.4;
        mr = 2.0;
        md = 0.2;
        fitValues = HillFit.hillFit5p(y0l, y0r, y0d, yl, yr, yd, xl, xr, xd, sl, sr, sd, ml, mr, md, flags, ws, xs, ys, fixPara);
        return fitValues;
    }

    public static double[] hillFit5p(double y0l, double y0r, double y0d, double yl, double yr, double yd, double xl, double xr, double xd, double sl, double sr, double sd, double ml, double mr, double md, boolean[] flags, double[] ws, double[] xs, double[] ys, String fixPara) {
        double y0_min = 0.0;
        double yinf_min = 0.0;
        double slope_min = 0.0;
        double x05_min = 0.0;
        double dev_min = 1.0E8;
        double sym_min = 1.0;
        double delta = sd;
        int no = 0;
        for (double y0 = y0l; y0 <= y0r; y0 += y0d) {
            for (double yinf = yl; yinf <= yr; yinf += yd) {
                for (double x05 = xl; x05 <= xr; x05 += xd) {
                    for (double slope = sl; slope <= sr; slope += delta) {
                        if (Math.abs(slope) < HillConstants.MIN_SLOPE) continue;
                        if (slope > 5.0) {
                            delta = 5.0;
                        }
                        for (double sym = ml; sym <= mr; sym += md) {
                            double dev = AlgotithmUtils.calcHillDeviation(x05, y0, yinf, slope, sym, flags, ws, xs, ys);
                            if (dev < dev_min) {
                                dev_min = dev;
                                slope_min = slope;
                                x05_min = x05;
                                yinf_min = yinf;
                                sym_min = sym;
                                y0_min = y0;
                            }
                            if ((delta = Math.abs(slope) * 0.1) < 0.1) {
                                delta = 0.1;
                            }
                            ++no;
                        }
                    }
                }
            }
        }
        double dev_const = AlgotithmUtils.calcConstantDeviation(flags, ws, xs, ys);
        double r2 = 0.0;
        if (HillConstants.CURVE_CLASS5) {
            double dev0 = (double)xs.length * HillConstants.CLASSIFICATION_SD * HillConstants.CLASSIFICATION_SD;
            r2 = 1.0 - dev_const / dev0;
        } else {
            r2 = 1.0 - dev_min / (1.0 + dev_const);
        }
        if (r2 < HillConstants.R2) {
            return null;
        }
        double pvalue = HillStat.calcPValue(y0_min, yinf_min, x05_min, slope_min, sym_min, xs, ys, flags);
        double[] values = new double[]{x05_min, yinf_min, slope_min, r2, dev_const, dev_min, y0_min, sym_min, pvalue};
        return values;
    }

    public static double[] hillFit(double ymin, double ymax, boolean[] flags, double[] ws, double[] xs, double[] ys) {
        return HillFit.hillFit(ymin, ymax, flags, ws, xs, ys, false, null);
    }

    public static double[] hillFit(double ymin, double ymax, boolean[] flags, double[] ws, double[] xs, double[] ys, boolean flag2, String fixPara) {
        int i;
        double[] values = HillFit.hillFitFast_1(ymin, ymax, flags, ws, xs, ys, fixPara);
        if (values == null) {
            return null;
        }
        double max = -1.7976931348623157E308;
        double min = Double.MAX_VALUE;
        for (int i2 = 0; i2 < xs.length; ++i2) {
            max = Math.max(max, ys[i2]);
            min = Math.min(min, ys[i2]);
        }
        double range = max - min;
        if (range < 100.0) {
            range = 100.0;
        }
        double y0 = values[6];
        double x05 = values[0];
        double yinf = values[1];
        double slope = values[2];
        if (flag2) {
            return values;
        }
        double[] yfit = AlgotithmUtils.calcHillFitCurve(x05, y0, yinf, slope, xs);
        boolean flag = false;
        int maskNo = 0;
        for (int i3 = 1; i3 < ys.length; ++i3) {
            if (!flags[i3] && Math.abs(ys[i3] - yfit[i3]) * 100.0 / range < HillConstants.TPV) {
                flag = true;
                flags[i3] = true;
            }
            if (flags[i3]) continue;
            ++maskNo;
        }
        ArrayList<String> list = new ArrayList<String>();
        if (maskNo < xs.length / HillConstants.MASK) {
            for (i = 0; i < ys.length - 1; ++i) {
                if (i > 0 && flags[i] && Math.abs(ys[i] - yfit[i]) * 100.0 / range > HillConstants.TPV) {
                    list.add(String.valueOf(i));
                    continue;
                }
                if (i != 0 || !flags[i] || !(Math.abs(ys[i] - yfit[i]) * 100.0 / range > HillConstants.TP0)) continue;
                list.add(String.valueOf(i));
            }
        }
        if (list.size() > 0 && HillConstants.MASK_FLAG) {
            flag = true;
            for (i = maskNo; i < xs.length / HillConstants.MASK && i - maskNo < list.size(); ++i) {
                int k = Integer.parseInt((String)list.get(i - maskNo));
                flags[k] = false;
            }
        }
        if (flag) {
            return HillFit.hillFitFast_1(ymin, ymax, flags, ws, xs, ys, fixPara);
        }
        return values;
    }

    public static double[] hillFit5P(double ymin, double ymax, boolean[] flags, double[] ws, double[] xs, double[] ys, boolean flag2, String fixPara) {
        int i;
        double[] values = HillFit.hillFitFast_1(ymin, ymax, flags, ws, xs, ys, fixPara);
        if (values == null) {
            return null;
        }
        double max = -1.7976931348623157E308;
        double min = Double.MAX_VALUE;
        for (int i2 = 0; i2 < xs.length; ++i2) {
            max = Math.max(max, ys[i2]);
            min = Math.min(min, ys[i2]);
        }
        double range = max - min;
        if (range < 100.0) {
            range = 100.0;
        }
        double y0 = values[6];
        double x05 = values[0];
        double yinf = values[1];
        double slope = values[2];
        double sym = values[7];
        if (flag2) {
            return values;
        }
        double[] yfit = AlgotithmUtils.calcHillFitCurve(x05, y0, yinf, slope, sym, xs);
        boolean flag = false;
        int maskNo = 0;
        for (int i3 = 1; i3 < ys.length; ++i3) {
            if (!flags[i3] && Math.abs(ys[i3] - yfit[i3]) * 100.0 / range < HillConstants.TPV) {
                flag = true;
                flags[i3] = true;
            }
            if (flags[i3]) continue;
            ++maskNo;
        }
        ArrayList<String> list = new ArrayList<String>();
        if (maskNo < xs.length / HillConstants.MASK) {
            for (i = 0; i < ys.length - 1; ++i) {
                if (i > 0 && flags[i] && Math.abs(ys[i] - yfit[i]) * 100.0 / range > HillConstants.TPV) {
                    list.add(String.valueOf(i));
                    continue;
                }
                if (i != 0 || !flags[i] || !(Math.abs(ys[i] - yfit[i]) * 100.0 / range > HillConstants.TP0)) continue;
                list.add(String.valueOf(i));
            }
        }
        if (list.size() > 0) {
            flag = true;
            for (i = maskNo; i < xs.length / HillConstants.MASK && i - maskNo < list.size(); ++i) {
                int k = Integer.parseInt((String)list.get(i - maskNo));
                flags[k] = false;
            }
        }
        return values;
    }

    public static double[] hillFit(double y0l, double y0r, double y0d, double yl, double yr, double yd, double xl, double xr, double xd, double sl, double sr, double sd, boolean[] flags, double[] ws, double[] xs, double[] ys, String fixPara) {
        double td;
        double[] ds;
        if (fastFlag) {
            return HillFit.hillFitFast_0(y0l, y0r, y0d, yl, yr, yd, xl, xr, xd, sl, sr, sd, flags, ws, xs, ys, fixPara);
        }
        double y0_min = 0.0;
        double yinf_min = 0.0;
        double slope_min = 0.0;
        double x05_min = 0.0;
        double dev_min = Double.MAX_VALUE;
        double delta = sd;
        int no = 0;
        if (fixPara != null) {
            double[] paras;
            if (fixPara.indexOf("y0") >= 0) {
                paras = AlgotithmUtils.parseFixPara(fixPara, "y0");
                y0l = paras[0];
                y0r = paras[1];
            }
            if (fixPara.indexOf("yinf") >= 0) {
                paras = AlgotithmUtils.parseFixPara(fixPara, "yinf");
                yl = paras[0];
                yr = paras[1];
            }
            if (fixPara.indexOf("slope") >= 0) {
                paras = AlgotithmUtils.parseFixPara(fixPara, "slope");
                sl = paras[0];
                sr = paras[1];
            }
            if (fixPara.indexOf("log_ac50") >= 0) {
                paras = AlgotithmUtils.parseFixPara(fixPara, "log_ac50");
                xl = paras[0];
                xr = paras[1];
            }
        }
        if (HillConstants.FIXED_AC50 != null && HillConstants.FIXED_AC50.length() > 0) {
            ds = AlgotithmUtils.parseConstraintPara(HillConstants.FIXED_AC50);
            xl = ds[0];
            xr = ds[1];
        }
        if (HillConstants.FIXED_Y0 != null && HillConstants.FIXED_Y0.length() > 0) {
            ds = AlgotithmUtils.parseConstraintPara(HillConstants.FIXED_Y0);
            y0l = ds[0];
            y0r = ds[1];
        }
        if (HillConstants.FIXED_YINF != null && HillConstants.FIXED_YINF.length() > 0) {
            ds = AlgotithmUtils.parseConstraintPara(HillConstants.FIXED_YINF);
            yl = ds[0];
            yr = ds[1];
        }
        if (HillConstants.FIXED_SLOPE != null && HillConstants.FIXED_SLOPE.length() > 0) {
            ds = AlgotithmUtils.parseConstraintPara(HillConstants.FIXED_SLOPE);
            sl = ds[0];
            sr = ds[1];
        }
        if (HillConstants.MIN_YINF != null && yl < (td = Double.parseDouble(HillConstants.MIN_YINF))) {
            yl = td;
        }
        if (HillConstants.MAX_YINF != null && yr > (td = Double.parseDouble(HillConstants.MAX_YINF))) {
            yr = td;
        }
        if (HillConstants.YINF_MORE_80) {
            if (yr > 0.0) {
                yl = 80.0;
                if (yr < 100.0) {
                    yr = 100.0;
                }
            } else {
                if (yl > -100.0) {
                    yl = -100.0;
                }
                yr = -80.0;
            }
        }
        for (double y0 = y0l; y0 <= y0r; y0 += y0d) {
            for (double yinf = yl; yinf <= yr; yinf += yd) {
                if (HillConstants.Y0_LESS_THAN_YINF && Math.abs(y0) >= Math.abs(yinf)) continue;
                for (double x05 = xl; x05 <= xr; x05 += xd) {
                    for (double slope = sl; slope <= sr; slope += delta) {
                        double dev;
                        if (Math.abs(slope) < HillConstants.MIN_SLOPE) continue;
                        if (slope > 5.0) {
                            delta = 5.0;
                        }
                        if ((dev = AlgotithmUtils.calcHillDeviation(x05, y0, yinf, slope, flags, ws, xs, ys)) < dev_min) {
                            dev_min = dev;
                            slope_min = slope;
                            x05_min = x05;
                            yinf_min = yinf;
                            y0_min = y0;
                        }
                        if ((delta = Math.abs(slope) * 0.1) < 0.1) {
                            delta = 0.1;
                        }
                        ++no;
                    }
                }
            }
        }
        double dev_const = AlgotithmUtils.calcConstantDeviation(flags, ws, xs, ys);
        double r2 = 0.0;
        if (HillConstants.CURVE_CLASS5) {
            double dev0 = (double)(9 * xs.length) * HillConstants.CLASSIFICATION_SD * HillConstants.CLASSIFICATION_SD;
            r2 = 1.0 - dev_min / dev0;
        } else {
            r2 = 1.0 - dev_min / (1.0 + dev_const);
        }
        if (r2 < HillConstants.R2) {
            return null;
        }
        double[] values = new double[]{x05_min, yinf_min, slope_min, r2, dev_const, dev_min, y0_min};
        return values;
    }

    public static double[] hillFitFast_0(double y0l, double y0r, double y0d, double yl, double yr, double yd, double xl, double xr, double xd, double sl, double sr, double sd, boolean[] flags, double[] ws, double[] xs, double[] ys, String fixPara) {
        double[] ds;
        double y0_min = 0.0;
        double yinf_min = 0.0;
        double slope_min = 0.0;
        double x05_min = 0.0;
        double dev_min = 1.0E8;
        double delta = sd;
        int no = 0;
        if (fixPara != null) {
            double[] paras;
            if (fixPara.indexOf("y0") >= 0) {
                paras = AlgotithmUtils.parseFixPara(fixPara, "y0");
                y0l = paras[0];
                y0r = paras[1];
            }
            if (fixPara.indexOf("yinf") >= 0) {
                paras = AlgotithmUtils.parseFixPara(fixPara, "yinf");
                yl = paras[0];
                yr = paras[1];
            }
            if (fixPara.indexOf("slope") >= 0) {
                paras = AlgotithmUtils.parseFixPara(fixPara, "slope");
                sl = paras[0];
                sr = paras[1];
            }
            if (fixPara.indexOf("log_ac50") >= 0) {
                paras = AlgotithmUtils.parseFixPara(fixPara, "log_ac50");
                xl = paras[0];
                xr = paras[1];
            }
        }
        if (HillConstants.FIXED_AC50 != null && HillConstants.FIXED_AC50.length() > 0) {
            ds = AlgotithmUtils.parseConstraintPara(HillConstants.FIXED_AC50);
            xl = ds[0];
            xr = ds[1];
        }
        if (HillConstants.FIXED_Y0 != null && HillConstants.FIXED_Y0.length() > 0) {
            ds = AlgotithmUtils.parseConstraintPara(HillConstants.FIXED_Y0);
            y0l = ds[0];
            y0r = ds[1];
        }
        if (HillConstants.FIXED_YINF != null && HillConstants.FIXED_YINF.length() > 0) {
            ds = AlgotithmUtils.parseConstraintPara(HillConstants.FIXED_YINF);
            yl = ds[0];
            yr = ds[1];
        }
        if (HillConstants.FIXED_SLOPE != null && HillConstants.FIXED_SLOPE.length() > 0) {
            ds = AlgotithmUtils.parseConstraintPara(HillConstants.FIXED_SLOPE);
            sl = ds[0];
            sr = ds[1];
        }
        if (HillConstants.YINF_MORE_80) {
            if (yr > 0.0) {
                yl = 80.0;
                if (yr < 100.0) {
                    yr = 100.0;
                }
            } else {
                if (yl > -100.0) {
                    yl = -100.0;
                }
                yr = -80.0;
            }
        }
        for (double x05 = xl; x05 <= xr; x05 += xd) {
            for (double y0 = y0l; y0 <= y0r; y0 += y0d) {
                for (double yinf = yl; yinf <= yr; yinf += yd) {
                    double dev;
                    double slope;
                    double dev0;
                    if (HillConstants.Y0_LESS_THAN_YINF && Math.abs(y0) >= Math.abs(yinf)) continue;
                    double s0 = AlgotithmUtils.calcSlope(x05, y0, yinf, flags, xs, ys);
                    if (s0 < HillConstants.MIN_SLOPE) {
                        s0 = HillConstants.MIN_SLOPE;
                    }
                    if (s0 > HillConstants.MAX_SLOPE) {
                        s0 = HillConstants.MAX_SLOPE;
                    }
                    if ((dev0 = AlgotithmUtils.calcHillDeviation(x05, y0, yinf, s0, flags, ws, xs, ys)) < dev_min) {
                        dev_min = dev0;
                        slope_min = s0;
                        x05_min = x05;
                        yinf_min = yinf;
                        y0_min = y0;
                    }
                    if (!slopeFlag) continue;
                    sr = 1.5 * s0;
                    delta = 0.05 * s0;
                    for (slope = s0 + delta; slope <= sr && !((dev = AlgotithmUtils.calcHillDeviation(x05, y0, yinf, slope, flags, ws, xs, ys)) > dev0); slope += delta) {
                        dev0 = dev;
                        if (dev < dev_min) {
                            dev_min = dev;
                            slope_min = slope;
                            x05_min = x05;
                            yinf_min = yinf;
                            y0_min = y0;
                        }
                        ++no;
                    }
                    sl = 0.5 * s0;
                    for (slope = s0 - delta; slope >= sl && !((dev = AlgotithmUtils.calcHillDeviation(x05, y0, yinf, slope, flags, ws, xs, ys)) > dev0); slope -= delta) {
                        dev0 = dev;
                        if (dev < dev_min) {
                            dev_min = dev;
                            slope_min = slope;
                            x05_min = x05;
                            yinf_min = yinf;
                            y0_min = y0;
                        }
                        ++no;
                    }
                }
            }
        }
        double dev_const = AlgotithmUtils.calcConstantDeviation(flags, ws, xs, ys);
        double r2 = 0.0;
        if (HillConstants.CURVE_CLASS5) {
            double dev0 = (double)xs.length * HillConstants.CLASSIFICATION_SD * HillConstants.CLASSIFICATION_SD;
            r2 = 1.0 - dev_const / dev0;
        } else {
            r2 = 1.0 - dev_min / (1.0 + dev_const);
        }
        double[] values = new double[]{x05_min, yinf_min, slope_min, r2, dev_const, dev_min, y0_min};
        return values;
    }

    public static double[] hillFit3p(double y0l, double y0r, double y0d, double yl, double yr, double yd, double xl, double xr, double xd, double sl, double sr, double sd, boolean[] flags, double[] ws, double[] xs, double[] ys, String fixPara) {
        double y0_min = 0.0;
        double yinf_min = 0.0;
        double slope_min = 0.0;
        double x05_min = 0.0;
        double dev_min = 1.0E8;
        double delta = sd;
        int no = 0;
        if (fixPara != null) {
            double[] paras;
            if (fixPara.indexOf("y0") >= 0) {
                paras = AlgotithmUtils.parseFixPara(fixPara, "y0");
                y0l = paras[0];
                y0r = paras[1];
            }
            if (fixPara.indexOf("yinf") >= 0) {
                paras = AlgotithmUtils.parseFixPara(fixPara, "yinf");
                yl = paras[0];
                yr = paras[1];
            }
            if (fixPara.indexOf("slope") >= 0) {
                paras = AlgotithmUtils.parseFixPara(fixPara, "slope");
                sl = paras[0];
                sr = paras[1];
            }
            if (fixPara.indexOf("log_ac50") >= 0) {
                paras = AlgotithmUtils.parseFixPara(fixPara, "log_ac50");
                xl = paras[0];
                xr = paras[1];
            }
        }
        for (double y0 = y0l; y0 <= y0r; y0 += y0d) {
            for (double yinf = yl; yinf <= yr; yinf += yd) {
                for (double x05 = xl; x05 <= xr; x05 += xd) {
                    double slope = 1.0;
                    double dev = AlgotithmUtils.calcHillDeviation(x05, y0, yinf, slope, flags, ws, xs, ys);
                    if (dev < dev_min) {
                        dev_min = dev;
                        slope_min = slope;
                        x05_min = x05;
                        yinf_min = yinf;
                        y0_min = y0;
                    }
                    ++no;
                }
            }
        }
        double dev_const = AlgotithmUtils.calcConstantDeviation(flags, ws, xs, ys);
        double r2 = 0.0;
        if (HillConstants.CURVE_CLASS5) {
            double dev0 = (double)xs.length * HillConstants.CLASSIFICATION_SD * HillConstants.CLASSIFICATION_SD;
            r2 = 1.0 - dev_const / dev0;
        } else {
            r2 = 1.0 - dev_min / (1.0 + dev_const);
        }
        if (r2 < HillConstants.R2) {
            return null;
        }
        double[] values = new double[]{x05_min, yinf_min, slope_min, r2, dev_const, dev_min, y0_min};
        return values;
    }

    public static double[] hillFitFast_1(double ymin, double ymax, boolean[] flags, double[] ws, double[] xs, double[] ys, String fixPara) {
        if (!AlgotithmUtils.checkRange(ymin, ymax, flags, ys)) {
            return null;
        }
        double[] fitValues = AlgotithmUtils.lineFit(flags, xs, ys);
        if (fitValues == null) {
            double[] fitValues1 = HillFit.hillFitFast_2(ymin, ymax, flags, ws, xs, ys, fixPara, true);
            double[] fitValues2 = HillFit.hillFitFast_2(ymin, ymax, flags, ws, xs, ys, fixPara, false);
            if (fitValues1 == null && fitValues2 == null) {
                return null;
            }
            if (fitValues1 == null && fitValues2 != null) {
                return fitValues2;
            }
            if (fitValues1 != null && fitValues2 == null) {
                return fitValues1;
            }
            if (fitValues1[3] > fitValues2[3]) {
                return fitValues1;
            }
            return fitValues2;
        }
        if (fitValues[0] > 0.0) {
            return HillFit.hillFitFast_2(ymin, ymax, flags, ws, xs, ys, fixPara, true);
        }
        return HillFit.hillFitFast_2(ymin, ymax, flags, ws, xs, ys, fixPara, false);
    }

    public static double[] hillFitFast_2(double ymin, double ymax, boolean[] flags, double[] ws, double[] xs, double[] ys, String fixPara, boolean upFlag) {
        if (HillConstants.FIT_TYPE.equals("P5")) {
            double[] fitValues = AlgotithmUtils.lineFit(flags, xs, ys);
            if (fitValues[0] > 0.0) {
                return HillFit.hillFitFast5P(ymin, ymax, flags, ws, xs, ys, fixPara, true);
            }
            return HillFit.hillFitFast5P(ymin, ymax, flags, ws, xs, ys, fixPara, false);
        }
        if (!AlgotithmUtils.checkRange(ymin, ymax, flags, ys)) {
            return null;
        }
        double xl = -10.0;
        if (xs[0] * 1.2 < xl) {
            xl = xs[0] * 1.2;
        }
        double xr = -2.0;
        double xd = 0.5;
        double y0l = -150.0;
        double y0r = 150.0;
        double y0d = 5.0;
        double yl = -150.0;
        double yr = 150.0;
        double yd = 5.0;
        double sl = HillConstants.MIN_SLOPE;
        double sr = HillConstants.MAX_SLOPE;
        double sd = 0.2;
        double max_y = -1.7976931348623157E308;
        double min_y = Double.MAX_VALUE;
        for (int i = 0; i < ys.length; ++i) {
            if (!flags[i]) continue;
            if (ys[i] > max_y) {
                max_y = ys[i];
            }
            if (!(ys[i] < min_y)) continue;
            min_y = ys[i];
        }
        if (upFlag) {
            if (min_y < 0.0) {
                y0l = HillConstants.Y0_INF_COEF * min_y;
                y0r = 0.0;
            } else {
                y0l = 0.0;
                y0r = HillConstants.Y0_INF_COEF * min_y;
            }
            if (max_y > 0.0) {
                yl = 0.0;
                yr = HillConstants.Y0_INF_COEF * max_y;
            } else {
                yr = 0.0;
                yl = HillConstants.Y0_INF_COEF * max_y;
            }
            sl = HillConstants.MIN_SLOPE;
            sr = HillConstants.MAX_SLOPE;
        } else {
            if (max_y < 0.0) {
                y0l = HillConstants.Y0_INF_COEF * max_y;
                y0r = 0.0;
            } else {
                y0l = 0.0;
                y0r = HillConstants.Y0_INF_COEF * max_y;
            }
            if (min_y < 0.0) {
                yl = HillConstants.Y0_INF_COEF * min_y;
                yr = 0.0;
            } else {
                yr = HillConstants.Y0_INF_COEF * min_y;
                yl = 0.0;
            }
            sl = HillConstants.MIN_SLOPE;
            sr = HillConstants.MAX_SLOPE;
        }
        double delta_y = 0.05 * (max_y - min_y);
        if (delta_y < 1.0E-6) {
            delta_y = 0.05 * Math.abs(min_y);
        }
        y0d = (y0d = 0.05 * (y0r - y0l)) < 2.0 ? 2.0 : y0d;
        yd = 0.05 * (yr - yl);
        yd = yd < 2.0 ? 2.0 : yd;
        double d = yd = yd < delta_y ? delta_y : yd;
        if (delta_y < 1.0 && y0d > 1.0) {
            y0d = 1.0;
        }
        if (delta_y < 1.0 && yd > 1.0) {
            yd = 1.0;
        }
        double[] fitValues = null;
        fitValues = p4Fit && HillConstants.FIT_TYPE.equals("P4") ? HillFit.hillFit(y0l, y0r, y0d, yl, yr, yd, xl, xr, xd, sl, sr, sd, flags, ws, xs, ys, fixPara) : HillFit.hillFit3p(y0l, y0r, y0d, yl, yr, yd, xl, xr, xd, sl, sr, sd, flags, ws, xs, ys, fixPara);
        if (fitValues == null) {
            return null;
        }
        xl = fitValues[0] - 1.0;
        xr = fitValues[0] + 1.0;
        xd = HillConstants.EC50_GRID_SIZE;
        y0l = fitValues[6] - 2.0 * y0d;
        y0r = fitValues[6] + 2.0 * y0d;
        yl = fitValues[1] - 2.0 * yd;
        yr = fitValues[1] + 2.0 * yd;
        y0d = (y0d = 0.1 * y0d) < 0.5 ? 0.5 : y0d;
        yd = yd < 0.5 ? 0.5 : (yd *= 0.1);
        sl = fitValues[2] - 0.5 < 0.1 ? 0.1 : fitValues[2] - 0.5;
        sr = fitValues[2] + 0.5;
        sd = 0.1;
        fitValues = p4Fit && HillConstants.FIT_TYPE.equals("P4") ? HillFit.hillFit(y0l, y0r, y0d, yl, yr, yd, xl, xr, xd, sl, sr, sd, flags, ws, xs, ys, fixPara) : HillFit.hillFit3p(y0l, y0r, y0d, yl, yr, yd, xl, xr, xd, sl, sr, sd, flags, ws, xs, ys, fixPara);
        return fitValues;
    }
}

