/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tdouble.bin;

import cern.colt.list.tdouble.DoubleArrayList;
import cern.jet.random.tdouble.engine.DRand;
import cern.jet.random.tdouble.engine.DoubleRandomEngine;
import cern.jet.stat.tdouble.quantile.DoubleQuantileFinder;
import cern.jet.stat.tdouble.quantile.DoubleQuantileFinderFactory;
import hep.aida.tdouble.DoubleIAxis;
import hep.aida.tdouble.bin.AbstractDoubleBin1D;
import hep.aida.tdouble.bin.MightyStaticDoubleBin1D;
import hep.aida.tdouble.ref.DoubleConverter;
import java.util.Date;

public class QuantileDoubleBin1D
extends MightyStaticDoubleBin1D {
    private static final long serialVersionUID = 1L;
    protected DoubleQuantileFinder finder = null;

    protected QuantileDoubleBin1D() {
        super(false, false, 2);
    }

    public QuantileDoubleBin1D(double d) {
        this(false, Long.MAX_VALUE, d, 0.001, 10000, new DRand(new Date()));
    }

    public QuantileDoubleBin1D(boolean bl, long l, double d, double d2, int n, DoubleRandomEngine doubleRandomEngine) {
        this(bl, l, d, d2, n, doubleRandomEngine, false, false, 2);
    }

    public QuantileDoubleBin1D(boolean bl, long l, double d, double d2, int n, DoubleRandomEngine doubleRandomEngine, boolean bl2, boolean bl3, int n2) {
        super(bl2, bl3, n2);
        this.finder = DoubleQuantileFinderFactory.newDoubleQuantileFinder(bl, l, d, d2, n, doubleRandomEngine);
        this.clear();
    }

    public synchronized void addAllOfFromTo(DoubleArrayList doubleArrayList, int n, int n2) {
        super.addAllOfFromTo(doubleArrayList, n, n2);
        if (this.finder != null) {
            this.finder.addAllOfFromTo(doubleArrayList, n, n2);
        }
    }

    public synchronized void clear() {
        super.clear();
        if (this.finder != null) {
            this.finder.clear();
        }
    }

    public synchronized Object clone() {
        QuantileDoubleBin1D quantileDoubleBin1D = (QuantileDoubleBin1D)super.clone();
        if (this.finder != null) {
            quantileDoubleBin1D.finder = (DoubleQuantileFinder)quantileDoubleBin1D.finder.clone();
        }
        return quantileDoubleBin1D;
    }

    public String compareWith(AbstractDoubleBin1D abstractDoubleBin1D) {
        StringBuffer stringBuffer = new StringBuffer(super.compareWith(abstractDoubleBin1D));
        if (abstractDoubleBin1D instanceof QuantileDoubleBin1D) {
            QuantileDoubleBin1D quantileDoubleBin1D = (QuantileDoubleBin1D)abstractDoubleBin1D;
            stringBuffer.append("25%, 50% and 75% Quantiles: " + this.relError(this.quantile(0.25), quantileDoubleBin1D.quantile(0.25)) + ", " + this.relError(this.quantile(0.5), quantileDoubleBin1D.quantile(0.5)) + ", " + this.relError(this.quantile(0.75), quantileDoubleBin1D.quantile(0.75)));
            stringBuffer.append("\nquantileInverse(mean): " + this.relError(this.quantileInverse(this.mean()), quantileDoubleBin1D.quantileInverse(quantileDoubleBin1D.mean())) + " %");
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public double median() {
        return this.quantile(0.5);
    }

    public synchronized double quantile(double d) {
        return this.quantiles(new DoubleArrayList(new double[]{d})).get(0);
    }

    public synchronized double quantileInverse(double d) {
        return this.finder.phi(d);
    }

    public synchronized DoubleArrayList quantiles(DoubleArrayList doubleArrayList) {
        return this.finder.quantileElements(doubleArrayList);
    }

    public int sizeOfRange(double d, double d2) {
        return (int)Math.round((double)this.size() * (this.quantileInverse(d2) - this.quantileInverse(d)));
    }

    public synchronized MightyStaticDoubleBin1D[] splitApproximately(DoubleArrayList doubleArrayList, int n) {
        int n2;
        int n3 = doubleArrayList.size();
        if (n < 1 || n3 < 2) {
            throw new IllegalArgumentException();
        }
        double[] dArray = doubleArrayList.elements();
        int n4 = n3 - 1;
        double[] dArray2 = new double[1 + n * (n3 - 1)];
        dArray2[0] = dArray[0];
        int n5 = 1;
        for (int i = 0; i < n4; ++i) {
            double d = (dArray[i + 1] - dArray[i]) / (double)n;
            for (n2 = 1; n2 <= n; ++n2) {
                dArray2[n5++] = dArray[i] + (double)n2 * d;
            }
        }
        double[] dArray3 = this.quantiles(new DoubleArrayList(dArray2)).elements();
        MightyStaticDoubleBin1D[] mightyStaticDoubleBin1DArray = new MightyStaticDoubleBin1D[n4];
        int n6 = this.getMaxOrderForSumOfPowers();
        n6 = Math.min(10, n6);
        n2 = this.size();
        n5 = 0;
        for (int i = 0; i < n4; ++i) {
            double d;
            int n7;
            double d2;
            double d3 = (dArray[i + 1] - dArray[i]) / (double)n;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            double[] dArray4 = null;
            if (n6 > 2) {
                dArray4 = new double[n6 - 2];
            }
            double d8 = d2 = dArray3[n5++];
            double d9 = (double)n2 * d3;
            for (n7 = 1; n7 <= n; ++n7) {
                d = dArray3[n5++];
                double d10 = (d2 + d) / 2.0;
                d4 += d10 * d9;
                d5 += d10 * d10 * d9;
                if (this.hasSumOfLogarithms) {
                    d6 += Math.log(d10) * d9;
                }
                if (this.hasSumOfInversions) {
                    d7 += 1.0 / d10 * d9;
                }
                if (n6 >= 3) {
                    dArray4[0] = dArray4[0] + d10 * d10 * d10 * d9;
                }
                if (n6 >= 4) {
                    dArray4[1] = dArray4[1] + d10 * d10 * d10 * d10 * d9;
                }
                for (int j = 5; j <= n6; ++j) {
                    int n8 = j - 3;
                    dArray4[n8] = dArray4[n8] + Math.pow(d10, j) * d9;
                }
                d2 = d;
            }
            --n5;
            n7 = (int)Math.round((dArray[i + 1] - dArray[i]) * (double)n2);
            d = d2;
            d2 = d8;
            mightyStaticDoubleBin1DArray[i] = new MightyStaticDoubleBin1D(this.hasSumOfLogarithms, this.hasSumOfInversions, n6);
            if (n7 <= 0) continue;
            mightyStaticDoubleBin1DArray[i].size = n7;
            mightyStaticDoubleBin1DArray[i].min = d2;
            mightyStaticDoubleBin1DArray[i].max = d;
            mightyStaticDoubleBin1DArray[i].sum = d4;
            mightyStaticDoubleBin1DArray[i].sum_xx = d5;
            mightyStaticDoubleBin1DArray[i].sumOfLogarithms = d6;
            mightyStaticDoubleBin1DArray[i].sumOfInversions = d7;
            mightyStaticDoubleBin1DArray[i].sumOfPowers = dArray4;
        }
        return mightyStaticDoubleBin1DArray;
    }

    public synchronized MightyStaticDoubleBin1D[] splitApproximately(DoubleIAxis doubleIAxis, int n) {
        DoubleArrayList doubleArrayList = new DoubleArrayList(new DoubleConverter().edges(doubleIAxis));
        doubleArrayList.beforeInsert(0, Double.NEGATIVE_INFINITY);
        doubleArrayList.add(Double.POSITIVE_INFINITY);
        int n2 = doubleArrayList.size();
        while (--n2 >= 0) {
            doubleArrayList.set(n2, this.quantileInverse(doubleArrayList.get(n2)));
        }
        return this.splitApproximately(doubleArrayList, n);
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("25%, 50%, 75% Quantiles: " + this.quantile(0.25) + ", " + this.quantile(0.5) + ", " + this.quantile(0.75));
        stringBuffer.append("\nquantileInverse(median): " + this.quantileInverse(this.median()));
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

