/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.LongMatrix3D;
import cern.colt.matrix.tlong.impl.DelegateLongMatrix2D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix1D;

public class WrapperLongMatrix3D
extends LongMatrix3D {
    private static final long serialVersionUID = 1L;
    protected LongMatrix3D content;

    public WrapperLongMatrix3D(LongMatrix3D longMatrix3D) {
        block3: {
            if (longMatrix3D != null) {
                try {
                    this.setUp(longMatrix3D.slices(), longMatrix3D.rows(), longMatrix3D.columns());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if ("matrix too large".equals(illegalArgumentException.getMessage())) break block3;
                    throw illegalArgumentException;
                }
            }
        }
        this.content = longMatrix3D;
    }

    public Object elements() {
        return this.content.elements();
    }

    public synchronized long getQuick(int n, int n2, int n3) {
        return this.content.getQuick(n, n2, n3);
    }

    public LongMatrix3D like(int n, int n2, int n3) {
        return this.content.like(n, n2, n3);
    }

    public synchronized void setQuick(int n, int n2, int n3, long l) {
        this.content.setQuick(n, n2, n3, l);
    }

    public LongMatrix1D vectorize() {
        DenseLongMatrix1D denseLongMatrix1D = new DenseLongMatrix1D((int)this.size());
        int n = this.rows * this.columns;
        for (int i = 0; i < this.slices; ++i) {
            denseLongMatrix1D.viewPart(i * n, n).assign(this.viewSlice(i).vectorize());
        }
        return denseLongMatrix1D;
    }

    public LongMatrix2D viewColumn(int n) {
        this.checkColumn(n);
        return new DelegateLongMatrix2D(this, 2, n);
    }

    public LongMatrix3D viewColumnFlip() {
        if (this.columns == 0) {
            return this;
        }
        WrapperLongMatrix3D wrapperLongMatrix3D = new WrapperLongMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized long getQuick(int n, int n2, int n3) {
                return this.content.getQuick(n, n2, this.columns - 1 - n3);
            }

            public synchronized void setQuick(int n, int n2, int n3, long l) {
                this.content.setQuick(n, n2, this.columns - 1 - n3, l);
            }

            public synchronized long get(int n, int n2, int n3) {
                return this.content.get(n, n2, this.columns - 1 - n3);
            }

            public synchronized void set(int n, int n2, int n3, long l) {
                this.content.set(n, n2, this.columns - 1 - n3, l);
            }
        };
        wrapperLongMatrix3D.isNoView = false;
        return wrapperLongMatrix3D;
    }

    public LongMatrix2D viewSlice(int n) {
        this.checkSlice(n);
        return new DelegateLongMatrix2D(this, 0, n);
    }

    public LongMatrix3D viewSliceFlip() {
        if (this.slices == 0) {
            return this;
        }
        WrapperLongMatrix3D wrapperLongMatrix3D = new WrapperLongMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized long getQuick(int n, int n2, int n3) {
                return this.content.getQuick(this.slices - 1 - n, n2, n3);
            }

            public synchronized void setQuick(int n, int n2, int n3, long l) {
                this.content.setQuick(this.slices - 1 - n, n2, n3, l);
            }

            public synchronized long get(int n, int n2, int n3) {
                return this.content.get(this.slices - 1 - n, n2, n3);
            }

            public synchronized void set(int n, int n2, int n3, long l) {
                this.content.set(this.slices - 1 - n, n2, n3, l);
            }
        };
        wrapperLongMatrix3D.isNoView = false;
        return wrapperLongMatrix3D;
    }

    public LongMatrix3D viewDice(int n, int n2, int n3) {
        int n4 = 3;
        if (n < 0 || n >= n4 || n2 < 0 || n2 >= n4 || n3 < 0 || n3 >= n4 || n == n2 || n == n3 || n2 == n3) {
            throw new IllegalArgumentException("Illegal Axes: " + n + ", " + n2 + ", " + n3);
        }
        WrapperLongMatrix3D wrapperLongMatrix3D = null;
        if (n == 0 && n2 == 1 && n3 == 2) {
            wrapperLongMatrix3D = new WrapperLongMatrix3D(this);
        } else if (n == 1 && n2 == 0 && n3 == 2) {
            wrapperLongMatrix3D = new WrapperLongMatrix3D(this){
                private static final long serialVersionUID = 1L;

                public synchronized long getQuick(int n, int n2, int n3) {
                    return this.content.getQuick(n2, n, n3);
                }

                public synchronized void setQuick(int n, int n2, int n3, long l) {
                    this.content.setQuick(n2, n, n3, l);
                }

                public synchronized long get(int n, int n2, int n3) {
                    return this.content.get(n2, n, n3);
                }

                public synchronized void set(int n, int n2, int n3, long l) {
                    this.content.set(n2, n, n3, l);
                }
            };
        } else if (n == 1 && n2 == 2 && n3 == 0) {
            wrapperLongMatrix3D = new WrapperLongMatrix3D(this){
                private static final long serialVersionUID = 1L;

                public synchronized long getQuick(int n, int n2, int n3) {
                    return this.content.getQuick(n2, n3, n);
                }

                public synchronized void setQuick(int n, int n2, int n3, long l) {
                    this.content.setQuick(n2, n3, n, l);
                }

                public synchronized long get(int n, int n2, int n3) {
                    return this.content.get(n2, n3, n);
                }

                public synchronized void set(int n, int n2, int n3, long l) {
                    this.content.set(n2, n3, n, l);
                }
            };
        } else if (n == 2 && n2 == 1 && n3 == 0) {
            wrapperLongMatrix3D = new WrapperLongMatrix3D(this){
                private static final long serialVersionUID = 1L;

                public synchronized long getQuick(int n, int n2, int n3) {
                    return this.content.getQuick(n3, n2, n);
                }

                public synchronized void setQuick(int n, int n2, int n3, long l) {
                    this.content.setQuick(n3, n2, n, l);
                }

                public synchronized long get(int n, int n2, int n3) {
                    return this.content.get(n3, n2, n);
                }

                public synchronized void set(int n, int n2, int n3, long l) {
                    this.content.set(n3, n2, n, l);
                }
            };
        } else if (n == 2 && n2 == 0 && n3 == 1) {
            wrapperLongMatrix3D = new WrapperLongMatrix3D(this){
                private static final long serialVersionUID = 1L;

                public synchronized long getQuick(int n, int n2, int n3) {
                    return this.content.getQuick(n3, n, n2);
                }

                public synchronized void setQuick(int n, int n2, int n3, long l) {
                    this.content.setQuick(n3, n, n2, l);
                }

                public synchronized long get(int n, int n2, int n3) {
                    return this.content.get(n3, n, n2);
                }

                public synchronized void set(int n, int n2, int n3, long l) {
                    this.content.set(n3, n, n2, l);
                }
            };
        }
        int[] nArray = this.shape();
        wrapperLongMatrix3D.slices = nArray[n];
        wrapperLongMatrix3D.rows = nArray[n2];
        wrapperLongMatrix3D.columns = nArray[n3];
        wrapperLongMatrix3D.isNoView = false;
        return wrapperLongMatrix3D;
    }

    public LongMatrix3D viewPart(final int n, final int n2, final int n3, int n4, int n5, int n6) {
        this.checkBox(n, n2, n3, n4, n5, n6);
        WrapperLongMatrix3D wrapperLongMatrix3D = new WrapperLongMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized long getQuick(int n4, int n22, int n32) {
                return this.content.getQuick(n + n4, n2 + n22, n3 + n32);
            }

            public synchronized void setQuick(int n4, int n22, int n32, long l) {
                this.content.setQuick(n + n4, n2 + n22, n3 + n32, l);
            }

            public synchronized long get(int n4, int n22, int n32) {
                return this.content.get(n + n4, n2 + n22, n3 + n32);
            }

            public synchronized void set(int n4, int n22, int n32, long l) {
                this.content.set(n + n4, n2 + n22, n3 + n32, l);
            }
        };
        wrapperLongMatrix3D.slices = n4;
        wrapperLongMatrix3D.rows = n5;
        wrapperLongMatrix3D.columns = n6;
        wrapperLongMatrix3D.isNoView = false;
        return wrapperLongMatrix3D;
    }

    public LongMatrix2D viewRow(int n) {
        this.checkRow(n);
        return new DelegateLongMatrix2D(this, 1, n);
    }

    public LongMatrix3D viewRowFlip() {
        if (this.rows == 0) {
            return this;
        }
        WrapperLongMatrix3D wrapperLongMatrix3D = new WrapperLongMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized long getQuick(int n, int n2, int n3) {
                return this.content.getQuick(n, this.rows - 1 - n2, n3);
            }

            public synchronized void setQuick(int n, int n2, int n3, long l) {
                this.content.setQuick(n, this.rows - 1 - n2, n3, l);
            }

            public synchronized long get(int n, int n2, int n3) {
                return this.content.get(n, this.rows - 1 - n2, n3);
            }

            public synchronized void set(int n, int n2, int n3, long l) {
                this.content.set(n, this.rows - 1 - n2, n3, l);
            }
        };
        wrapperLongMatrix3D.isNoView = false;
        return wrapperLongMatrix3D;
    }

    public LongMatrix3D viewSelection(int[] nArray, int[] nArray2, int[] nArray3) {
        int n;
        if (nArray == null) {
            nArray = new int[this.slices];
            n = this.slices;
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.rows];
            n = this.rows;
            while (--n >= 0) {
                nArray2[n] = n;
            }
        }
        if (nArray3 == null) {
            nArray3 = new int[this.columns];
            n = this.columns;
            while (--n >= 0) {
                nArray3[n] = n;
            }
        }
        this.checkSliceIndexes(nArray);
        this.checkRowIndexes(nArray2);
        this.checkColumnIndexes(nArray3);
        final int[] nArray4 = nArray;
        final int[] nArray5 = nArray2;
        final int[] nArray6 = nArray3;
        WrapperLongMatrix3D wrapperLongMatrix3D = new WrapperLongMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized long getQuick(int n, int n2, int n3) {
                return this.content.getQuick(nArray4[n], nArray5[n2], nArray6[n3]);
            }

            public synchronized void setQuick(int n, int n2, int n3, long l) {
                this.content.setQuick(nArray4[n], nArray5[n2], nArray6[n3], l);
            }

            public synchronized long get(int n, int n2, int n3) {
                return this.content.get(nArray4[n], nArray5[n2], nArray6[n3]);
            }

            public synchronized void set(int n, int n2, int n3, long l) {
                this.content.set(nArray4[n], nArray5[n2], nArray6[n3], l);
            }
        };
        wrapperLongMatrix3D.slices = nArray.length;
        wrapperLongMatrix3D.rows = nArray2.length;
        wrapperLongMatrix3D.columns = nArray3.length;
        wrapperLongMatrix3D.isNoView = false;
        return wrapperLongMatrix3D;
    }

    public LongMatrix3D viewStrides(final int n, final int n2, final int n3) {
        if (n <= 0 || n2 <= 0 || n3 <= 0) {
            throw new IndexOutOfBoundsException("illegal stride");
        }
        WrapperLongMatrix3D wrapperLongMatrix3D = new WrapperLongMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized long getQuick(int n4, int n22, int n32) {
                return this.content.getQuick(n * n4, n2 * n22, n3 * n32);
            }

            public synchronized void setQuick(int n4, int n22, int n32, long l) {
                this.content.setQuick(n * n4, n2 * n22, n3 * n32, l);
            }

            public synchronized long get(int n4, int n22, int n32) {
                return this.content.get(n * n4, n2 * n22, n3 * n32);
            }

            public synchronized void set(int n4, int n22, int n32, long l) {
                this.content.set(n * n4, n2 * n22, n3 * n32, l);
            }
        };
        if (this.slices != 0) {
            wrapperLongMatrix3D.slices = (this.slices - 1) / n + 1;
        }
        if (this.rows != 0) {
            wrapperLongMatrix3D.rows = (this.rows - 1) / n2 + 1;
        }
        if (this.columns != 0) {
            wrapperLongMatrix3D.columns = (this.columns - 1) / n3 + 1;
        }
        wrapperLongMatrix3D.isNoView = false;
        return wrapperLongMatrix3D;
    }

    protected LongMatrix3D getContent() {
        return this.content;
    }

    public LongMatrix2D like2D(int n, int n2) {
        throw new InternalError();
    }

    protected LongMatrix2D like2D(int n, int n2, int n3, int n4, int n5, int n6) {
        throw new InternalError();
    }

    protected LongMatrix3D viewSelectionLike(int[] nArray, int[] nArray2, int[] nArray3) {
        throw new InternalError();
    }
}

