/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix3D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.WrapperFComplexMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix2D;

class DelegateFComplexMatrix2D
extends FComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    protected FComplexMatrix3D content;
    protected int index;
    protected int axis;

    public DelegateFComplexMatrix2D(FComplexMatrix3D fComplexMatrix3D, int n, int n2) {
        switch (n) {
            case 0: {
                if (n2 < 0 || n2 >= fComplexMatrix3D.slices()) {
                    throw new IllegalArgumentException();
                }
                this.setUp(fComplexMatrix3D.rows(), fComplexMatrix3D.columns());
                break;
            }
            case 1: {
                if (n2 < 0 || n2 >= fComplexMatrix3D.rows()) {
                    throw new IllegalArgumentException();
                }
                this.setUp(fComplexMatrix3D.slices(), fComplexMatrix3D.columns());
                break;
            }
            case 2: {
                if (n2 < 0 || n2 >= fComplexMatrix3D.columns()) {
                    throw new IllegalArgumentException();
                }
                this.setUp(fComplexMatrix3D.slices(), fComplexMatrix3D.rows());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.axis = n;
        this.index = n2;
        this.content = fComplexMatrix3D;
    }

    public synchronized float[] getQuick(int n, int n2) {
        switch (this.axis) {
            case 0: {
                return this.content.getQuick(this.index, n, n2);
            }
            case 1: {
                return this.content.getQuick(n, this.index, n2);
            }
            case 2: {
                return this.content.getQuick(n, n2, this.index);
            }
        }
        throw new IllegalArgumentException();
    }

    public FComplexMatrix2D like(int n, int n2) {
        return this.content.like2D(n, n2);
    }

    public synchronized void setQuick(int n, int n2, float[] fArray) {
        switch (this.axis) {
            case 0: {
                this.content.setQuick(this.index, n, n2, fArray);
                break;
            }
            case 1: {
                this.content.setQuick(n, this.index, n2, fArray);
                break;
            }
            case 2: {
                this.content.setQuick(n, n2, this.index, fArray);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public synchronized void setQuick(int n, int n2, float f, float f2) {
        switch (this.axis) {
            case 0: {
                this.content.setQuick(this.index, n, n2, f, f2);
                break;
            }
            case 1: {
                this.content.setQuick(n, this.index, n2, f, f2);
                break;
            }
            case 2: {
                this.content.setQuick(n, n2, this.index, f, f2);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public FComplexMatrix1D viewColumn(int n) {
        this.checkColumn(n);
        return new WrapperFComplexMatrix2D(this).viewColumn(n);
    }

    public Object elements() {
        return this.content.elements();
    }

    protected FComplexMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public FComplexMatrix1D like1D(int n) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    protected FComplexMatrix1D like1D(int n, int n2, int n3) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public FComplexMatrix1D vectorize() {
        DenseFComplexMatrix1D denseFComplexMatrix1D = new DenseFComplexMatrix1D(this.rows * this.columns);
        int n = 0;
        for (int i = 0; i < this.columns; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                ((FComplexMatrix1D)denseFComplexMatrix1D).setQuick(n++, this.getQuick(j, i));
            }
        }
        return denseFComplexMatrix1D;
    }

    public FloatMatrix2D getImaginaryPart() {
        switch (this.axis) {
            case 0: {
                return this.content.viewSlice(this.index).getImaginaryPart();
            }
            case 1: {
                return this.content.viewRow(this.index).getImaginaryPart();
            }
            case 2: {
                return this.content.viewColumn(this.index).getImaginaryPart();
            }
        }
        throw new IllegalArgumentException();
    }

    public FloatMatrix2D getRealPart() {
        switch (this.axis) {
            case 0: {
                return this.content.viewSlice(this.index).getRealPart();
            }
            case 1: {
                return this.content.viewRow(this.index).getRealPart();
            }
            case 2: {
                return this.content.viewColumn(this.index).getRealPart();
            }
        }
        throw new IllegalArgumentException();
    }
}

