## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(collapse = TRUE, comment = "#>")

## -----------------------------------------------------------------------------
library("Gifi")
data("WilPat2")
WP6 <- WilPat2[,1:7]   
head(WP6)

## -----------------------------------------------------------------------------
fit_homwp <- homals(WP6)
fit_homwp

## ----fig.width=5, fig.height=5------------------------------------------------
plot(fit_homwp, plot.type = "jointplot")

## ----fig.width=5, fig.height=5------------------------------------------------
colvec <- c(rep("gray", 6), "coral4")
plot(fit_homwp, plot.type = "jointplot", col.points = colvec)

## ----fig.height=7, fig.width=7------------------------------------------------
plot(fit_homwp, plot.type = "transplot")

## -----------------------------------------------------------------------------
data("WilPat2")
WilPat2$Age <- cut(WilPat2$Age, breaks = c(17, 20, 23, 30, 40, 100), labels = 1:5)      
head(WilPat2)

## -----------------------------------------------------------------------------
levelvec <- c(rep("nominal", 6), "nominal", "metric", "metric", "nominal", "ordinal")    
wen_hom <- homals(WilPat2, levels = levelvec) 
wen_hom

