/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.metaAnalysis;

import dr.inference.model.CompoundLikelihood;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import java.util.ArrayList;
import java.util.List;
import org.ohdsi.data.SccsData;
import org.ohdsi.likelihood.SccsPartialLikelihood;
import org.ohdsi.mcmc.Runner;
import org.ohdsi.metaAnalysis.DataModel;
import org.ohdsi.metaAnalysis.HalfNormalOnStdDevPrior;
import org.ohdsi.metaAnalysis.MetaAnalysis;
import org.ohdsi.metaAnalysis.ScalePrior;

public class SccsDataModel
implements DataModel {
    private final List<Parameter> thetaList = new ArrayList<Parameter>();
    private final List<Likelihood> likelihoodList = new ArrayList<Likelihood>();
    private final List<Integer> identifierList = new ArrayList<Integer>();
    private CompoundLikelihood likelihood = null;
    private Parameter theta = null;

    public void addLikelihoodData(int[] y, double[] a, double[][] x, int[] stratumId, double[] time) {
        Parameter.Default theta = new Parameter.Default("theta" + (this.thetaList.size() + 1), 0.1, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        SccsData data = new SccsData(y, a, x, stratumId, time);
        SccsPartialLikelihood thisLikelihood = new SccsPartialLikelihood((Parameter)theta, data);
        this.thetaList.add((Parameter)theta);
        this.likelihoodList.add((Likelihood)thisLikelihood);
        this.identifierList.add(this.identifierList.size() + 1);
    }

    public void finish() {
        this.likelihood = new CompoundLikelihood(this.likelihoodList);
        this.theta = new CompoundParameter("theta", this.thetaList.toArray(new Parameter[0]));
    }

    @Override
    public Likelihood getLikelihood() {
        return this.likelihood;
    }

    @Override
    public Parameter getCompoundParameter() {
        return this.theta;
    }

    @Override
    public List<Parameter> getIndividualParameters() {
        return this.thetaList;
    }

    @Override
    public List<Integer> getIdentifiers() {
        return this.identifierList;
    }

    public static void main(String[] args) {
        SccsDataModel dataModel = new SccsDataModel();
        int[] nArray = new int[38];
        nArray[0] = 1;
        nArray[5] = 1;
        nArray[9] = 1;
        nArray[13] = 1;
        nArray[18] = 1;
        nArray[22] = 1;
        nArray[25] = 1;
        nArray[29] = 1;
        nArray[35] = 1;
        nArray[36] = 1;
        int[] y = nArray;
        double[] time = new double[]{107.0, 21.0, 54.0, 183.0, 41.0, 21.0, 120.0, 183.0, 78.0, 21.0, 83.0, 183.0, 82.0, 21.0, 79.0, 183.0, 81.0, 21.0, 80.0, 183.0, 44.0, 21.0, 117.0, 183.0, 119.0, 21.0, 42.0, 183.0, 145.0, 21.0, 16.0, 183.0, 77.0, 21.0, 84.0, 183.0, 182.0, 183.0};
        double[] a = new double[]{0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0};
        double[][] x = new double[][]{{0.0}, {0.0}, {0.0}, {1.0}, {0.0}, {0.0}, {0.0}, {1.0}, {0.0}, {0.0}, {0.0}, {1.0}, {0.0}, {0.0}, {0.0}, {1.0}, {0.0}, {0.0}, {0.0}, {1.0}, {0.0}, {0.0}, {0.0}, {1.0}, {0.0}, {0.0}, {0.0}, {1.0}, {0.0}, {0.0}, {0.0}, {1.0}, {0.0}, {0.0}, {0.0}, {1.0}, {0.0}, {1.0}};
        int[] stratumId = new int[]{1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 8, 9, 9, 9, 9, 10, 10};
        dataModel.addLikelihoodData(y, a, x, stratumId, time);
        dataModel.finish();
        HalfNormalOnStdDevPrior prior = new HalfNormalOnStdDevPrior(0.0, 0.5);
        MetaAnalysis metaAnalysis = new MetaAnalysis((DataModel)dataModel, (ScalePrior)prior, 2.0);
        Runner runner = new Runner(metaAnalysis, 10, 1, 1, 123.0, false);
        runner.run();
    }
}

