/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.metaAnalysis;

import dr.inference.distribution.EmpiricalDistributionData;
import dr.inference.distribution.EmpiricalDistributionLikelihood;
import dr.math.distributions.NormalDistribution;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import org.ohdsi.metaAnalysis.DataModel;

public class NormalDataModel
extends DataModel.Base
implements DataModel {
    public NormalDataModel(String fileName) {
        this();
        File file = new File(fileName);
        ArrayList<List<String>> lines = new ArrayList<List<String>>();
        try {
            Scanner inputStream = new Scanner(file);
            while (inputStream.hasNext()) {
                String line = inputStream.next();
                line = line.replaceAll("\"", "");
                String[] values = line.split(",");
                lines.add(Arrays.asList(values));
            }
            inputStream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        int logRrIdx = ((List)lines.get(0)).indexOf("logRr");
        int seLogRrIdx = ((List)lines.get(0)).indexOf("seLogRr");
        int i = 1;
        while (i < lines.size()) {
            double[] parameters = new double[]{Double.parseDouble((String)((List)lines.get(i)).get(logRrIdx)), Double.parseDouble((String)((List)lines.get(i)).get(seLogRrIdx))};
            this.addLikelihoodParameters(parameters, null);
            ++i;
        }
        this.finish();
    }

    public NormalDataModel() {
    }

    @Override
    EmpiricalDistributionLikelihood makeFunctionalForm(List<EmpiricalDistributionData> dataList) {
        return new EmpiricalDistributionLikelihood(dataList, false){
            private static final long serialVersionUID = 6515855145410583409L;

            protected double logPDF(double x, EmpiricalDistributionData data) {
                double mean = data.values[0];
                double stdDev = data.values[1];
                return NormalDistribution.logPdf((double)x, (double)mean, (double)stdDev);
            }

            protected double gradientLogPdf(double x, EmpiricalDistributionData data) {
                double mean = data.values[0];
                double stdDev = data.values[1];
                return NormalDistribution.gradLogPdf((double)x, (double)mean, (double)stdDev);
            }
        };
    }
}

