## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(spell.replacer)

## ----basic_example------------------------------------------------------------
# Example text with misspellings
text <- c("This is a smple text with some mispelled words.",
          "We can corect them automaticaly.")

# Apply spell correction
corrected_text <- spell_replace(text)
print(corrected_text)

## ----custom_example-----------------------------------------------------------
# More restrictive threshold (fewer corrections)
conservative <- spell_replace(text, threshold = 0.08)

# Ignore potential proper names
text_with_names <- "John went to Bostan yesterday."
corrected_names <- spell_replace(text_with_names, ignore_names = TRUE)
print(corrected_names)

## ----single_word--------------------------------------------------------------
# Correct a single word
corrected_word <- correct("recieve", coca_list)
print(corrected_word)

## ----dataframe_example, eval = FALSE------------------------------------------
# library(dplyr)
# 
# # Example dataframe with text column
# docs <- data.frame(
#   id = 1:3,
#   text = c("This docment has misspellings.",
#            "Anothr exmple with erors.",
#            "The finl text sampel.")
# )
# 
# # Apply spell correction using tidy syntax
# docs %>%
#   mutate(text = spell_replace(text))

## ----coca_data----------------------------------------------------------------
# Most frequent words
head(coca_list, 10)

# Check if a word is in the list
"hello" %in% coca_list

# Find the frequency rank of a word
which(coca_list == "hello")

