% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim.R
\name{str_trim}
\alias{str_trim}
\alias{str_squish}
\title{Remove whitespace}
\usage{
str_trim(string, side = c("both", "left", "right"))

str_squish(string)
}
\arguments{
\item{string}{Input vector. Either a character vector, or something
coercible to one.}

\item{side}{Side on which to remove whitespace: "left", "right", or
"both", the default.}
}
\value{
A character vector the same length as \code{string}.
}
\description{
\code{str_trim()} removes whitespace from start and end of string; \code{str_squish()}
removes whitespace at the start and end, and replaces all internal whitespace
with a single space.
}
\examples{
str_trim("  String with trailing and leading white space\t")
str_trim("\n\nString with trailing and leading white space\n\n")

str_squish("  String with trailing,  middle, and leading white space\t")
str_squish("\n\nString with excess,  trailing and leading white   space\n\n")
}
\seealso{
\code{\link[=str_pad]{str_pad()}} to add whitespace
}
