#' Adds 1 to x
#'
#' @param x A numeric value.
#' @return A numeric value which is x + 1.
#' @examples
#' addOne(5) # returns 6
#' @export
setGeneric("addOne", function(x) standardGeneric("addOne"))

#' @rdname addOne
#' @aliases addOne
setMethod("addOne", signature(x = "numeric"), function(x) {
  checkmate::assert_numeric(x)
  x + 1
})
