/*
 * Decompiled with CFR 0.152.
 */
package org.restopt.grid.neighborhood.regular.square.partial.grouped;

import org.chocosolver.solver.Model;
import org.chocosolver.util.objects.graphs.GraphFactory;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.restopt.grid.neighborhood.INeighborhood;
import org.restopt.grid.neighborhood.Neighborhoods;
import org.restopt.grid.regular.square.PartialRegularGroupedAggGrid;

public class PartialGroupedAggFourConnected<T extends PartialRegularGroupedAggGrid>
implements INeighborhood<T> {
    @Override
    public int[] getNeighbors(T grid, int groupedIdx) {
        if (groupedIdx < ((PartialRegularGroupedAggGrid)grid).getNbGroups()) {
            ISet neighs = SetFactory.makeRangeSet();
            ISetIterator iSetIterator = ((PartialRegularGroupedAggGrid)grid).getGroup(groupedIdx).iterator();
            while (iSetIterator.hasNext()) {
                int partialIdx = (Integer)iSetIterator.next();
                for (int n : Neighborhoods.PARTIAL_FOUR_CONNECTED.getNeighbors(grid, partialIdx)) {
                    if (((PartialRegularGroupedAggGrid)grid).getGroupIndexFromPartialIndex(n) == groupedIdx) continue;
                    neighs.add(((PartialRegularGroupedAggGrid)grid).getGroupIndexFromPartialIndex(n));
                }
            }
            return neighs.toArray();
        }
        ISet neighbors = SetFactory.makeRangeSet();
        for (int partialIxd : ((PartialRegularGroupedAggGrid)grid).getAggregatePartialIndices(groupedIdx)) {
            for (int n : Neighborhoods.PARTIAL_FOUR_CONNECTED.getNeighbors(grid, partialIxd)) {
                if (((PartialRegularGroupedAggGrid)grid).getGroupIndexFromPartialIndex(n) == groupedIdx) continue;
                neighbors.add(((PartialRegularGroupedAggGrid)grid).getGroupIndexFromPartialIndex(n));
            }
        }
        return neighbors.toArray();
    }

    @Override
    public UndirectedGraph getPartialGraph(T grid, Model model, int[] cells, SetType nodeSetType, SetType edgeSetType) {
        int nbCells = ((PartialRegularGroupedAggGrid)grid).getNbCells();
        UndirectedGraph partialGraph = GraphFactory.makeStoredUndirectedGraph(model, nbCells, nodeSetType, edgeSetType);
        for (int i : cells) {
            partialGraph.addNode(i);
        }
        for (int i : cells) {
            int[] neighbors;
            if (i < ((PartialRegularGroupedAggGrid)grid).getNbGroups()) continue;
            for (int ii : neighbors = this.getNeighbors(grid, i)) {
                if (!partialGraph.getNodes().contains(ii)) continue;
                partialGraph.addEdge(i, ii);
            }
        }
        return partialGraph;
    }

    @Override
    public UndirectedGraph getPartialGraph(T grid, Model model, int[] cells, SetType setType) {
        return this.getPartialGraph(grid, model, cells, setType, setType);
    }
}

