/*
 * Decompiled with CFR 0.152.
 */
package org.restopt.choco;

import java.util.Arrays;
import java.util.stream.IntStream;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class ConnectivityFinderSpatialGraph {
    private final int n;
    private final UndirectedGraph g;
    private int[] CCFirstNode;
    private int[] CCNextNode;
    private int[] nodeCC;
    private final int[] p;
    private final int[] fifo;
    private int[] sizeCC;
    private int[] attributeCC;
    private final int[] attributeCell;
    private final int[][] neighs;
    private int nbCC;
    private int sizeMinCC;
    private int sizeMaxCC;

    public ConnectivityFinderSpatialGraph(UndirectedGraph g, UndirectedGraph GUB) {
        this(g, GUB, IntStream.range(0, g.getNbMaxNodes()).map(i -> 1).toArray());
    }

    public ConnectivityFinderSpatialGraph(UndirectedGraph g) {
        this(g, g, IntStream.range(0, g.getNbMaxNodes()).map(i -> 1).toArray());
    }

    public ConnectivityFinderSpatialGraph(UndirectedGraph g, int[] attributeCell) {
        this(g, g, attributeCell);
    }

    public ConnectivityFinderSpatialGraph(UndirectedGraph g, UndirectedGraph GUB, int[] attributeCell) {
        this.g = g;
        this.n = g.getNbMaxNodes();
        this.p = new int[this.n];
        this.fifo = new int[this.n];
        this.attributeCell = attributeCell;
        this.neighs = new int[this.n][];
        ISetIterator iSetIterator = GUB.getNodes().iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            this.neighs[i] = GUB.getNeighborsOf(i).toArray();
        }
        this.CCFirstNode = new int[this.n];
        this.CCNextNode = new int[this.n];
        this.nodeCC = new int[this.n];
        this.sizeCC = new int[this.n];
        this.attributeCC = new int[this.n];
    }

    public int getNBCC() {
        return this.nbCC;
    }

    public int getSizeMinCC() {
        return this.sizeMinCC;
    }

    public int getSizeMaxCC() {
        return this.sizeMaxCC;
    }

    public int[] getSizeCC() {
        return this.sizeCC;
    }

    public int[] getAttributeCC() {
        return this.attributeCC;
    }

    public int[] getCCFirstNode() {
        return this.CCFirstNode;
    }

    public int[] getCCNextNode() {
        return this.CCNextNode;
    }

    public int[] getNodeCC() {
        return this.nodeCC;
    }

    public void findAllCC() {
        this.sizeMinCC = 0;
        this.sizeMaxCC = 0;
        ISetIterator iSetIterator = this.g.getNodes().iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            this.p[i] = -1;
        }
        int i = this.CCFirstNode.length;
        while (--i >= 0) {
            this.CCFirstNode[i] = -1;
            this.sizeCC[i] = -1;
            this.attributeCC[i] = -1;
        }
        int cc = 0;
        ISetIterator iSetIterator2 = this.g.getNodes().iterator();
        while (iSetIterator2.hasNext()) {
            int i2 = (Integer)iSetIterator2.next();
            if (this.p[i2] != -1) continue;
            this.findCC(i2, cc);
            if (this.sizeMinCC == 0 || this.sizeMinCC > this.sizeCC[cc]) {
                this.sizeMinCC = this.sizeCC[cc];
            }
            if (this.sizeMaxCC < this.sizeCC[cc]) {
                this.sizeMaxCC = this.sizeCC[cc];
            }
            ++cc;
        }
        this.nbCC = cc;
    }

    private void findCC(int start, int cc) {
        int first = 0;
        int last = 0;
        int size = 1;
        int attribute = this.attributeCell[start];
        this.fifo[last++] = start;
        this.p[start] = start;
        this.add(start, cc);
        while (first < last) {
            int i = this.fifo[first++];
            for (int j : this.neighs[i]) {
                if (this.p[j] != -1) continue;
                this.p[j] = i;
                this.add(j, cc);
                ++size;
                attribute += this.attributeCell[j];
                this.fifo[last++] = j;
            }
        }
        this.attributeCC[cc] = attribute;
        this.sizeCC[cc] = size;
    }

    private void add(int node, int cc) {
        this.nodeCC[node] = cc;
        this.CCNextNode[node] = this.CCFirstNode[cc];
        this.CCFirstNode[cc] = node;
    }

    public int[] getCC(int ccIndex) {
        int[] cc = new int[this.sizeCC[ccIndex]];
        int j = 0;
        int i = this.getCCFirstNode()[ccIndex];
        while (i != -1) {
            cc[j++] = i;
            i = this.getCCNextNode()[i];
        }
        return cc;
    }

    public int[] getCC(int ccIndex, ISet exclude) {
        int[] cc = new int[this.getSizeCC()[ccIndex]];
        int excluded = 0;
        int j = 0;
        int i = this.getCCFirstNode()[ccIndex];
        while (i != -1) {
            if (!exclude.contains(i)) {
                cc[j++] = i;
            } else {
                ++excluded;
            }
            i = this.getCCNextNode()[i];
        }
        return Arrays.copyOfRange(cc, 0, cc.length - excluded);
    }
}

