/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.restart;

import org.chocosolver.solver.search.restart.GeometricalCutoff;

public final class InnerOuterCutoff
extends GeometricalCutoff {
    private final double outerFactor;
    private double outerFactorPower;

    public InnerOuterCutoff(long s, double gi, double go) throws IllegalArgumentException {
        super(s, gi);
        this.outerFactor = go;
        this.outerFactorPower = 1.0;
    }

    @Override
    public long getNextCutoff() {
        long outer;
        long inner = (long)Math.floor((double)this.scaleFactor * this.geometricalFactorPower) * (long)this.grower.getAsInt();
        if (inner >= (outer = (long)Math.floor((double)this.scaleFactor * this.outerFactorPower) * (long)this.grower.getAsInt())) {
            this.outerFactorPower *= this.outerFactor;
            this.geometricalFactorPower = 1.0;
        } else {
            this.geometricalFactorPower *= this.geometricalFactor;
        }
        return inner;
    }

    @Override
    public void reset() {
        super.reset();
        this.outerFactorPower = 1.0;
    }

    @Override
    public String toString() {
        return "INNEROUTER(s=" + this.scaleFactor + ", g=" + this.geometricalFactor + ')';
    }
}

