/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.reification;

import org.chocosolver.sat.Reason;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Explained;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

@Explained
public class PropXneCHalfReif
extends Propagator<IntVar> {
    private final IntVar x;
    private final int c;
    private final BoolVar b;

    public PropXneCHalfReif(IntVar x, int c, BoolVar b) {
        super((Variable[])new IntVar[]{x, b}, (Priority)PropagatorPriority.LINEAR, false, false);
        this.x = x;
        this.c = c;
        this.b = b;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx < 1) {
            return IntEventType.INSTANTIATE.getMask();
        }
        return IntEventType.INCLOW.getMask();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.b.isInstantiatedTo(0)) {
            this.setPassive();
        } else if (this.b.isInstantiatedTo(1)) {
            if (this.x.removeValue(this.c, this, this.lcg() ? Reason.r(this.b.getValLit()) : Reason.undef())) {
                this.setPassive();
            }
        } else if (this.x.isInstantiatedTo(this.c)) {
            this.b.setToFalse(this, this.lcg() ? Reason.r(this.x.getValLit()) : Reason.undef());
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            if (this.b.isInstantiatedTo(1)) {
                return ESat.eval(this.x.getValue() != this.c);
            }
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

