/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.real;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;

public class PropMixedElement
extends Propagator<Variable> {
    RealVar x;
    IntVar y;
    protected double[] values;

    public PropMixedElement(RealVar v0, IntVar v1, double[] values) {
        super(new Variable[]{v0, v1}, (Priority)PropagatorPriority.BINARY, false);
        this.x = v0;
        this.y = v1;
        this.values = values;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            this.y.updateLowerBound(0, (ICause)this);
            this.y.updateUpperBound(this.values.length - 1, (ICause)this);
        }
        this.updateIInf();
        this.updateISup();
        this.updateReal();
    }

    public void updateIInf() throws ContradictionException {
        int inf;
        for (inf = this.y.getLB(); inf < this.values.length && this.values[inf] < this.x.getLB(); ++inf) {
        }
        this.y.updateLowerBound(inf, (ICause)this);
    }

    public void updateISup() throws ContradictionException {
        int sup;
        for (sup = this.y.getUB(); sup >= 0 && this.values[sup] > this.x.getUB(); --sup) {
        }
        this.y.updateUpperBound(sup, (ICause)this);
    }

    public void updateReal() throws ContradictionException {
        this.x.intersect(this.values[this.y.getLB()], this.values[this.y.getUB()], this);
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            int idx = this.y.getValue();
            if (idx < 0 || idx >= this.values.length) {
                return ESat.FALSE;
            }
            return ESat.eval((idx == 0 || this.values[idx - 1] < this.x.getLB()) && this.x.getLB() <= this.values[idx] && this.values[idx] <= this.x.getUB() && (idx == this.values.length - 1 || this.x.getUB() < this.values[idx + 1]));
        }
        return ESat.UNDEFINED;
    }
}

