/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.basic;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.DirectedGraphVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IGraphDeltaMonitor;
import org.chocosolver.solver.variables.events.GraphEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.procedure.PairProcedure;

public class PropSymmetric
extends Propagator<DirectedGraphVar> {
    private final DirectedGraphVar g;
    private final IGraphDeltaMonitor gdm;
    private final PairProcedure enf;

    public PropSymmetric(DirectedGraphVar graph) {
        super((Variable[])new DirectedGraphVar[]{graph}, (Priority)PropagatorPriority.UNARY, true);
        this.g = graph;
        this.gdm = this.g.monitorDelta(this);
        this.enf = (from, to) -> {
            if (from != to) {
                this.g.enforceEdge(to, from, this);
            }
        };
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        ISet ker = this.g.getMandatoryNodes();
        ISetIterator iSetIterator = ker.iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            ISet succ = this.g.getMandatorySuccessorsOf(i);
            ISetIterator iSetIterator2 = succ.iterator();
            while (iSetIterator2.hasNext()) {
                int j = (Integer)iSetIterator2.next();
                this.g.enforceEdge(j, i, this);
            }
        }
        this.gdm.startMonitoring();
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.gdm.forEachEdge(this.enf, GraphEventType.ADD_EDGE);
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return GraphEventType.ADD_EDGE.getMask();
    }

    @Override
    public ESat isEntailed() {
        ISet ker = this.g.getMandatoryNodes();
        ISetIterator iSetIterator = ker.iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            ISet succ = this.g.getMandatorySuccessorsOf(i);
            ISetIterator iSetIterator2 = succ.iterator();
            while (iSetIterator2.hasNext()) {
                int j = (Integer)iSetIterator2.next();
                if (this.g.getPotentialSuccessorsOf(j).contains(i)) continue;
                return ESat.FALSE;
            }
        }
        if (this.g.isInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

