% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/status.R
\name{status}
\alias{status}
\title{Report inconsistencies between lockfile, library, and dependencies}
\usage{
status(
  project = NULL,
  ...,
  library = NULL,
  lockfile = NULL,
  sources = TRUE,
  cache = FALSE,
  dev = FALSE
)
}
\arguments{
\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}

\item{...}{Unused arguments, reserved for future expansion. If any arguments
are matched to \code{...}, renv will signal an error.}

\item{library}{The library paths. By default, the library paths associated
with the requested project are used.}

\item{lockfile}{Path to a lockfile. When \code{NULL} (the default), the
\code{renv.lock} located in the root of the current project will be used.}

\item{sources}{Boolean; check that each of the recorded packages have a
known installation source? If a package has an unknown source, renv
may be unable to restore it.}

\item{cache}{Boolean; perform diagnostics on the global package cache?
When \code{TRUE}, renv will validate that the packages installed into the
cache are installed at the expected + proper locations, and validate the
hashes used for those storage locations.}

\item{dev}{Boolean; include development dependencies? These packages are
typically required when developing the project, but not when running it
(i.e. you want them installed when humans are working on the project but
not when computers are deploying it).

Development dependencies include packages listed in the \code{Suggests} field
of a \code{DESCRIPTION} found in the project root, and roxygen2 or devtools if
their use is implied by other project metadata. They also include packages
used in \verb{~/.Rprofile} if \code{config$user.profile()} is \code{TRUE}.}
}
\value{
This function is normally called for its side effects, but
it invisibly returns a list containing the following components:
\itemize{
\item \code{library}: packages in your library.
\item \code{lockfile}: packages in the lockfile.
\item \code{synchronized}: are the library and lockfile in sync?
}
}
\description{
\code{renv::status()} reports issues caused by inconsistencies across the project
lockfile, library, and \code{\link[=dependencies]{dependencies()}}. In general, you should strive to
ensure that \code{status()} reports no issues, as this maximizes your chances of
successfully \code{restore()}ing the project in the future or on another machine.

\code{renv::load()} will report if any issues are detected when starting an
renv project; we recommend resolving these issues before doing any
further work on your project.

See the headings below for specific advice on resolving any issues
revealed by \code{status()}.
}
\section{Missing packages}{
\code{status()} first checks that all packages used by the project are installed.
This must be done first because if any packages are missing we can't tell for
sure that a package isn't used; it might be a dependency that we don't know
about. Once you have resolve any installation issues, you'll need to run
\code{status()} again to reveal the next set of potential problems.

There are four possibilities for an uninstalled package:
\itemize{
\item If it's used and recorded, call \code{renv::restore()} to install the version
specified in the lockfile.
\item If it's used and not recorded, call \code{renv::install()} to install it
from CRAN or elsewhere.
\item If it's not used and recorded, call \code{renv::snapshot()} to
remove it from the lockfile.
\item If it's not used and not recorded, there's nothing to do. This the most
common state because you only use a small fraction of all available
packages in any one project.
}

If you have multiple packages in an inconsistent state, we recommend
\code{renv::restore()}, then \code{renv::install()}, then \code{renv::snapshot()}, but
that also suggests you should be running status more frequently.
}

\section{Lockfile vs \code{dependencies()}}{
Next we need to ensure that packages are recorded in the lockfile if and
only if they are used by the project. Fixing issues of this nature only
requires calling  \code{snapshot()} because there are four possibilities for
a package:
\itemize{
\item If it's used and recorded, it's ok.
\item If it's used and not recorded, call \code{renv::snapshot()} to add it to the
lockfile.
\item If it's not used but is recorded, call \code{renv::snapshot()} to remove
it from the lockfile.
\item If it's not used and not recorded, it's also ok, as it may be a
development dependency.
}
}

\section{Out-of-sync sources}{
The final issue to resolve is any inconsistencies between the version of
the package recorded in the lockfile and the version installed in your
library. To fix these issues you'll need to either call \code{renv::restore()}
or \code{renv::snapshot()}:
\itemize{
\item Call \code{renv::snapshot()} if your project code is working. This implies that
the library is correct and you need to update your lockfile.
\item Call \code{renv::restore()} if your project code isn't working. This probably
implies that you have the wrong package versions installed and you need
to restore from known good state in the lockfile.
}

If you're not sure which case applies, it's generally safer to call
\code{renv::snapshot()}. If you want to rollback to an earlier known good
status, see \code{\link[=history]{history()}} and \code{\link[=revert]{revert()}}.
}

\section{Different R Version}{
renv will also notify you if the version of R used when the lockfile was
generated, and the version of R currently in use, do not match. In this
scenario, you'll need to consider:
\itemize{
\item Is the version of R recorded in the lockfile correct? If so, you'll want
to ensure that version of R is installed and used when working in this
project.
\item Otherwise, you can call \code{renv::snapshot()} to update the version of R
recorded in the lockfile, to match the version of R currently in use.
}

If you'd like to set the version of R recorded in a lockfile independently
of the version of R currently in use, you can set the \code{r.version} project
setting -- see \link{settings} for more details.
}

\examples{

\dontrun{

# disable automatic snapshots
auto.snapshot <- getOption("renv.config.auto.snapshot")
options(renv.config.auto.snapshot = FALSE)

# initialize a new project (with an empty R library)
renv::init(bare = TRUE)

# install digest 0.6.19
renv::install("digest@0.6.19")

# save library state to lockfile
renv::snapshot()

# remove digest from library
renv::remove("digest")

# check library status
renv::status()

# restore lockfile, thereby reinstalling digest 0.6.19
renv::restore()

# restore automatic snapshots
options(renv.config.auto.snapshot = auto.snapshot)

}
}
