% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consent.R
\name{consent}
\alias{consent}
\title{Consent to usage of renv}
\usage{
consent(provided = FALSE)
}
\arguments{
\item{provided}{The default provided response. If you need to provide
consent from a non-interactive \R session, you can invoke
\code{renv::consent(provided = TRUE)} explicitly.}
}
\value{
\code{TRUE} if consent is provided, or an \R error otherwise.
}
\description{
Provide consent to renv, allowing it to write and update certain files
on your filesystem.
}
\details{
As part of its normal operation, renv will write and update some files
in your project directory, as well as an application-specific cache
directory. These paths are documented within \link{paths}.

In accordance with the
\href{https://cran.r-project.org/web/packages/policies.html}{CRAN Repository Policy},
renv must first obtain consent from you, the user, before these actions
can be taken. Please call \code{renv::consent()} first to provide this consent.

You can also set the \R option:

\if{html}{\out{<div class="sourceCode">}}\preformatted{options(renv.consent = TRUE)
}\if{html}{\out{</div>}}

to implicitly provide consent for e.g. non-interactive \R sessions.
}
