## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(lepidochroma)

## ----palette_example----------------------------------------------------------
lepidochroma("parthenos")

## ----lepidochroma_palettes----------------------------------------------------
lepidochroma_palettes()

## ----display_all, fig.dim = c(6, 6)-------------------------------------------
lepidochroma_display()

## ----display_continuous, fig.dim = c(6, 5)------------------------------------
lepidochroma_display(type = "continuous", colourblind_only = TRUE)

## ----display_one, fig.dim = c(6, 3)-------------------------------------------
lepidochroma_display("morpho", n = 100)

## ----discrete_plot, fig.dim = c(6, 6)-----------------------------------------
inachis <- lepidochroma("inachis")

plot_colours <- inachis[c(3, 4, 5)]
plot(
  Petal.Length ~ Petal.Width, data = iris,
  col = plot_colours[iris$Species], pch = 20,
  main = "Inachis"
)

## ----continuous_plot, fig.dim = c(6, 6)---------------------------------------
image(volcano, col = lepidochroma("battus", n = 100), axes = FALSE)
title("Battus")

