/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class AssocRuleMining {
    protected int MAX_NUM_RULES = 10000;
    protected RuleNode startRulelist = null;
    protected short[][] dataArray = null;
    protected int[][] conversionArray = null;
    protected short[] reconversionArray = null;
    protected String[] outputSchema = null;
    protected static final double MIN_SUPPORT = 0.0;
    protected static final double MAX_SUPPORT = 100.0;
    protected static final double MIN_CONFIDENCE = 0.0;
    protected static final double MAX_CONFIDENCE = 100.0;
    protected String fileName = null;
    protected String outputFileName = null;
    protected String testSetFileName = null;
    protected int numCols = 0;
    protected int numRows = 0;
    protected double support = 20.0;
    protected double minSupport = 0.0;
    protected double confidence = 80.0;
    protected int numOneItemSets = 0;
    protected int numFrequentSets = 0;
    protected int numRules = 0;
    protected int numClasses = 0;
    private int numRowsInOutputSchema = 0;
    protected boolean errorFlag = true;
    protected boolean inputFormatOkFlag = true;
    protected boolean haveDataFlag = false;
    protected boolean isOrderedFlag = false;
    protected boolean isPrunedFlag = false;
    protected boolean hasOutputSchemaFlag = false;
    protected boolean supConfFworkFlag = false;
    protected boolean supLiftFworkFlag = false;
    protected boolean outputRuleSetToFileFlag = false;
    protected BufferedReader fileInput;
    private PrintWriter fileOutput;
    protected File filePath = null;

    public AssocRuleMining(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.idArgument(stringArray[i]);
        }
        if (this.errorFlag) {
            this.CheckInputArguments();
        } else {
            this.outputMenu();
        }
    }

    public AssocRuleMining(AssocRuleMining assocRuleMining) {
        this.outputSchema = assocRuleMining.outputSchema;
    }

    public AssocRuleMining() {
    }

    protected void idArgument(String string) {
        if (string.length() < 3) {
            JOptionPane.showMessageDialog(null, "Command line argument \"" + string + "\" too short.", "COMMAND LINE INPUT ERROR", 0);
            this.errorFlag = false;
        } else if (string.charAt(0) == '-') {
            char c = string.charAt(1);
            string = string.substring(2, string.length());
            switch (c) {
                case 'C': {
                    this.confidence = Double.parseDouble(string);
                    break;
                }
                case 'F': {
                    this.fileName = string;
                    break;
                }
                case 'N': {
                    this.numClasses = Integer.parseInt(string);
                    break;
                }
                case 'O': {
                    this.outputFileName = string;
                    break;
                }
                case 'S': {
                    this.support = Double.parseDouble(string);
                    break;
                }
                default: {
                    JOptionPane.showMessageDialog(null, "Unrecognise command line  argument: \"" + c + string + "\"'.", "COMMAND LINE INPUT ERROR", 0);
                    this.errorFlag = false;
                    break;
                }
            }
        } else {
            JOptionPane.showMessageDialog(null, "All command line arguments must commence with a '-' character ('" + string + "')", "COMMAND LINE INPUT ERROR", 0);
            this.errorFlag = false;
        }
    }

    protected void CheckInputArguments() {
        this.checkSupportAndConfidence();
        this.checkFileName();
        if (this.errorFlag) {
            this.outputSettings();
        } else {
            this.outputMenu();
        }
    }

    protected void checkSupportAndConfidence() {
        if (this.support < 0.0 || this.support > 100.0) {
            JOptionPane.showMessageDialog(null, "Support must be specified as a percentage (0.0 - 100.0)", "INPUT ERROR", 0);
            this.errorFlag = false;
        }
        if (this.confidence < 0.0 || this.confidence > 100.0) {
            JOptionPane.showMessageDialog(null, "Confidence must be specified as a percentage (0.0 - 100.0)", "INPUT ERROR", 0);
            this.errorFlag = false;
        }
    }

    protected void checkFileName() {
        if (this.fileName == null) {
            JOptionPane.showMessageDialog(null, "Must specify file name (-F)", "COMMAND LINE INPUT ERROR", 0);
            this.errorFlag = false;
        }
    }

    public void inputDataSet() {
        this.readFile();
        if (this.inputFormatOkFlag) {
            if (this.checkOrdering()) {
                System.out.println("Number of records = " + this.numRows);
                this.countNumCols();
                System.out.println("Number of columns = " + this.numCols);
                this.minSupport = (double)this.numRows * this.support / 100.0;
                System.out.println("Min support       = " + this.twoDecPlaces(this.minSupport) + " (records)");
            } else {
                JOptionPane.showMessageDialog(null, "Unknown error reading file: " + this.fileName + "\n", "FILE INPUT ERROR", 0);
                this.closeFile();
                System.exit(1);
            }
        }
    }

    protected void readFile() {
        try {
            this.inputFormatOkFlag = true;
            this.numRows = this.getNumberOfLines(this.fileName);
            if (this.inputFormatOkFlag) {
                this.dataArray = new short[this.numRows][];
                System.out.println("Reading input file: " + this.fileName);
                this.readInputDataSet();
            } else {
                JOptionPane.showMessageDialog(null, "Error reading file: " + this.fileName + "\n", "FILE INPUT ERROR", 0);
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Unknown error reading file: " + this.fileName + "\n", "FILE INPUT ERROR", 0);
            this.closeFile();
            System.exit(1);
        }
    }

    protected int getNumberOfLines(String string) throws IOException {
        int n = 0;
        if (this.filePath == null) {
            this.openFileName(string);
        } else {
            this.openFilePath();
        }
        String string2 = this.fileInput.readLine();
        while (string2 != null) {
            this.checkLine(n + 1, string2);
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            int n2 = stringTokenizer.countTokens();
            if (n2 == 0) break;
            ++n;
            string2 = this.fileInput.readLine();
        }
        this.closeFile();
        return n;
    }

    protected void checkLine(int n, String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i)) || Character.isWhitespace(string.charAt(i))) continue;
            JOptionPane.showMessageDialog(null, "Character on line " + n + " is not a digit or white space", "FILE INPUT ERROR", 0);
            this.inputFormatOkFlag = false;
            this.haveDataFlag = false;
            break;
        }
    }

    public void readInputDataSet() throws IOException {
        this.readInputDataSet(this.fileName);
    }

    protected void readInputDataSet(String string) throws IOException {
        int n = 0;
        if (this.filePath == null) {
            this.openFileName(string);
        } else {
            this.openFilePath();
        }
        String string2 = this.fileInput.readLine();
        while (string2 != null && this.processInputLine(string2, n)) {
            ++n;
            string2 = this.fileInput.readLine();
        }
        this.closeFile();
    }

    protected void readInputDataSetSeg(String string, int n, int n2) throws IOException {
        int n3 = n;
        if (this.filePath == null) {
            this.openFileName(string);
        } else {
            this.openFilePath();
        }
        String string2 = this.fileInput.readLine();
        for (int i = n; i < n2; ++i) {
            this.processInputLine(string2, i);
            string2 = this.fileInput.readLine();
        }
        this.closeFile();
    }

    protected boolean processInputLine(String string, int n) {
        if (string == null) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n2 = stringTokenizer.countTokens();
        if (n2 == 0) {
            return false;
        }
        short[] sArray = this.binConversion(stringTokenizer, n2);
        int n3 = sArray.length;
        this.dataArray[n] = new short[n3];
        for (int i = 0; i < n3; ++i) {
            this.dataArray[n][i] = sArray[i];
        }
        return true;
    }

    protected boolean checkOrdering() {
        boolean bl = true;
        for (int i = 0; i < this.dataArray.length; ++i) {
            if (this.checkLineOrdering(i + 1, this.dataArray[i])) continue;
            this.haveDataFlag = false;
            bl = false;
        }
        return bl;
    }

    protected boolean checkLineOrdering(int n, short[] sArray) {
        for (int i = 0; i < sArray.length - 1; ++i) {
            if (sArray[i] < sArray[i + 1]) continue;
            JOptionPane.showMessageDialog(null, "Attribute data in line " + n + " not in numeric order", "FILE INPUT ERROR", 0);
            return false;
        }
        return true;
    }

    protected void countNumCols() {
        int n = 0;
        for (int i = 0; i < this.dataArray.length; ++i) {
            int n2 = this.dataArray[i].length - 1;
            if (this.dataArray[i][n2] <= n) continue;
            n = this.dataArray[i][n2];
        }
        this.numOneItemSets = this.numCols = n;
    }

    protected void openFileName(String string) {
        try {
            FileReader fileReader = new FileReader(string);
            this.fileInput = new BufferedReader(fileReader);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Error Opening File \"" + string + "\"", "FILE INPUT ERROR", 0);
            System.exit(1);
        }
    }

    protected void openFilePath() {
        try {
            FileReader fileReader = new FileReader(this.filePath);
            this.fileInput = new BufferedReader(fileReader);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Error Opening File \"" + this.filePath + "\"", "FILE INPUT ERROR", 0);
            System.exit(1);
        }
    }

    protected void closeFile() {
        if (this.fileInput != null) {
            try {
                this.fileInput.close();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(null, "Error Closeing File", "FILE ERROR", 0);
                System.exit(1);
            }
        }
    }

    protected short[] binConversion(StringTokenizer stringTokenizer, int n) {
        short[] sArray = null;
        for (int i = 0; i < n; ++i) {
            short s = new Short(stringTokenizer.nextToken());
            sArray = this.realloc1(sArray, s);
        }
        return sArray;
    }

    public void inputOutputSchema(JTextArea jTextArea, File file) {
        this.filePath = file;
        try {
            this.numRowsInOutputSchema = this.getNumLinesInOutputSchema(null);
            jTextArea.append("Number of lines (attributes) in output schema file = " + this.numRowsInOutputSchema + "\n");
            this.outputSchema = new String[this.numRowsInOutputSchema];
            this.readOutputSchema();
            this.hasOutputSchemaFlag = true;
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Error reading File", "FILE INPUT ERROR", 0);
            jTextArea.append("Error reading File\n");
            this.closeFile();
            this.hasOutputSchemaFlag = false;
        }
    }

    protected int getNumLinesInOutputSchema(String string) throws IOException {
        int n = 0;
        if (this.filePath == null) {
            this.openFileName(string);
        } else {
            this.openFilePath();
        }
        String string2 = this.fileInput.readLine();
        while (string2 != null) {
            ++n;
            string2 = this.fileInput.readLine();
        }
        this.closeFile();
        return n;
    }

    public void readOutputSchema() throws IOException {
        this.readOutputSchema(this.fileName);
    }

    protected void readOutputSchema(String string) throws IOException {
        int n = 0;
        if (this.filePath == null) {
            this.openFileName(string);
        } else {
            this.openFilePath();
        }
        String string2 = this.fileInput.readLine();
        while (string2 != null) {
            this.outputSchema[n] = string2;
            ++n;
            string2 = this.fileInput.readLine();
        }
        this.closeFile();
    }

    public boolean checkSchemaVdata() {
        boolean bl = true;
        if (this.outputSchema == null) {
            JOptionPane.showMessageDialog(null, "No output schema file.", "CHECK SCHEMA v DATA ATTRIBUTES ERROR", 0);
            return !bl;
        }
        if (this.dataArray == null) {
            JOptionPane.showMessageDialog(null, "No input data file.", "CHECK SCHEMA v DATA ATTRIBUTES ERROR", 0);
            return !bl;
        }
        if (this.outputSchema.length == this.numCols) {
            return bl;
        }
        JOptionPane.showMessageDialog(null, "Number of attributes in schema file (" + this.outputSchema.length + ") not\nsame as number of attributes in data file (" + this.numCols + ")\n", "CHECK SCHEMA v DATA ATTRIBUTES ERROR", 0);
        return !bl;
    }

    public void inputDataSet(JTextArea jTextArea, File file) {
        this.filePath = file;
        this.readFile(jTextArea);
        if (this.inputFormatOkFlag) {
            if (this.checkOrdering()) {
                jTextArea.append("Number of records = " + this.numRows + "\n");
                this.countNumCols();
                jTextArea.append("Number of columns = " + this.numCols + "\n");
                this.haveDataFlag = true;
            } else {
                this.haveDataFlag = false;
                this.inputFormatOkFlag = true;
                jTextArea.append("Error reading file: " + this.filePath + "\n\n");
            }
        }
    }

    public void readFile(JTextArea jTextArea) {
        try {
            this.inputFormatOkFlag = true;
            this.numRows = this.getNumberOfLines(this.fileName);
            if (this.inputFormatOkFlag) {
                this.dataArray = new short[this.numRows][];
                jTextArea.append("Reading input file:\n" + this.filePath + "\n");
                this.readInputDataSet();
                this.haveDataFlag = true;
            } else {
                this.haveDataFlag = false;
                jTextArea.append("Error reading file:\n" + this.filePath + "\n\n");
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Error reading File", "FILE INPUT ERROR", 0);
            jTextArea.append("Error reading File\n");
            this.closeFile();
            this.haveDataFlag = false;
        }
    }

    public void idInputDataOrdering() {
        int[][] nArray = this.countSingles();
        this.orderCountArray(nArray);
        this.defConvertArrays(nArray);
        this.isOrderedFlag = true;
    }

    protected int[][] countSingles() {
        int n;
        int[][] nArray = new int[this.numCols + 1][2];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n][0] = n;
            nArray[n][1] = 0;
        }
        for (n = 0; n < this.dataArray.length; ++n) {
            if (this.dataArray[n] == null) continue;
            for (int i = 0; i < this.dataArray[n].length; ++i) {
                int[] nArray2 = nArray[this.dataArray[n][i]];
                nArray2[1] = nArray2[1] + 1;
            }
        }
        return nArray;
    }

    private void orderCountArray(int[][] nArray) {
        boolean bl;
        do {
            bl = true;
            int n = 1;
            while (n < nArray.length - 1) {
                if (nArray[n][1] >= nArray[n + 1][1]) {
                    ++n;
                    continue;
                }
                bl = false;
                int n2 = nArray[n][0];
                int n3 = nArray[n][1];
                nArray[n][0] = nArray[n + 1][0];
                nArray[n][1] = nArray[n + 1][1];
                nArray[n + 1][0] = n2;
                nArray[n + 1][1] = n3;
                ++n;
            }
        } while (!bl);
    }

    protected void orderFirstNofCountArray(int[][] nArray, int n) {
        boolean bl;
        do {
            bl = true;
            int n2 = 1;
            while (n2 < n) {
                if (nArray[n2][1] >= nArray[n2 + 1][1]) {
                    ++n2;
                    continue;
                }
                bl = false;
                int n3 = nArray[n2][0];
                int n4 = nArray[n2][1];
                nArray[n2][0] = nArray[n2 + 1][0];
                nArray[n2][1] = nArray[n2 + 1][1];
                nArray[n2 + 1][0] = n3;
                nArray[n2 + 1][1] = n4;
                ++n2;
            }
        } while (!bl);
    }

    protected void defConvertArrays(int[][] nArray) {
        this.conversionArray = new int[this.numCols + 1][2];
        this.reconversionArray = new short[this.numCols + 1];
        for (int i = 1; i < nArray.length; ++i) {
            this.conversionArray[nArray[i][0]][0] = i;
            this.conversionArray[nArray[i][0]][1] = nArray[i][1];
            this.reconversionArray[i] = (short)nArray[i][0];
        }
    }

    protected void defConvertArrays(int[][] nArray, int n) {
        int n2;
        this.conversionArray = new int[this.numCols + 1][2];
        this.reconversionArray = new short[this.numCols + 1];
        for (n2 = 1; n2 <= n; ++n2) {
            this.conversionArray[nArray[n2][0]][0] = n2;
            this.conversionArray[nArray[n2][0]][1] = nArray[n2][1];
            this.reconversionArray[n2] = (short)nArray[n2][0];
        }
        for (n2 = n + 1; n2 < nArray.length; ++n2) {
            this.conversionArray[nArray[n2][0]][0] = n2;
            this.conversionArray[nArray[n2][0]][1] = nArray[n2][1];
            this.reconversionArray[n2] = (short)n2;
        }
    }

    public void recastInputData() {
        for (int i = 0; i < this.dataArray.length; ++i) {
            short[] sArray = new short[this.dataArray[i].length];
            for (int j = 0; j < this.dataArray[i].length; ++j) {
                short s = this.dataArray[i][j];
                sArray[j] = (short)this.conversionArray[s][0];
            }
            this.sortItemSet(sArray);
            this.dataArray[i] = sArray;
        }
    }

    public void recastInputDataAndPruneUnsupportedAtts() {
        for (int i = 0; i < this.dataArray.length; ++i) {
            if (this.dataArray[i] == null) continue;
            short[] sArray = null;
            for (int j = 0; j < this.dataArray[i].length; ++j) {
                short s = this.dataArray[i][j];
                if (!((double)this.conversionArray[s][1] >= this.minSupport)) continue;
                sArray = this.reallocInsert(sArray, (short)this.conversionArray[s][0]);
            }
            this.dataArray[i] = sArray;
        }
        this.isPrunedFlag = true;
        this.numOneItemSets = this.getNumSupOneItemSets();
    }

    protected int getNumSupOneItemSets() {
        int n = 0;
        for (int i = 1; i < this.conversionArray.length; ++i) {
            if (!((double)this.conversionArray[i][1] >= this.minSupport)) continue;
            ++n;
        }
        return n;
    }

    public void resizeInputData(double d) {
        this.numRows = (int)((double)this.numRows * (d / 100.0));
        System.out.println("Recast input data, new num rows = " + this.numRows);
        short[][] sArrayArray = new short[this.numRows][];
        for (int i = 0; i < this.numRows; ++i) {
            sArrayArray[i] = this.dataArray[i];
        }
        this.dataArray = sArrayArray;
        this.minSupport = (double)this.numRows * this.support / 100.0;
    }

    protected short[] reconvertItemSet(short[] sArray) {
        if (this.reconversionArray == null) {
            return sArray;
        }
        if (sArray == null) {
            return null;
        }
        short[] sArray2 = new short[sArray.length];
        for (int i = 0; i < sArray2.length; ++i) {
            sArray2[i] = this.reconversionArray[sArray[i]];
        }
        return sArray2;
    }

    protected short reconvertItem(short s) {
        if (this.reconversionArray == null) {
            return s;
        }
        return this.reconversionArray[s];
    }

    public void horizontal2vertical() {
        int[] nArray = new int[this.numCols + 1];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 0;
        }
        short[][] sArray = this.h2vDimNewDataArry();
        for (int i = 0; i < this.dataArray.length; ++i) {
            if (this.dataArray[i] == null) continue;
            for (int j = 0; j < this.dataArray[i].length; ++j) {
                int n = this.dataArray[i][j] - 1;
                int n2 = nArray[n];
                sArray[n][n2] = (short)i;
                int n3 = n;
                nArray[n3] = nArray[n3] + 1;
            }
        }
        this.dataArray = sArray;
        this.numCols = this.numRows;
        this.numRows = this.dataArray.length;
    }

    private short[][] h2vDimNewDataArry() {
        int[][] nArray = this.countSingles();
        short[][] sArrayArray = new short[nArray.length - 1][];
        for (int i = 1; i < nArray.length; ++i) {
            sArrayArray[nArray[i][0] - 1] = new short[nArray[i][1]];
        }
        return sArrayArray;
    }

    public void segmentDataSet(int n) throws IOException {
        int n2 = this.calcRowsPerSegment(n);
        int n3 = this.fileName.lastIndexOf(47);
        String string = this.fileName.substring(n3 + 1, this.fileName.length());
        this.openFileName(string);
        int n4 = 0;
        int n5 = n2;
        for (int i = 1; i < n; ++i) {
            String string2 = string + i;
            this.ouputSegmentToFile(string2, n4, n5);
            n4 = n5;
            n5 += n2;
        }
        String string3 = string + n;
        this.ouputSegmentToFile(string3, n4, this.numRows);
        this.fileInput.close();
    }

    public void readSegAndPartData(int n) throws IOException {
        String string;
        int n2;
        int n3;
        int n4 = this.calcRowsPerSegment(n);
        int n5 = this.fileName.lastIndexOf(47);
        String string2 = this.fileName.substring(n5 + 1, this.fileName.length());
        this.openFileName(string2);
        for (n3 = 1; n3 < n; ++n3) {
            this.dataArray = new short[n4][];
            for (n2 = 0; n2 < n4; ++n2) {
                string = this.fileInput.readLine();
                this.processInputLine(string, n2);
            }
            this.partitionDataArray(string2 + n3);
        }
        n3 = this.numRows - n4 * (n - 1);
        this.dataArray = new short[n3][];
        for (n2 = 0; n2 < n3; ++n2) {
            string = this.fileInput.readLine();
            this.processInputLine(string, n2);
        }
        this.partitionDataArray(string2 + n);
        this.fileInput.close();
    }

    protected void partitionDataArray(String string) throws IOException {
        for (int i = 1; i <= this.numOneItemSets; ++i) {
            this.outputPartitionToFile(string, (short)i);
        }
    }

    protected int calcRowsPerSegment(int n) {
        int n2 = this.numRows / n;
        if (n2 == 0) {
            System.out.println("DATA SEGMENTATION ERROR: number of desired segments (" + n + ") exceeds number of records (" + this.numRows + ") in input dataset");
            System.exit(1);
        }
        return n2;
    }

    protected void insertRuleIntoRulelist(short[] sArray, short[] sArray2, double d, double d2) {
        if (this.numRules > this.MAX_NUM_RULES) {
            return;
        }
        if (this.startRulelist == null) {
            this.startRulelist = new RuleNode(sArray, sArray2, d, d2);
        } else {
            this.insertRuleIntoRulelist(this.startRulelist, sArray, sArray2, d, d2);
        }
    }

    protected void insertRuleIntoRulelist(short[] sArray, short[] sArray2, double d) {
        double d2 = 0.0;
        if (this.startRulelist == null) {
            this.startRulelist = new RuleNode(sArray, sArray2, d, d2);
        } else {
            this.insertRuleIntoRulelist(this.startRulelist, sArray, sArray2, d, d2);
        }
    }

    private void insertRuleIntoRulelist(RuleNode ruleNode, short[] sArray, short[] sArray2, double d, double d2) {
        boolean bl = this.insertRuleSelector(ruleNode, sArray, d, d2);
        if (bl) {
            if (ruleNode.leftBranch == null) {
                ruleNode.leftBranch = new RuleNode(sArray, sArray2, d, d2);
            } else {
                this.insertRuleIntoRulelist(ruleNode.leftBranch, sArray, sArray2, d, d2);
            }
        } else if (ruleNode.rightBranch == null) {
            ruleNode.rightBranch = new RuleNode(sArray, sArray2, d, d2);
        } else {
            this.insertRuleIntoRulelist(ruleNode.rightBranch, sArray, sArray2, d, d2);
        }
    }

    protected boolean insertRuleSelector(RuleNode ruleNode, short[] sArray, double d, double d2) {
        boolean bl = false;
        if (d > (double)ruleNode.confidenceForRule) {
            bl = true;
        } else if (d == (double)ruleNode.confidenceForRule) {
            if (d2 > (double)ruleNode.supportForRule) {
                bl = true;
            } else if (d2 == (double)ruleNode.supportForRule && sArray.length > ruleNode.antecedent.length) {
                bl = true;
            }
        }
        return bl;
    }

    protected void numberRulesInBinTree() {
        if (this.startRulelist == null) {
            this.numRules = 0;
        } else {
            short s = 1;
            this.numRules = this.numberRulesInBinTree(s, this.startRulelist) - 1;
        }
    }

    private short numberRulesInBinTree(short s, RuleNode ruleNode) {
        if (ruleNode != null) {
            ruleNode.ruleNumber = s = this.numberRulesInBinTree(s, ruleNode.leftBranch);
            s = (short)(s + 1);
            s = this.numberRulesInBinTree(s, ruleNode.rightBranch);
        }
        return s;
    }

    protected short[] getConsequentOfRuleN(int n) {
        if (this.startRulelist == null) {
            return null;
        }
        return this.getConsequentOfRuleN(n, this.startRulelist);
    }

    public short[] getConsequentOfRuleN(int n, RuleNode ruleNode) {
        if (ruleNode.ruleNumber == n) {
            return ruleNode.consequent;
        }
        if (n < ruleNode.ruleNumber) {
            if (ruleNode.leftBranch != null) {
                return this.getConsequentOfRuleN(n, ruleNode.leftBranch);
            }
            return null;
        }
        if (ruleNode.rightBranch != null) {
            return this.getConsequentOfRuleN(n, ruleNode.rightBranch);
        }
        return null;
    }

    protected int copyFirstNrules(int n, RuleNode ruleNode) {
        if (ruleNode != null) {
            if ((n = this.copyFirstNrules(n, ruleNode.leftBranch)) == 0) {
                return n;
            }
            this.insertRuleIntoRulelist(ruleNode.antecedent, ruleNode.consequent, ruleNode.confidenceForRule, ruleNode.supportForRule);
            if (--n == 0) {
                return n;
            }
            return this.copyFirstNrules(n, ruleNode.rightBranch);
        }
        return n;
    }

    protected short[] append(short[] sArray, short[] sArray2) {
        if (sArray == null) {
            return this.copyItemSet(sArray2);
        }
        if (sArray2 == null) {
            return this.copyItemSet(sArray);
        }
        short[] sArray3 = new short[sArray.length + sArray2.length];
        for (int i = 0; i < sArray.length; ++i) {
            sArray3[i] = sArray[i];
        }
        for (int i = 0; i < sArray2.length; ++i) {
            sArray3[i + i] = sArray2[i];
        }
        return sArray3;
    }

    protected short[] reallocInsert(short[] sArray, short s) {
        if (sArray == null) {
            short[] sArray2 = new short[]{s};
            return sArray2;
        }
        int n = sArray.length;
        short[] sArray3 = new short[n + 1];
        for (int i = 0; i < n; ++i) {
            if (s < sArray[i]) {
                sArray3[i] = s;
                for (int j = i + 1; j < sArray3.length; ++j) {
                    sArray3[j] = sArray[j - 1];
                }
                return sArray3;
            }
            sArray3[i] = sArray[i];
        }
        sArray3[sArray3.length - 1] = s;
        return sArray3;
    }

    protected short[] realloc1(short[] sArray, short s) {
        if (sArray == null) {
            short[] sArray2 = new short[]{s};
            return sArray2;
        }
        int n = sArray.length;
        short[] sArray3 = new short[n + 1];
        for (int i = 0; i < n; ++i) {
            sArray3[i] = sArray[i];
        }
        sArray3[i] = s;
        return sArray3;
    }

    protected short[] realloc2(short[] sArray, short s) {
        if (sArray == null) {
            short[] sArray2 = new short[]{s};
            return sArray2;
        }
        int n = sArray.length;
        short[] sArray3 = new short[n + 1];
        sArray3[0] = s;
        for (int i = 0; i < n; ++i) {
            sArray3[i + 1] = sArray[i];
        }
        return sArray3;
    }

    protected short[] realloc3(short[] sArray) {
        if (sArray.length == 1) {
            return null;
        }
        int n = sArray.length - 1;
        short[] sArray2 = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray2[i] = sArray[i + 1];
        }
        return sArray2;
    }

    protected short[] realloc4(short[] sArray, short[] sArray2) {
        int n = sArray2.length;
        int n2 = sArray.length - n;
        short[] sArray3 = new short[n2];
        for (int i = 0; i < n2; ++i) {
            sArray3[i] = sArray[i + n];
        }
        return sArray3;
    }

    protected short[] union(short[] sArray, short[] sArray2) {
        int n;
        if (sArray == null) {
            if (sArray2 == null) {
                return null;
            }
            return sArray2;
        }
        if (sArray2 == null) {
            return sArray;
        }
        short[] sArray3 = new short[this.sizeOfUnion(sArray, sArray2)];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n2 < sArray.length) {
            if (n3 >= sArray2.length) {
                n = n2;
                while (n < sArray.length) {
                    sArray3[n4] = sArray[n];
                    ++n;
                    ++n4;
                }
                break;
            }
            if (sArray[n2] < sArray2[n3]) {
                sArray3[n4] = sArray[n2];
                ++n2;
            } else if (sArray[n2] == sArray2[n3]) {
                sArray3[n4] = sArray[n2];
                ++n2;
                ++n3;
            } else {
                sArray3[n4] = sArray2[n3];
                ++n3;
            }
            ++n4;
        }
        n = n3;
        while (n < sArray2.length) {
            sArray3[n4] = sArray2[n];
            ++n;
            ++n4;
        }
        return sArray3;
    }

    protected short[] removeElementN(short[] sArray, int n) {
        int n2;
        if (sArray.length <= n) {
            return sArray;
        }
        short[] sArray2 = new short[sArray.length - 1];
        for (n2 = 0; n2 < n; ++n2) {
            sArray2[n2] = sArray[n2];
        }
        for (n2 = n + 1; n2 < sArray.length; ++n2) {
            sArray2[n2 - 1] = sArray[n2];
        }
        return sArray2;
    }

    protected short[] removeElementX(short[] sArray, short s) {
        if (this.notMemberOf(s, sArray)) {
            return sArray;
        }
        short[] sArray2 = new short[sArray.length - 1];
        int n = 0;
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] == s) continue;
            sArray2[n] = sArray[i];
            ++n;
        }
        return sArray2;
    }

    protected short[] removeFirstElement(short[] sArray) {
        if (sArray.length == 1) {
            return null;
        }
        short[] sArray2 = new short[sArray.length - 1];
        for (int i = 0; i < sArray2.length; ++i) {
            sArray2[i] = sArray[i + 1];
        }
        return sArray2;
    }

    protected short[] removeFirstNelements(short[] sArray, int n) {
        if (sArray.length == n) {
            return null;
        }
        short[] sArray2 = new short[sArray.length - n];
        for (int i = 0; i < sArray2.length; ++i) {
            sArray2[i] = sArray[i + n];
        }
        return sArray2;
    }

    protected short[] removeLastElement(short[] sArray) {
        if (sArray.length == 1) {
            return null;
        }
        short[] sArray2 = new short[sArray.length - 1];
        for (int i = 0; i < sArray2.length; ++i) {
            sArray2[i] = sArray[i];
        }
        return sArray2;
    }

    protected short[] removeLastNelements(short[] sArray, int n) {
        if (sArray.length <= n) {
            return null;
        }
        short[] sArray2 = new short[sArray.length - n];
        for (int i = 0; i < sArray2.length; ++i) {
            sArray2[i] = sArray[i];
        }
        return sArray2;
    }

    protected short[] removeAllAfter(short[] sArray, short s) {
        int n;
        if (sArray == null) {
            return null;
        }
        for (n = 0; n < sArray.length && sArray[n] <= s; ++n) {
        }
        if (n == 0) {
            return null;
        }
        short[] sArray2 = new short[n];
        for (int i = 0; i < sArray2.length; ++i) {
            sArray2[i] = sArray[i];
        }
        return sArray2;
    }

    protected short[] returnElementsLessThanN(short[] sArray, int n) {
        int n2 = 0;
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] > n) continue;
            ++n2;
        }
        if (n2 == 0) {
            return null;
        }
        short[] sArray2 = new short[n2];
        for (int i = 0; i < n2; ++i) {
            if (sArray[i] > n) continue;
            sArray2[i] = sArray[i];
        }
        return sArray2;
    }

    protected short getLastElement(short[] sArray) {
        if (sArray == null) {
            return 0;
        }
        return sArray[sArray.length - 1];
    }

    protected short[] complement(short[] sArray, short[] sArray2) {
        int n = sArray2.length - sArray.length;
        if (n < 1) {
            return null;
        }
        short[] sArray3 = new short[n];
        int n2 = 0;
        for (int i = 0; i < sArray2.length; ++i) {
            if (!this.notMemberOf(sArray2[i], sArray)) continue;
            sArray3[n2] = sArray2[i];
            ++n2;
        }
        return sArray3;
    }

    protected void sortItemSet(short[] sArray) {
        boolean bl;
        do {
            bl = true;
            int n = 0;
            while (n < sArray.length - 1) {
                if (sArray[n] <= sArray[n + 1]) {
                    ++n;
                    continue;
                }
                bl = false;
                short s = sArray[n];
                sArray[n] = sArray[n + 1];
                sArray[n + 1] = s;
                ++n;
            }
        } while (!bl);
    }

    protected int checkItemSets(short[] sArray, short[] sArray2) {
        if (this.isEqual(sArray, sArray2)) {
            return 1;
        }
        if (AssocRuleMining.isBefore(sArray, sArray2)) {
            if (this.isSubset(sArray, sArray2)) {
                return 2;
            }
            return 3;
        }
        if (this.isSubset(sArray2, sArray)) {
            return 4;
        }
        return 5;
    }

    protected boolean isEqual(short[] sArray, short[] sArray2) {
        if (sArray2 == null) {
            return false;
        }
        int n = sArray.length;
        int n2 = sArray2.length;
        if (n != n2) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (sArray[i] == sArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isBefore(short[] sArray, short[] sArray2) {
        int n = sArray2.length;
        for (int i = 0; i < sArray.length; ++i) {
            if (i == n) {
                return false;
            }
            if (sArray[i] < sArray2[i]) {
                return true;
            }
            if (sArray[i] <= sArray2[i]) continue;
            return false;
        }
        return true;
    }

    protected boolean isSubset(short[] sArray, short[] sArray2) {
        if (sArray == null) {
            return true;
        }
        if (sArray2 == null) {
            return false;
        }
        for (int i = 0; i < sArray.length; ++i) {
            if (!this.notMemberOf(sArray[i], sArray2)) continue;
            return false;
        }
        return true;
    }

    protected boolean doesIntersect(short[] sArray, short[] sArray2) {
        if (sArray == null) {
            return false;
        }
        if (sArray2 == null) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        while (n < sArray.length && n2 < sArray2.length) {
            if (sArray[n] == sArray2[n2]) {
                return true;
            }
            if (sArray[n] < sArray2[n2]) {
                ++n;
                continue;
            }
            ++n2;
        }
        return false;
    }

    protected boolean memberOf(short s, short[] sArray) {
        if (sArray == null) {
            return false;
        }
        for (int i = 0; i < sArray.length; ++i) {
            if (s < sArray[i]) {
                return false;
            }
            if (s != sArray[i]) continue;
            return true;
        }
        return false;
    }

    protected boolean notMemberOf(short s, short[] sArray) {
        for (int i = 0; i < sArray.length; ++i) {
            if (s < sArray[i]) {
                return true;
            }
            if (s != sArray[i]) continue;
            return false;
        }
        return true;
    }

    protected short[] checkForLeadingSubString(short[] sArray, short[] sArray2) {
        short[] sArray3 = null;
        for (int i = 0; i < sArray.length && i != sArray2.length && sArray[i] == sArray2[i]; ++i) {
            sArray3 = this.realloc1(sArray3, sArray[i]);
        }
        return sArray3;
    }

    protected short[][] combinations(short[] sArray) {
        if (sArray == null) {
            return null;
        }
        short[][] sArrayArray = new short[this.getCombinations(sArray)][];
        this.combinations(sArray, 0, null, sArrayArray, 0);
        return sArrayArray;
    }

    private int combinations(short[] sArray, int n, short[] sArray2, short[][] sArray3, int n2) {
        for (int i = n; i < sArray.length; ++i) {
            short[] sArray4 = this.realloc1(sArray2, sArray[i]);
            sArray3[n2] = sArray4;
            n2 = this.combinations(sArray, i + 1, this.copyItemSet(sArray4), sArray3, n2 + 1);
        }
        return n2;
    }

    private int getCombinations(short[] sArray) {
        boolean bl = false;
        int n = (int)Math.pow(2.0, sArray.length) - 1;
        return n;
    }

    protected short[][] copyDataArray() {
        return this.copyItemSet(this.dataArray);
    }

    protected short[] copyItemSet(short[] sArray) {
        if (sArray == null) {
            return null;
        }
        short[] sArray2 = new short[sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            sArray2[i] = sArray[i];
        }
        return sArray2;
    }

    protected short[] copyItemSet(short[] sArray, int n) {
        if (sArray == null) {
            return null;
        }
        int n2 = n;
        if (n > sArray.length) {
            n2 = sArray.length;
        }
        short[] sArray2 = new short[n2];
        for (int i = 0; i < n2; ++i) {
            sArray2[i] = sArray[i];
        }
        return sArray2;
    }

    protected short[][] copyItemSet(short[][] sArray) {
        if (sArray == null) {
            return null;
        }
        short[][] sArrayArray = new short[sArray.length][];
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] == null) {
                sArrayArray[i] = null;
                continue;
            }
            sArrayArray[i] = new short[sArray[i].length];
            for (int j = 0; j < sArray[i].length; ++j) {
                sArrayArray[i][j] = sArray[i][j];
            }
        }
        return sArrayArray;
    }

    protected int sizeOfUnion(short[] sArray, short[] sArray2) {
        if (sArray == null) {
            if (sArray2 == null) {
                return 0;
            }
            return sArray2.length;
        }
        if (sArray2 == null) {
            return sArray.length;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n2 < sArray.length) {
            if (n3 >= sArray2.length) {
                n = n + sArray.length - n2;
                break;
            }
            if (sArray[n2] < sArray2[n3]) {
                ++n;
                ++n2;
                continue;
            }
            if (sArray[n2] == sArray2[n3]) {
                ++n;
                ++n2;
                ++n3;
                continue;
            }
            ++n;
            ++n3;
        }
        n = n + sArray2.length - n3;
        return n;
    }

    public double getSupport() {
        return this.support;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public int getNumClasses() {
        if (this.numClasses == 0) {
            this.calculateNumClasses();
        }
        return this.numClasses;
    }

    private void calculateNumClasses() {
        int n = this.dataArray[0].length - 1;
        short s = this.dataArray[0][n];
        short s2 = this.dataArray[0][n];
        for (int i = 1; i < this.dataArray.length; ++i) {
            n = this.dataArray[i].length - 1;
            if (this.dataArray[i][n] < s) {
                s = this.dataArray[i][n];
                continue;
            }
            if (this.dataArray[i][n] <= s2) continue;
            s2 = this.dataArray[i][n];
        }
        this.numClasses = s2 - s + 1;
    }

    public boolean getIsPrunedFlag() {
        return this.isPrunedFlag;
    }

    public int getNumberOfRows() {
        return this.numRows;
    }

    public int getNumberOfColumns() {
        return this.numCols;
    }

    public int getSizeOfFirstRecord() {
        return this.dataArray[0].length;
    }

    public int getNumOneItemSets() {
        return this.numOneItemSets;
    }

    public int getNumRules() {
        return this.numRules;
    }

    public String getFileName() {
        return this.fileName;
    }

    public RuleNode getStartRulelist() {
        return this.startRulelist;
    }

    public short[][] getDataArray() {
        return this.dataArray;
    }

    public short[] getReconArray() {
        return this.reconversionArray;
    }

    public boolean getHaveDataFlag() {
        return this.haveDataFlag;
    }

    public boolean getIsOrderedFlag() {
        return this.isOrderedFlag;
    }

    public void setSupport(double d) {
        this.support = d;
    }

    public void setMinSupport() {
        this.minSupport = (double)this.numRows * this.support / 100.0;
    }

    public void setConfidence(double d) {
        this.confidence = d;
    }

    public void setNumClasses(int n) {
        this.numClasses = n;
    }

    public void setNumOneItemSets(int n) {
        this.numOneItemSets = n;
    }

    public void setNumRowsAndCols(int n, int n2) {
        this.numRows = n;
        this.numCols = n2;
    }

    public void setNumberOfRows(int n) {
        this.numRows = n;
    }

    public void setNumberOfCols(int n) {
        this.numCols = n;
    }

    public void setOrderedAndPrunedFlags() {
        this.isOrderedFlag = false;
        this.isPrunedFlag = false;
    }

    public void setOutputRuleSetToFileFlag(boolean bl) {
        this.outputRuleSetToFileFlag = bl;
    }

    public void setStartRulelist(RuleNode ruleNode) {
        this.startRulelist = ruleNode;
    }

    public void setNumRules(int n) {
        this.numRules = n;
    }

    public void setDataArray(short[][] sArray) {
        this.dataArray = sArray;
    }

    public void setReconArray(short[] sArray) {
        this.reconversionArray = sArray;
    }

    public void setOutputSchemaArray(String[] stringArray) {
        this.outputSchema = stringArray;
        this.hasOutputSchemaFlag = true;
    }

    public void outputDataArray() {
        if (this.isPrunedFlag) {
            System.out.println("DATA SET (Ordered and Pruned)\n-----------------------------");
        } else if (this.isOrderedFlag) {
            System.out.println("DATA SET (Ordered)\n------------------");
        } else {
            System.out.println("DATA SET\n--------");
        }
        for (int i = 0; i < this.dataArray.length; ++i) {
            System.out.print("Rec #" + (i + 1) + ": ");
            this.outputItemSet(this.dataArray[i]);
            System.out.println();
        }
        System.out.println();
    }

    protected void outputDataArray(short[][] sArray) {
        if (sArray == null) {
            System.out.println("null");
            return;
        }
        for (int i = 0; i < sArray.length; ++i) {
            System.out.print("Rec #" + (i + 1) + ": ");
            this.outputItemSet(sArray[i]);
            System.out.println();
        }
        System.out.println();
    }

    protected void outputItemSet(short[] sArray) {
        if (sArray == null) {
            System.out.print(" null ");
        } else {
            short[] sArray2 = this.reconvertItemSet(sArray);
            int n = 0;
            for (int i = 0; i < sArray2.length; ++i) {
                if (n == 0) {
                    ++n;
                    System.out.print(" {");
                } else {
                    System.out.print(" ");
                }
                System.out.print(sArray2[i]);
            }
            System.out.print("} ");
        }
    }

    protected void outputItemSetToFile(short[] sArray) {
        if (sArray == null) {
            this.fileOutput.print(" null ");
        } else {
            short[] sArray2 = this.reconvertItemSet(sArray);
            boolean bl = false;
            for (int i = 0; i < sArray2.length; ++i) {
                if (i > 0) {
                    this.fileOutput.print(" ");
                }
                this.fileOutput.print(sArray2[i]);
            }
        }
    }

    protected void outputItemSetWithReconversion(short[] sArray) {
        System.out.println("ERROR: outputItemSetWithReconversion depricated use outputItemSet instead");
    }

    public void outputDataArraySize() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.dataArray.length; ++i) {
            if (this.dataArray[i] == null) continue;
            ++n;
            n2 += this.dataArray[i].length;
        }
        System.out.println("Number of records        = " + n);
        System.out.println("Number of elements       = " + n2);
        double d = (double)n2 / (double)(this.numCols * n);
        System.out.println("Data set density   = " + this.twoDecPlaces(d) + "%");
    }

    public void outputConversionArrays() {
        int n;
        System.out.println("CONVERSION ARRAY\nindex = old attribute number\nvalue [index][0] = new attribute number, value [index][1] = support count.");
        for (n = 1; n < this.conversionArray.length; ++n) {
            System.out.println("(" + n + ") " + this.conversionArray[n][0] + ", " + this.conversionArray[n][1]);
        }
        System.out.println("\nRECONVERSION ARRAY\nindex = new attribute number, value = old attribute number.");
        for (n = 1; n < this.reconversionArray.length; ++n) {
            System.out.println("(" + n + ") " + this.reconversionArray[n]);
        }
    }

    public void outputConversionArrays(JTextArea jTextArea) {
        int n;
        if (this.conversionArray == null) {
            jTextArea.append("No conversion arrays found.\n");
            return;
        }
        jTextArea.append("CONVERSION ARRAY\nindex = old attribute number\nvalue [index][0] = new attribute number, value [index][1] = support count.\n");
        for (n = 1; n < this.conversionArray.length; ++n) {
            jTextArea.append("(" + n + ") " + this.conversionArray[n][0] + ", " + this.conversionArray[n][1] + "\n");
        }
        jTextArea.append("\nRECONVERSION ARRAY\nindex = new attribute number, value = old attribute number.\n");
        for (n = 1; n < this.reconversionArray.length; ++n) {
            jTextArea.append("(" + n + ") " + this.reconversionArray[n] + "\n");
        }
    }

    protected void outputMenu() {
        System.out.println();
        System.out.println("-C  = Confidence (default 80%)");
        System.out.println("-F  = File name");
        System.out.println("-N  = Number of classes (optional)");
        System.out.println("-O  = Output file name (optional)");
        System.out.println("-S  = Support (default 20%)");
        System.out.println();
        System.exit(1);
    }

    protected void outputSettings() {
        System.out.println("SETTINGS\n--------");
        System.out.println("File name                = " + this.fileName);
        if (this.outputFileName != null) {
            System.out.println("File name                = " + this.outputFileName);
        }
        System.out.println("Support (default 20%)    = " + this.support);
        System.out.println("Confidence (default 80%) = " + this.confidence);
        System.out.println("Num. classes (Optional)  = " + this.numClasses);
        System.out.println();
    }

    protected void outputSettings2() {
        System.out.println("SETTINGS\n--------");
        System.out.println("Number of records        = " + this.numRows);
        System.out.println("Number of columns        = " + this.numCols);
        System.out.println("Support (default 20%)    = " + this.support);
        System.out.println("Confidence (default 80%) = " + this.confidence);
        System.out.println("Min support              = " + this.minSupport + " (records)");
        System.out.println("Num one itemsets         = " + this.numOneItemSets);
        System.out.println("Num. classes (Optional)  = " + this.numClasses);
    }

    public void outputSuppAndConf() {
        System.out.println("Support = " + this.twoDecPlaces(this.support) + ", Confidence = " + this.twoDecPlaces(this.confidence));
    }

    public void outputRules() {
        this.outputRules(this.startRulelist);
    }

    public void outputRules(RuleNode ruleNode) {
        if (ruleNode == null) {
            System.out.println("NO RULES GENERATED");
            return;
        }
        this.outputRules2(ruleNode);
    }

    private void outputRules2(RuleNode ruleNode) {
        if (ruleNode != null) {
            this.outputRules2(ruleNode.leftBranch);
            System.out.print("(" + ruleNode.ruleNumber + ") ");
            this.outputRule(ruleNode);
            System.out.println(" " + this.twoDecPlaces(ruleNode.confidenceForRule));
            this.outputRules2(ruleNode.rightBranch);
        }
    }

    private void outputRule(RuleNode ruleNode) {
        this.outputItemSet(ruleNode.antecedent);
        System.out.print(" -> ");
        this.outputItemSet(ruleNode.consequent);
    }

    public void outputRulesToFile() {
        if (this.startRulelist != null) {
            try {
                this.fileOutput = new PrintWriter(new FileWriter(this.outputFileName));
                this.outputRulesToFile2(this.startRulelist);
                this.fileOutput.close();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(null, "Unknown error opening file: " + this.outputFileName + "\n", "FILE OUTPUT ERROR", 0);
                System.exit(1);
            }
        }
    }

    private void outputRulesToFile2(RuleNode ruleNode) {
        if (ruleNode != null) {
            this.outputRulesToFile2(ruleNode.leftBranch);
            this.fileOutput.print("<ANTECEDENT>");
            this.outputItemSetToFile(ruleNode.antecedent);
            this.fileOutput.print("</ANTECEDENT><CONSEQUENT>");
            this.outputItemSetToFile(ruleNode.consequent);
            this.fileOutput.print("</CONSEQUENT><CONFIDENCE>" + this.twoDecPlaces(ruleNode.confidenceForRule) + "<CONFIDENCE>\n");
            this.outputRulesToFile2(ruleNode.rightBranch);
        }
    }

    public void outputRulesSchema() {
        if (this.startRulelist == null) {
            System.out.println("NO RULES GENERATED");
            return;
        }
        this.outputRulesSchema(this.startRulelist);
    }

    private void outputRulesSchema(RuleNode ruleNode) {
        if (ruleNode != null) {
            this.outputRulesSchema(ruleNode.leftBranch);
            System.out.print("(" + ruleNode.ruleNumber + ") ");
            this.outputItemSetSchema(ruleNode.antecedent);
            System.out.print(" -> ");
            this.outputItemSetSchema(ruleNode.consequent);
            System.out.println(" " + this.twoDecPlaces(ruleNode.confidenceForRule));
            this.outputRulesSchema(ruleNode.rightBranch);
        }
    }

    protected void outputItemSetSchema(short[] sArray) {
        if (sArray == null) {
            System.out.print(" {} ");
        } else {
            short[] sArray2 = this.reconvertItemSet(sArray);
            int n = 0;
            for (int i = 0; i < sArray2.length; ++i) {
                if (n == 0) {
                    ++n;
                    System.out.print(" {");
                } else {
                    System.out.print(" ");
                }
                System.out.print(this.outputSchema[sArray2[i] - 1]);
            }
            System.out.print("} ");
        }
    }

    public void outputRulesWithDefault() {
        System.out.println("Output Rules With Default");
        this.outputRulesWithDefault(this.startRulelist);
    }

    public void outputRulesWithDefault(int n) {
        if (this.startRulelist == null) {
            System.out.println("NO RULES GENERATED");
            return;
        }
        int n2 = this.numRules;
        this.numRules = n;
        this.outputRulesWithDefault(this.startRulelist);
        this.numRules = n2;
    }

    public void outputRulesWithDefault(RuleNode ruleNode) {
        if (ruleNode != null) {
            if (ruleNode.ruleNumber > this.numRules) {
                return;
            }
            this.outputRulesWithDefault(ruleNode.leftBranch);
            System.out.print("(" + ruleNode.ruleNumber + ") ");
            if (ruleNode.ruleNumber == this.numRules) {
                System.out.print("Default");
            } else {
                this.outputItemSet(ruleNode.antecedent);
            }
            System.out.print(" -> ");
            this.outputItemSet(ruleNode.consequent);
            System.out.println(" " + this.twoDecPlaces(ruleNode.confidenceForRule));
            this.outputRulesWithDefault(ruleNode.rightBranch);
        }
    }

    public void outputNumRules() {
        System.out.println("Number of rules         = " + this.numRules);
    }

    public void outputClassifierStats() {
        System.out.println("Number of rules         = " + this.numRules);
        int n = this.getMaxSizeOfAntecedent();
        System.out.println("Max size of antecedent  = " + n);
        int[] nArray = new int[n];
        this.calcAntecedentDistrib(nArray);
        double d = this.getAveSizeOfAntecedent(nArray);
        System.out.println("Ave size of antecedent  = " + d);
        System.out.println("Antecedent size distribution");
        for (int i = 0; i < nArray.length; ++i) {
            System.out.println("\tAntecedent size " + (i + 1) + "\t= " + nArray[i]);
        }
    }

    public int getMaxSizeOfAntecedent() {
        int n = 0;
        return this.getMaxSizeOfAntecedent(this.startRulelist, n);
    }

    private int getMaxSizeOfAntecedent(RuleNode ruleNode, int n) {
        if (ruleNode != null) {
            if (ruleNode.antecedent.length > (n = this.getMaxSizeOfAntecedent(ruleNode.leftBranch, n))) {
                n = ruleNode.antecedent.length;
            }
            n = this.getMaxSizeOfAntecedent(ruleNode.rightBranch, n);
        }
        return n;
    }

    private void calcAntecedentDistrib(int[] nArray) {
        this.calcAntecedentDistrib(this.startRulelist, nArray);
    }

    private void calcAntecedentDistrib(RuleNode ruleNode, int[] nArray) {
        if (ruleNode != null) {
            this.calcAntecedentDistrib(ruleNode.leftBranch, nArray);
            int n = ruleNode.antecedent.length;
            int n2 = n - 1;
            nArray[n2] = nArray[n2] + 1;
            this.calcAntecedentDistrib(ruleNode.rightBranch, nArray);
        }
    }

    protected double getAveSizeOfAntecedent(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += (i + 1) * nArray[i];
        }
        double d = (double)n / (double)this.numRules;
        return this.twoDecPlaces(d);
    }

    public void outputDataArray(JTextArea jTextArea) {
        if (this.isPrunedFlag) {
            jTextArea.append("DATA SET (Ordered and Pruned)\n-----------------------------\n");
        } else if (this.isOrderedFlag) {
            jTextArea.append("DATA SET (Ordered)\n------------------\n");
        } else {
            jTextArea.append("DATA SET\n--------\n");
        }
        for (int i = 0; i < this.dataArray.length; ++i) {
            this.outputItemSet(jTextArea, this.dataArray[i]);
            jTextArea.append("\n");
        }
    }

    public void outputDataArraySchema(JTextArea jTextArea) {
        if (this.isPrunedFlag) {
            jTextArea.append("DATA SET (pruned)\n-----------------------------\n");
        } else if (this.isOrderedFlag) {
            jTextArea.append("DATA SET (Ordered)\n------------------\n");
        } else {
            jTextArea.append("DATA SET\n--------\n");
        }
        for (int i = 0; i < this.dataArray.length; ++i) {
            this.outputItemSetSchema(jTextArea, this.dataArray[i]);
            jTextArea.append("\n");
        }
    }

    protected void outputItemSetSchema(JTextArea jTextArea, short[] sArray) {
        if (sArray == null) {
            jTextArea.append(" {} ");
        } else {
            short[] sArray2 = this.reconvertItemSet(sArray);
            int n = 0;
            for (int i = 0; i < sArray2.length; ++i) {
                if (n == 0) {
                    ++n;
                    jTextArea.append(" {");
                } else {
                    jTextArea.append(" ");
                }
                jTextArea.append(this.outputSchema[sArray2[i] - 1]);
            }
            jTextArea.append("} ");
        }
    }

    public void outputOutputSchema(JTextArea jTextArea) {
        for (int i = 0; i < this.outputSchema.length; ++i) {
            jTextArea.append("(" + (i + 1) + ") " + this.outputSchema[i] + "\n");
        }
    }

    protected void outputItemSet(JTextArea jTextArea, short[] sArray) {
        if (sArray == null) {
            jTextArea.append(" null ");
        } else {
            short[] sArray2 = this.reconvertItemSet(sArray);
            int n = 0;
            for (int i = 0; i < sArray2.length; ++i) {
                if (n == 0) {
                    ++n;
                    jTextArea.append(" {");
                } else {
                    jTextArea.append(" ");
                }
                jTextArea.append(Short.toString(sArray2[i]));
            }
            jTextArea.append("} ");
        }
    }

    public void outputRules(JTextArea jTextArea) {
        this.outputRules(jTextArea, this.startRulelist);
    }

    public void outputRules(JTextArea jTextArea, RuleNode ruleNode) {
        if (ruleNode == null) {
            jTextArea.append("NO RULES GENERATED\n");
            return;
        }
        this.outputRules2(jTextArea, ruleNode);
    }

    private void outputRules2(JTextArea jTextArea, RuleNode ruleNode) {
        if (ruleNode != null) {
            this.outputRules2(jTextArea, ruleNode.leftBranch);
            jTextArea.append("(" + ruleNode.ruleNumber + ") ");
            this.outputItemSet(jTextArea, ruleNode.antecedent);
            jTextArea.append(" -> ");
            this.outputItemSet(jTextArea, ruleNode.consequent);
            jTextArea.append(" " + this.twoDecPlaces(ruleNode.confidenceForRule) + "\n");
            this.outputRules2(jTextArea, ruleNode.rightBranch);
        }
    }

    public void outputRulesWithDefault(JTextArea jTextArea) {
        this.outputRulesWithDefault(jTextArea, this.startRulelist);
    }

    public void outputRulesWithDefault(JTextArea jTextArea, RuleNode ruleNode) {
        if (ruleNode == null) {
            jTextArea.append("NO RULES GENERATED\n");
            return;
        }
        this.outputRulesWithDefault2(jTextArea, ruleNode);
    }

    private void outputRulesWithDefault2(JTextArea jTextArea, RuleNode ruleNode) {
        if (ruleNode != null) {
            this.outputRulesWithDefault2(jTextArea, ruleNode.leftBranch);
            jTextArea.append("(" + ruleNode.ruleNumber + ") ");
            if (ruleNode.ruleNumber == this.numRules) {
                jTextArea.append("Default");
            } else {
                this.outputItemSet(jTextArea, ruleNode.antecedent);
            }
            jTextArea.append(" -> ");
            this.outputItemSet(jTextArea, ruleNode.consequent);
            jTextArea.append(" " + this.twoDecPlaces(ruleNode.confidenceForRule) + "\n");
            this.outputRulesWithDefault2(jTextArea, ruleNode.rightBranch);
        }
    }

    public void outputRulesSchema(JTextArea jTextArea) {
        this.outputRulesSchema(jTextArea, this.startRulelist);
    }

    public void outputRulesSchema(JTextArea jTextArea, RuleNode ruleNode) {
        if (ruleNode == null) {
            jTextArea.append("NO RULES GENERATED\n");
            return;
        }
        this.outputRulesSchema2(jTextArea, ruleNode);
    }

    private void outputRulesSchema2(JTextArea jTextArea, RuleNode ruleNode) {
        if (ruleNode != null) {
            this.outputRulesSchema2(jTextArea, ruleNode.leftBranch);
            jTextArea.append("(" + ruleNode.ruleNumber + ") ");
            this.outputItemSetSchema(jTextArea, ruleNode.antecedent);
            jTextArea.append(" -> ");
            this.outputItemSetSchema(jTextArea, ruleNode.consequent);
            jTextArea.append(" " + this.twoDecPlaces(ruleNode.confidenceForRule) + "\n");
            this.outputRulesSchema2(jTextArea, ruleNode.rightBranch);
        }
    }

    public void outputPrologFactsAttNum(JTextArea jTextArea) {
        this.outputPrologFactsAttNum(jTextArea, this.startRulelist);
    }

    public void outputPrologFactsAttNum(JTextArea jTextArea, RuleNode ruleNode) {
        if (ruleNode == null) {
            jTextArea.append("NO RULES GENERATED\n");
            return;
        }
        this.outputPrologFactsAttNum2(jTextArea, ruleNode);
    }

    private void outputPrologFactsAttNum2(JTextArea jTextArea, RuleNode ruleNode) {
        if (ruleNode != null) {
            int n;
            this.outputPrologFactsAttNum2(jTextArea, ruleNode.leftBranch);
            String string = "associationRule([";
            short[] sArray = this.reconvertItemSet(ruleNode.antecedent);
            for (n = 0; n < sArray.length; ++n) {
                if (n > 0) {
                    string = string + ",";
                }
                string = string + "att" + sArray[n];
            }
            string = string + "],[";
            sArray = this.reconvertItemSet(ruleNode.consequent);
            for (n = 0; n < sArray.length; ++n) {
                if (n > 0) {
                    string = string + ",";
                }
                string = string + "att" + sArray[n];
            }
            string = string + "]," + this.twoDecPlaces(ruleNode.confidenceForRule) + ").\n\n";
            jTextArea.append(string);
            this.outputPrologFactsAttNum2(jTextArea, ruleNode.rightBranch);
        }
    }

    public void outputPrologFactsOutSch(JTextArea jTextArea) {
        this.outputPrologFactsOutSch(jTextArea, this.startRulelist);
    }

    public void outputPrologFactsOutSch(JTextArea jTextArea, RuleNode ruleNode) {
        if (ruleNode == null) {
            jTextArea.append("NO RULES GENERATED\n");
            return;
        }
        this.outputPrologFactsOutSch2(jTextArea, ruleNode);
    }

    private void outputPrologFactsOutSch2(JTextArea jTextArea, RuleNode ruleNode) {
        if (ruleNode != null) {
            int n;
            this.outputPrologFactsOutSch2(jTextArea, ruleNode.leftBranch);
            String string = "associationRule([";
            short[] sArray = this.reconvertItemSet(ruleNode.antecedent);
            for (n = 0; n < sArray.length; ++n) {
                if (n > 0) {
                    string = string + ",";
                }
                string = string + this.outputSchema[sArray[n] - 1];
            }
            string = string + "],[";
            sArray = this.reconvertItemSet(ruleNode.consequent);
            for (n = 0; n < sArray.length; ++n) {
                if (n > 0) {
                    string = string + ",";
                }
                string = string + this.outputSchema[sArray[n] - 1];
            }
            string = string + "]," + this.twoDecPlaces(ruleNode.confidenceForRule) + ").\n\n";
            jTextArea.append(string);
            this.outputPrologFactsOutSch2(jTextArea, ruleNode.rightBranch);
        }
    }

    public void outputMinSupport(JTextArea jTextArea) {
        this.minSupport = (double)this.numRows * this.support / 100.0;
        jTextArea.append("Min support = " + this.minSupport + " (records)\n");
    }

    public void outputSettings(JTextArea jTextArea) {
        jTextArea.append("SETTINGS\n--------\n");
        jTextArea.append("Number of records = " + this.numRows + "\n");
        jTextArea.append("Number of columns = " + this.numCols + "\n");
        jTextArea.append("Support (default 20%)    = " + this.support + "\n");
        jTextArea.append("Confidence (default 80%) = " + this.confidence + "\n");
        jTextArea.append("Min support = " + this.twoDecPlaces(this.minSupport) + " (records)\n");
        jTextArea.append("Num one itemsets = " + this.numOneItemSets + "\n");
    }

    public void outputSuppAndConf(JTextArea jTextArea) {
        jTextArea.append("Support = " + this.twoDecPlaces(this.support) + ", Confidence = " + this.twoDecPlaces(this.confidence) + "\n");
    }

    public void outputNumRules(JTextArea jTextArea) {
        jTextArea.append("Number of rules = " + this.numRules + "\n");
    }

    public double outputDuration(double d, double d2) {
        double d3 = (d2 - d) / 1000.0;
        System.out.println("Generation time = " + this.twoDecPlaces(d3) + " seconds (" + this.twoDecPlaces(d3 / 60.0) + " mins)");
        return d3;
    }

    public void outputDuration(JTextArea jTextArea, double d, double d2) {
        double d3 = (d2 - d) / 1000.0;
        jTextArea.append("Generation time = " + this.twoDecPlaces(d3) + " seconds (" + this.twoDecPlaces(d3 / 60.0) + " mins)\n");
    }

    protected String getDuration(double d, double d2) {
        double d3 = (d2 - d) / 1000.0;
        return "Generation time = " + this.twoDecPlaces(d3) + " seconds (" + this.twoDecPlaces(d3 / 60.0) + " mins)";
    }

    public void outputDataArrayToFile() throws IOException {
        int n = this.fileName.lastIndexOf(47);
        String string = this.fileName.substring(n + 1, this.fileName.length());
        PrintWriter printWriter = new PrintWriter(new FileWriter(string));
        for (int i = 0; i < this.numRows; ++i) {
            if (this.dataArray[i] == null) continue;
            boolean bl = true;
            for (int j = 0; j < this.dataArray[i].length; ++j) {
                if (bl) {
                    bl = false;
                } else {
                    printWriter.print(" ");
                }
                printWriter.print(this.dataArray[i][j]);
            }
            printWriter.println();
        }
        printWriter.close();
    }

    private void ouputSegmentToFile(String string, int n, int n2) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileWriter(string));
        for (int i = n; i < n2; ++i) {
            String string2 = this.fileInput.readLine();
            printWriter.println(string2);
        }
        printWriter.close();
    }

    private void outputPartitionToFile(String string, short s) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileWriter(string + "." + s));
        for (int i = 0; i < this.dataArray.length; ++i) {
            if (this.memberOf(s, this.dataArray[i])) {
                boolean bl = true;
                for (int j = 0; j < this.dataArray[i].length; ++j) {
                    if (bl) {
                        bl = false;
                    } else {
                        printWriter.print(" ");
                    }
                    printWriter.print(this.dataArray[i][j]);
                    if (this.dataArray[i][j] == s) break;
                }
                printWriter.println();
                continue;
            }
            printWriter.println();
        }
        printWriter.close();
    }

    protected void outputItemSetToFile(short[] sArray, PrintWriter printWriter) throws IOException {
        if (sArray == null) {
            printWriter.print(" null ");
        } else {
            int n = 0;
            for (int i = 0; i < sArray.length; ++i) {
                if (n == 0) {
                    ++n;
                } else {
                    printWriter.print(" ");
                }
                printWriter.print(Short.toString(sArray[i]));
            }
            printWriter.println();
        }
    }

    protected boolean similar2dec(double d, double d2) {
        int n = (int)((d + 0.005) * 100.0);
        int n2 = (int)((d2 + 0.005) * 100.0);
        return n == n2;
    }

    protected double twoDecPlaces(double d) {
        int n = (int)((d + 0.005) * 100.0);
        d = (double)n / 100.0;
        return d;
    }

    protected double fourDecPlaces(double d) {
        int n = (int)((d + 5.0E-5) * 10000.0);
        d = (double)n / 10000.0;
        return d;
    }
}

