## ----mapping-layout, echo = FALSE, fig.pos = "H", out.width = "40%", fig.cap = "\\label{fig:mapping-layout} Data parser mapping layout", fig.align='center'----
knitr::include_graphics("https://i.imgur.com/ezqS00V.png", dpi = 100, error = F)

## ----raw-data-plot, dpi = 120, out.width="80%", fig.height=4.5, fig.pos = "H", fig.align="center", echo = F, eval = T, results='hold', message=FALSE, error=FALSE, warning=FALSE, fig.cap = "\\label{fig:raw-data-plot} Raw data plot.\nConditions can be selected or deselected using the `names = c('grp1', 'grp2')` argument or `exclude.nm = c('grp3', 'grp4')` argument, respectively. Similarly, concentrations can be (de-selected) via the `conc` and `exclude.conc` arguments. To plot individual samples instead of grouping replicates, add `mean = FALSE`. See `?plot.grodata` for further options.", tidy = FALSE----
knitr::include_graphics("https://i.imgur.com/FnsrDPs.png", error = F)


## ----grofit-container, echo = FALSE, fig.pos = "H", out.width = "90%", fig.cap = "\\label{fig:grofit-container} Internal structure of a `grofit`object generated by `growth.workflow()`.", fig.align='center'----
knitr::include_graphics("https://i.imgur.com/prZblqj.jpg", error = F)

## ----group-spline-plot, dpi = 120, out.width="80%", fig.height=6.5, fig.pos = "H", fig.align="center", echo = F, eval = T, results='asis', message=FALSE, error=FALSE, warning=FALSE, fig.cap = "\\label{fig:group-spline-plot} Combined plot of all spline fits performed.\nIn addition to the options available with `data.type = 'raw'`, further arguments can be defined that control the appearance of the secondary panel showing the slope over time. See `?plot.grofit` for all options.", tidy = FALSE----
knitr::include_graphics("https://i.imgur.com/W7FL4T0.png", error = F)

## ----plot-parameter, dpi = 120, fig.show="hold", out.width="47%", fig.height = 5, fig.align="center", fig.pos = "H", echo = F, eval = T, message=FALSE, error=FALSE, warning=FALSE, tidy = TRUE, fig.cap = "\\label{fig:plot-parameter} Parameter plots. If `mean = TRUE`, the results of replicates are combined and shown as their mean \u00B1 95\\% confidence interval. As with the functions for combining different growth curves, the arguments `name`, `exclude.nm`, `conc` and `exclude.conc` allow (de)selection of specific samples or conditions. Since we applied growth models to log-transformed data, calling 'dY.orig.model' or 'A.orig.model' instead of 'dY.model' or 'A.model' provides the respective values on the original scale. For linear and spline fits, this is done automatically. For details about this function, run `?plot.parameter`."----
# Parameters obtained from linear regression
knitr::include_graphics("https://i.imgur.com/bEqrPGF.png", error = F)
knitr::include_graphics("https://i.imgur.com/BfqPKxm.png", error = F)

# Parameters obtained from nonparametric fits
knitr::include_graphics("https://i.imgur.com/lFhF5g2.png", error = F)
knitr::include_graphics("https://i.imgur.com/kbrwN4v.png", error = F)

# Parameters obtained from model fits
knitr::include_graphics("https://i.imgur.com/9TbWymF.png", error = F)
knitr::include_graphics("https://i.imgur.com/Rpx81xq.png", error = F)

## ----plot-linear, dpi = 120, fig.ncol = 1, fig.show="hold", out.width="70%", fig.height = 4.5, fig.pos = "H", fig.align='center', echo = F, eval = T, message=FALSE, error=FALSE, warning=FALSE, tidy = TRUE, fig.cap = "\\label{fig:plot-linear} Linear fit plots to identify sample outliers. For details about this function, run `?plot.gcFitLinear`.", fig.subcap=c("Sample 'KT2440 | 1 | 0'", "Sample 'KT2440 | 2 | 0'")----
knitr::include_graphics("https://i.imgur.com/5SsriHL.png", error = F)
knitr::include_graphics("https://i.imgur.com/RGbH90A.png", error = F)

## ----plot-linear-update, dpi = 120, fig.show="hold", out.width="70%", fig.height = 4.5, results='hold' ,fig.align="center", fig.pos = "H", echo = F, eval = T, message=FALSE, error=FALSE, warning=FALSE, tidy = TRUE, fig.cap = "\\label{fig:plot-linear-update} Updated linear fit for the outlier sample 'KT2440 | 2 | 0'."----
knitr::include_graphics("https://i.imgur.com/8pPuvZG.png", error = F)

## ----plot-parameter-update, dpi = 120, out.width="70%", fig.height = 5, fig.align="center", fig.pos = "H", echo = F, eval = T, message=FALSE, error=FALSE, warning=FALSE, tidy = TRUE, fig.cap = "\\label{fig:plot-parameter-update} Parameter plot with updated fit."----
# Parameters obtained from linear regression
knitr::include_graphics("https://i.imgur.com/dei4pEJ.png", error = F)

## ----grid-plot, dpi = 120, out.width="90%", fig.height=3, fig.pos = "H", fig.align='center', echo = F, eval = T, results='asis', message=FALSE, error=FALSE, warning=FALSE, fig.cap = "\\label{fig:plot} Plot grid of all spline fits performed . See `?plot.grid` for available options.", tidy = FALSE----
knitr::include_graphics("https://i.imgur.com/UuvZg5B.png", error = F)

## ----plot-drFit, dpi = 120, fig.ncol = 1, fig.show="hold", out.width="70%", fig.height = 4.5, fig.pos = "H", fig.align='center', echo = F, eval = T, message=FALSE, error=FALSE, warning=FALSE, tidy = TRUE, fig.cap = "\\label{fig:plot-drFit} Dose response analysis - model fits. For details about this function, run `?plot.drFit`."----
knitr::include_graphics("https://i.imgur.com/Mmc7EoI.png", error = F)

## ----plot-gcBootSpline, dpi = 120, fig.show="hold", out.width="85%", fig.height = 10, fig.pos = "H", fig.align='center', echo = F, eval = T, message=FALSE, error=FALSE, warning=FALSE, tidy = FALSE, fig.cap = "\\label{fig:plot-gcBootSpline} Nonparametric growth fit with bootstrapping. For details about this function, run `?plot.gcBootSpline`."----
knitr::include_graphics("https://i.imgur.com/OlkhV5v.png", error = F)


## ----plot-drBootSpline, dpi = 120, fig.show="hold", out.width="85%", fig.height = 6, fig.pos = "H", fig.align='center', echo = F, eval = T, message=FALSE, error=FALSE, warning=FALSE, tidy = FALSE, fig.cap = "\\label{fig:plot-drBootSpline} Dose-response analysis with bootstrapping. For details about this function, run `?plot.drBootSpline`."----
knitr::include_graphics("https://i.imgur.com/hmKs1Yy.png", error = F)


