/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tfloat.bin;

import cern.colt.list.tfloat.FloatArrayList;
import cern.jet.stat.tfloat.FloatDescriptive;
import hep.aida.tfloat.bin.AbstractFloatBin1D;

public class StaticFloatBin1D
extends AbstractFloatBin1D {
    private static final long serialVersionUID = 1L;
    protected int size = 0;
    protected float min = 0.0f;
    protected float max = 0.0f;
    protected float sum = 0.0f;
    protected float sum_xx = 0.0f;
    protected static transient float[] arguments = new float[20];

    public StaticFloatBin1D() {
        this.clear();
    }

    public synchronized void add(float f) {
        this.addAllOf(new FloatArrayList(new float[]{f}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addAllOfFromTo(FloatArrayList floatArrayList, int n, int n2) {
        float[] fArray = arguments;
        synchronized (arguments) {
            StaticFloatBin1D.arguments[0] = this.min;
            StaticFloatBin1D.arguments[1] = this.max;
            StaticFloatBin1D.arguments[2] = this.sum;
            StaticFloatBin1D.arguments[3] = this.sum_xx;
            FloatDescriptive.incrementalUpdate(floatArrayList, n, n2, arguments);
            this.min = arguments[0];
            this.max = arguments[1];
            this.sum = arguments[2];
            this.sum_xx = arguments[3];
            this.size += n2 - n + 1;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    public synchronized void clear() {
        this.clearAllMeasures();
        this.size = 0;
    }

    protected void clearAllMeasures() {
        this.min = Float.POSITIVE_INFINITY;
        this.max = Float.NEGATIVE_INFINITY;
        this.sum = 0.0f;
        this.sum_xx = 0.0f;
    }

    public synchronized boolean isRebinnable() {
        return false;
    }

    public synchronized float max() {
        return this.max;
    }

    public synchronized float min() {
        return this.min;
    }

    public synchronized int size() {
        return this.size;
    }

    public synchronized float sum() {
        return this.sum;
    }

    public synchronized float sumOfSquares() {
        return this.sum_xx;
    }
}

