/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.IntMatrix3D;
import cern.colt.matrix.tint.impl.DelegateIntMatrix2D;
import cern.colt.matrix.tint.impl.DenseIntMatrix1D;

public class WrapperIntMatrix3D
extends IntMatrix3D {
    private static final long serialVersionUID = 1L;
    protected IntMatrix3D content;

    public WrapperIntMatrix3D(IntMatrix3D intMatrix3D) {
        block3: {
            if (intMatrix3D != null) {
                try {
                    this.setUp(intMatrix3D.slices(), intMatrix3D.rows(), intMatrix3D.columns());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if ("matrix too large".equals(illegalArgumentException.getMessage())) break block3;
                    throw illegalArgumentException;
                }
            }
        }
        this.content = intMatrix3D;
    }

    public Object elements() {
        return this.content.elements();
    }

    public synchronized int getQuick(int n, int n2, int n3) {
        return this.content.getQuick(n, n2, n3);
    }

    public IntMatrix3D like(int n, int n2, int n3) {
        return this.content.like(n, n2, n3);
    }

    public synchronized void setQuick(int n, int n2, int n3, int n4) {
        this.content.setQuick(n, n2, n3, n4);
    }

    public IntMatrix1D vectorize() {
        DenseIntMatrix1D denseIntMatrix1D = new DenseIntMatrix1D((int)this.size());
        int n = this.rows * this.columns;
        for (int i = 0; i < this.slices; ++i) {
            denseIntMatrix1D.viewPart(i * n, n).assign(this.viewSlice(i).vectorize());
        }
        return denseIntMatrix1D;
    }

    public IntMatrix2D viewColumn(int n) {
        this.checkColumn(n);
        return new DelegateIntMatrix2D(this, 2, n);
    }

    public IntMatrix3D viewColumnFlip() {
        if (this.columns == 0) {
            return this;
        }
        WrapperIntMatrix3D wrapperIntMatrix3D = new WrapperIntMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized int getQuick(int n, int n2, int n3) {
                return this.content.getQuick(n, n2, this.columns - 1 - n3);
            }

            public synchronized void setQuick(int n, int n2, int n3, int n4) {
                this.content.setQuick(n, n2, this.columns - 1 - n3, n4);
            }

            public synchronized int get(int n, int n2, int n3) {
                return this.content.get(n, n2, this.columns - 1 - n3);
            }

            public synchronized void set(int n, int n2, int n3, int n4) {
                this.content.set(n, n2, this.columns - 1 - n3, n4);
            }
        };
        wrapperIntMatrix3D.isNoView = false;
        return wrapperIntMatrix3D;
    }

    public IntMatrix2D viewSlice(int n) {
        this.checkSlice(n);
        return new DelegateIntMatrix2D(this, 0, n);
    }

    public IntMatrix3D viewSliceFlip() {
        if (this.slices == 0) {
            return this;
        }
        WrapperIntMatrix3D wrapperIntMatrix3D = new WrapperIntMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized int getQuick(int n, int n2, int n3) {
                return this.content.getQuick(this.slices - 1 - n, n2, n3);
            }

            public synchronized void setQuick(int n, int n2, int n3, int n4) {
                this.content.setQuick(this.slices - 1 - n, n2, n3, n4);
            }

            public synchronized int get(int n, int n2, int n3) {
                return this.content.get(this.slices - 1 - n, n2, n3);
            }

            public synchronized void set(int n, int n2, int n3, int n4) {
                this.content.set(this.slices - 1 - n, n2, n3, n4);
            }
        };
        wrapperIntMatrix3D.isNoView = false;
        return wrapperIntMatrix3D;
    }

    public IntMatrix3D viewDice(int n, int n2, int n3) {
        int n4 = 3;
        if (n < 0 || n >= n4 || n2 < 0 || n2 >= n4 || n3 < 0 || n3 >= n4 || n == n2 || n == n3 || n2 == n3) {
            throw new IllegalArgumentException("Illegal Axes: " + n + ", " + n2 + ", " + n3);
        }
        WrapperIntMatrix3D wrapperIntMatrix3D = null;
        if (n == 0 && n2 == 1 && n3 == 2) {
            wrapperIntMatrix3D = new WrapperIntMatrix3D(this);
        } else if (n == 1 && n2 == 0 && n3 == 2) {
            wrapperIntMatrix3D = new WrapperIntMatrix3D(this){
                private static final long serialVersionUID = 1L;

                public synchronized int getQuick(int n, int n2, int n3) {
                    return this.content.getQuick(n2, n, n3);
                }

                public synchronized void setQuick(int n, int n2, int n3, int n4) {
                    this.content.setQuick(n2, n, n3, n4);
                }

                public synchronized int get(int n, int n2, int n3) {
                    return this.content.get(n2, n, n3);
                }

                public synchronized void set(int n, int n2, int n3, int n4) {
                    this.content.set(n2, n, n3, n4);
                }
            };
        } else if (n == 1 && n2 == 2 && n3 == 0) {
            wrapperIntMatrix3D = new WrapperIntMatrix3D(this){
                private static final long serialVersionUID = 1L;

                public synchronized int getQuick(int n, int n2, int n3) {
                    return this.content.getQuick(n2, n3, n);
                }

                public synchronized void setQuick(int n, int n2, int n3, int n4) {
                    this.content.setQuick(n2, n3, n, n4);
                }

                public synchronized int get(int n, int n2, int n3) {
                    return this.content.get(n2, n3, n);
                }

                public synchronized void set(int n, int n2, int n3, int n4) {
                    this.content.set(n2, n3, n, n4);
                }
            };
        } else if (n == 2 && n2 == 1 && n3 == 0) {
            wrapperIntMatrix3D = new WrapperIntMatrix3D(this){
                private static final long serialVersionUID = 1L;

                public synchronized int getQuick(int n, int n2, int n3) {
                    return this.content.getQuick(n3, n2, n);
                }

                public synchronized void setQuick(int n, int n2, int n3, int n4) {
                    this.content.setQuick(n3, n2, n, n4);
                }

                public synchronized int get(int n, int n2, int n3) {
                    return this.content.get(n3, n2, n);
                }

                public synchronized void set(int n, int n2, int n3, int n4) {
                    this.content.set(n3, n2, n, n4);
                }
            };
        } else if (n == 2 && n2 == 0 && n3 == 1) {
            wrapperIntMatrix3D = new WrapperIntMatrix3D(this){
                private static final long serialVersionUID = 1L;

                public synchronized int getQuick(int n, int n2, int n3) {
                    return this.content.getQuick(n3, n, n2);
                }

                public synchronized void setQuick(int n, int n2, int n3, int n4) {
                    this.content.setQuick(n3, n, n2, n4);
                }

                public synchronized int get(int n, int n2, int n3) {
                    return this.content.get(n3, n, n2);
                }

                public synchronized void set(int n, int n2, int n3, int n4) {
                    this.content.set(n3, n, n2, n4);
                }
            };
        }
        int[] nArray = this.shape();
        wrapperIntMatrix3D.slices = nArray[n];
        wrapperIntMatrix3D.rows = nArray[n2];
        wrapperIntMatrix3D.columns = nArray[n3];
        wrapperIntMatrix3D.isNoView = false;
        return wrapperIntMatrix3D;
    }

    public IntMatrix3D viewPart(final int n, final int n2, final int n3, int n4, int n5, int n6) {
        this.checkBox(n, n2, n3, n4, n5, n6);
        WrapperIntMatrix3D wrapperIntMatrix3D = new WrapperIntMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized int getQuick(int n4, int n22, int n32) {
                return this.content.getQuick(n + n4, n2 + n22, n3 + n32);
            }

            public synchronized void setQuick(int n5, int n22, int n32, int n4) {
                this.content.setQuick(n + n5, n2 + n22, n3 + n32, n4);
            }

            public synchronized int get(int n4, int n22, int n32) {
                return this.content.get(n + n4, n2 + n22, n3 + n32);
            }

            public synchronized void set(int n5, int n22, int n32, int n4) {
                this.content.set(n + n5, n2 + n22, n3 + n32, n4);
            }
        };
        wrapperIntMatrix3D.slices = n4;
        wrapperIntMatrix3D.rows = n5;
        wrapperIntMatrix3D.columns = n6;
        wrapperIntMatrix3D.isNoView = false;
        return wrapperIntMatrix3D;
    }

    public IntMatrix2D viewRow(int n) {
        this.checkRow(n);
        return new DelegateIntMatrix2D(this, 1, n);
    }

    public IntMatrix3D viewRowFlip() {
        if (this.rows == 0) {
            return this;
        }
        WrapperIntMatrix3D wrapperIntMatrix3D = new WrapperIntMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized int getQuick(int n, int n2, int n3) {
                return this.content.getQuick(n, this.rows - 1 - n2, n3);
            }

            public synchronized void setQuick(int n, int n2, int n3, int n4) {
                this.content.setQuick(n, this.rows - 1 - n2, n3, n4);
            }

            public synchronized int get(int n, int n2, int n3) {
                return this.content.get(n, this.rows - 1 - n2, n3);
            }

            public synchronized void set(int n, int n2, int n3, int n4) {
                this.content.set(n, this.rows - 1 - n2, n3, n4);
            }
        };
        wrapperIntMatrix3D.isNoView = false;
        return wrapperIntMatrix3D;
    }

    public IntMatrix3D viewSelection(int[] nArray, int[] nArray2, int[] nArray3) {
        int n;
        if (nArray == null) {
            nArray = new int[this.slices];
            n = this.slices;
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.rows];
            n = this.rows;
            while (--n >= 0) {
                nArray2[n] = n;
            }
        }
        if (nArray3 == null) {
            nArray3 = new int[this.columns];
            n = this.columns;
            while (--n >= 0) {
                nArray3[n] = n;
            }
        }
        this.checkSliceIndexes(nArray);
        this.checkRowIndexes(nArray2);
        this.checkColumnIndexes(nArray3);
        final int[] nArray4 = nArray;
        final int[] nArray5 = nArray2;
        final int[] nArray6 = nArray3;
        WrapperIntMatrix3D wrapperIntMatrix3D = new WrapperIntMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized int getQuick(int n, int n2, int n3) {
                return this.content.getQuick(nArray4[n], nArray5[n2], nArray6[n3]);
            }

            public synchronized void setQuick(int n, int n2, int n3, int n4) {
                this.content.setQuick(nArray4[n], nArray5[n2], nArray6[n3], n4);
            }

            public synchronized int get(int n, int n2, int n3) {
                return this.content.get(nArray4[n], nArray5[n2], nArray6[n3]);
            }

            public synchronized void set(int n, int n2, int n3, int n4) {
                this.content.set(nArray4[n], nArray5[n2], nArray6[n3], n4);
            }
        };
        wrapperIntMatrix3D.slices = nArray.length;
        wrapperIntMatrix3D.rows = nArray2.length;
        wrapperIntMatrix3D.columns = nArray3.length;
        wrapperIntMatrix3D.isNoView = false;
        return wrapperIntMatrix3D;
    }

    public IntMatrix3D viewStrides(final int n, final int n2, final int n3) {
        if (n <= 0 || n2 <= 0 || n3 <= 0) {
            throw new IndexOutOfBoundsException("illegal stride");
        }
        WrapperIntMatrix3D wrapperIntMatrix3D = new WrapperIntMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized int getQuick(int n4, int n22, int n32) {
                return this.content.getQuick(n * n4, n2 * n22, n3 * n32);
            }

            public synchronized void setQuick(int n5, int n22, int n32, int n4) {
                this.content.setQuick(n * n5, n2 * n22, n3 * n32, n4);
            }

            public synchronized int get(int n4, int n22, int n32) {
                return this.content.get(n * n4, n2 * n22, n3 * n32);
            }

            public synchronized void set(int n5, int n22, int n32, int n4) {
                this.content.set(n * n5, n2 * n22, n3 * n32, n4);
            }
        };
        if (this.slices != 0) {
            wrapperIntMatrix3D.slices = (this.slices - 1) / n + 1;
        }
        if (this.rows != 0) {
            wrapperIntMatrix3D.rows = (this.rows - 1) / n2 + 1;
        }
        if (this.columns != 0) {
            wrapperIntMatrix3D.columns = (this.columns - 1) / n3 + 1;
        }
        wrapperIntMatrix3D.isNoView = false;
        return wrapperIntMatrix3D;
    }

    protected IntMatrix3D getContent() {
        return this.content;
    }

    public IntMatrix2D like2D(int n, int n2) {
        throw new InternalError();
    }

    protected IntMatrix2D like2D(int n, int n2, int n3, int n4, int n5, int n6) {
        throw new InternalError();
    }

    protected IntMatrix3D viewSelectionLike(int[] nArray, int[] nArray2, int[] nArray3) {
        throw new InternalError();
    }
}

